/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.cdi.PCDIException;

public abstract class AbstractDebugCommand
implements IDebugCommand {
    protected final Object lock = new Object();
    protected BitList tasks = null;
    protected Object result = null;
    protected boolean waitForReturn = false;
    protected boolean interrupt = false;
    private boolean isFlush = false;
    protected int timeout = 10000;
    protected boolean waitInQueue = false;

    public AbstractDebugCommand(BitList tasks) {
        this(tasks, false, false, false);
    }

    public AbstractDebugCommand(BitList tasks, boolean interrupt, boolean waitForReturn) {
        this(tasks, interrupt, waitForReturn, false);
    }

    public AbstractDebugCommand(BitList tasks, boolean interrupt, boolean waitForReturn, boolean waitInQueue) {
        this.tasks = tasks;
        this.interrupt = interrupt;
        this.waitForReturn = waitForReturn;
        this.waitInQueue = waitInQueue;
    }

    public boolean isWaitInQueue() {
        return this.waitInQueue;
    }

    public boolean canInterrupt() {
        return this.interrupt;
    }

    public BitList getTasks() {
        return this.tasks;
    }

    public boolean isWaitForReturn() {
        return this.waitForReturn;
    }

    public Object getReturn() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturn(BitList tasks, Object result) {
        Object object = this.lock;
        synchronized (object) {
            this.result = result;
            if (tasks != null) {
                this.tasks = tasks;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForReturn() throws PCDIException {
        if (!this.isWaitForReturn()) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isFlush) {
                    return false;
                }
                if (this.getReturn() == null) {
                    this.lock.wait(this.timeout);
                    if (this.getReturn() == null) {
                        if (this.isFlush) {
                            return false;
                        }
                        throw new PCDIException("Time out");
                    }
                    if (this.getReturn() instanceof PCDIException) {
                        throw (PCDIException)((Object)this.getReturn());
                    }
                }
            }
            catch (InterruptedException e) {
                throw new PCDIException((Throwable)e);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelWaiting() {
        Object object = this.lock;
        synchronized (object) {
            this.waitForReturn = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.isFlush = true;
            this.lock.notifyAll();
        }
    }

    protected void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int compareTo(Object obj) {
        if (obj instanceof IDebugCommand) {
            if (!this.getName().equals(((IDebugCommand)obj).getName())) {
                return -1;
            }
            BitList cpyTasks = this.getTasks().copy();
            cpyTasks.andNot(((IDebugCommand)obj).getTasks());
            return cpyTasks.isEmpty() ? 0 : -1;
        }
        return -1;
    }
}

