/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.external.core.commands.AbstractDebugCommand;

public class HaltCommand
extends AbstractDebugCommand {
    public HaltCommand(BitList tasks) {
        super(tasks, false, true);
    }

    public void execCommand(IAbstractDebugger debugger, int timeout) throws PCDIException {
        this.setTimeout(timeout);
        debugger.filterSuspendTasks(this.tasks);
        if (!this.tasks.isEmpty()) {
            debugger.halt(this.tasks);
            this.waitFinish(debugger);
        } else {
            this.cancelWaiting();
        }
    }

    public void waitFinish(IAbstractDebugger debugger) throws PCDIException {
        if (this.waitForReturn() && this.result instanceof IPCDILocator) {
            debugger.handleProcessSignaledEvent(this.tasks, (IPCDILocator)this.result);
            return;
        }
        throw new PCDIException("Wrong type return on command: " + this.getName());
    }

    public String getName() {
        return "Halt";
    }
}

