/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.commands.AbstractDebugCommand;

public class KillCommand
extends AbstractDebugCommand {
    private boolean sendEvent = true;

    public KillCommand(BitList tasks, boolean sendEvent) {
        super(tasks, false, true);
        this.sendEvent = sendEvent;
    }

    public KillCommand(BitList tasks) {
        this(tasks, true);
    }

    public void execCommand(IAbstractDebugger debugger, int timeout) throws PCDIException {
        this.setTimeout(timeout);
        debugger.filterTerminateTasks(this.tasks);
        if (!this.tasks.isEmpty()) {
            debugger.kill(this.tasks);
            this.waitFinish(debugger);
        } else {
            this.cancelWaiting();
        }
    }

    public void waitFinish(IAbstractDebugger debugger) throws PCDIException {
        if (this.waitForReturn() && this.sendEvent) {
            debugger.handleProcessTerminatedEvent(this.tasks);
        }
    }

    public String getName() {
        return "Kill";
    }
}

