/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.commands.AbstractDebugCommand;

public class StopDebuggerCommand
extends AbstractDebugCommand {
    private boolean sendEvent = true;

    public StopDebuggerCommand(boolean sendEvent) {
        super(null, false, true);
        this.sendEvent = sendEvent;
    }

    public StopDebuggerCommand() {
        this(true);
    }

    public void execCommand(IAbstractDebugger debugger, int timeout) throws PCDIException {
        this.setTimeout(timeout);
        try {
            debugger.stopDebugger();
        }
        catch (CoreException e) {
            throw new PCDIException((Throwable)e);
        }
        this.waitFinish(debugger);
    }

    public void waitFinish(IAbstractDebugger debugger) throws PCDIException {
        if (this.waitForReturn() && this.sendEvent) {
            debugger.handleStopDebuggerEvent();
        }
    }

    public String getName() {
        return "Stop debugger";
    }
}

