/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.debugger;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IDebugger;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.IPCDICondition;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgument;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILineBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.external.core.AbstractDebugger;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.Argument;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.LocalVariable;
import org.eclipse.ptp.debug.external.core.proxy.ProxyDebugClient;
import org.eclipse.ptp.debug.external.core.proxy.ProxyDebugStackframe;
import org.eclipse.ptp.debug.external.core.proxy.event.IProxyDebugEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.IProxyDebugEventListener;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugArgsEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugBreakpointHitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugBreakpointSetEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugDataEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugErrorEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugInitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSignalEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugStackframeEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugStepEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSuspendEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugTypeEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugVarsEvent;

public class ParallelDebugger
extends AbstractDebugger
implements IDebugger,
IProxyDebugEventListener {
    private ProxyDebugClient proxy;
    private int numServers;
    private int bpId = 0;
    private IPCDIStackFrame currFrame = null;

    private String join(String[] strs, String delim) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            if (i > 0) {
                buf.append(delim);
            }
            buf.append(strs[i]);
            ++i;
        }
        return buf.toString();
    }

    public int getDebuggerPort() throws CoreException {
        this.proxy = new ProxyDebugClient();
        try {
            this.proxy.sessionCreate();
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, "could not create proxy", null));
        }
        return this.proxy.getSessionPort();
    }

    public void connection() throws CoreException {
    }

    public void startDebugger(IPJob job) throws CoreException {
        try {
            String app = (String)job.getAttribute("app_name");
            String path = (String)job.getAttribute("app_path");
            String dir = (String)job.getAttribute("work_dir");
            String[] args = (String[])job.getAttribute("args");
            this.proxy.waitForConnect();
            this.proxy.addEventListener(this);
            this.proxy.debugStartSession(app, path, dir, args);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, "Cannot start debugger", (Throwable)e));
        }
    }

    public void stopDebugger() throws CoreException {
        if (this.proxy != null) {
            try {
                this.proxy.sessionFinish();
                this.proxy = null;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 4, "Cannot stop debugger", (Throwable)e));
            }
        }
    }

    public Process getDebuggerProcess() {
        return null;
    }

    public void restart() throws PCDIException {
        throw new PCDIException("<Not implemented>", "restart");
    }

    public void run(String[] args) throws PCDIException {
        throw new PCDIException("<Not implemented>", "run");
    }

    public void go(BitList tasks) throws PCDIException {
        try {
            this.proxy.debugGo(tasks);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void kill(BitList tasks) throws PCDIException {
        this.halt(tasks);
        try {
            this.proxy.debugTerminate(tasks);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void halt(BitList tasks) throws PCDIException {
        try {
            this.proxy.debugInterrupt(tasks);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void stepInto(BitList tasks, int count) throws PCDIException {
        try {
            this.proxy.debugStep(tasks, count, 0);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void stepOver(BitList tasks, int count) throws PCDIException {
        try {
            this.proxy.debugStep(tasks, count, 1);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void stepFinish(BitList tasks, int count) throws PCDIException {
        try {
            this.proxy.debugStep(tasks, count, 2);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void setLineBreakpoint(BitList tasks, IPCDILineBreakpoint bpt) throws PCDIException {
        try {
            IPCDICondition condition = bpt.getCondition();
            this.proxy.debugSetLineBreakpoint(tasks, this.newBreakpointId(), bpt.isTemporary(), bpt.isHardware(), bpt.getLocator().getFile(), bpt.getLocator().getLineNumber(), condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0, 0);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void setFunctionBreakpoint(BitList tasks, IPCDIFunctionBreakpoint bpt) throws PCDIException {
        try {
            IPCDICondition condition = bpt.getCondition();
            this.proxy.debugSetFuncBreakpoint(tasks, this.newBreakpointId(), bpt.isTemporary(), bpt.isHardware(), bpt.getLocator().getFile(), bpt.getLocator().getFunction(), condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0, 0);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void deleteBreakpoint(BitList tasks, int bpid) throws PCDIException {
        try {
            this.proxy.debugDeleteBreakpoint(tasks, bpid);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void enableBreakpoint(BitList tasks, int bpid) throws PCDIException {
        try {
            this.proxy.debugEnableBreakpoint(tasks, bpid);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void disableBreakpoint(BitList tasks, int bpid) throws PCDIException {
        try {
            this.proxy.debugDisableBreakpoint(tasks, bpid);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void conditionBreakpoint(BitList tasks, int bpid, String expr) throws PCDIException {
        try {
            this.proxy.debugConditionBreakpoint(tasks, bpid, expr);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void listStackFrames(BitList tasks) throws PCDIException {
        try {
            this.proxy.debugListStackframes(tasks, 0);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void setCurrentStackFrame(BitList tasks, IPCDIStackFrame frame) throws PCDIException {
        try {
            this.proxy.debugSetCurrentStackframe(tasks, frame.getLevel());
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void evaluateExpression(BitList tasks, String expr) throws PCDIException {
        try {
            this.proxy.debugEvaluateExpression(tasks, expr);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void getAIFValue(BitList tasks, String expr) throws PCDIException {
        this.evaluateExpression(tasks, expr);
    }

    public void getVariableType(BitList tasks, String varName) throws PCDIException {
        try {
            this.proxy.debugGetType(tasks, varName);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void listLocalVariables(BitList tasks, IPCDIStackFrame frame) throws PCDIException {
        this.currFrame = frame;
        try {
            this.proxy.debugListLocalVariables(tasks);
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void listGlobalVariables(BitList tasks) throws PCDIException {
        throw new PCDIException("<Not implemented>", "listGlobalVariables");
    }

    public void listArguments(BitList tasks, IPCDIStackFrame frame) throws PCDIException {
        this.currFrame = frame;
        try {
            this.proxy.debugListArguments(tasks, frame.getLevel());
        }
        catch (IOException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public synchronized void handleEvent(IProxyDebugEvent e) {
        System.out.println("got debug event: " + e.toString());
        switch (e.getEventID()) {
            case 111: {
                this.completeCommand(e.getBitSet(), "OK");
                break;
            }
            case 110: {
                this.numServers = ((ProxyDebugInitEvent)e).getNumServers();
                System.out.println("num servers = " + this.numServers);
                this.completeCommand(e.getBitSet(), "OK");
                break;
            }
            case 100: {
                ProxyDebugBreakpointHitEvent bptHitEvent = (ProxyDebugBreakpointHitEvent)e;
                this.handleBreakpointHitEvent(e.getBitSet(), bptHitEvent.getBreakpointId());
                break;
            }
            case 113: {
                ProxyDebugSuspendEvent suspendEvent = (ProxyDebugSuspendEvent)e;
                this.handleSuspendEvent(e.getBitSet(), suspendEvent.getLocator());
                break;
            }
            case 103: {
                ProxyDebugStepEvent stepEvent = (ProxyDebugStepEvent)e;
                this.handleEndSteppingEvent(e.getBitSet(), stepEvent.getFrame().getLocator().getLineNumber(), stepEvent.getFrame().getLocator().getFile());
                break;
            }
            case 104: {
                ProxyDebugBreakpointSetEvent bpEvt = (ProxyDebugBreakpointSetEvent)e;
                this.completeCommand(e.getBitSet(), bpEvt.getBreakpoint());
                break;
            }
            case 105: {
                ProxyDebugStackframeEvent frameEvent = (ProxyDebugStackframeEvent)e;
                IPProcess[] frameProcs = this.getProcesses(e.getBitSet());
                if (frameProcs.length <= 0) break;
                this.completeCommand(e.getBitSet(), this.convertFrames(frameProcs[0], frameEvent.getFrames()));
                break;
            }
            case 107: {
                ProxyDebugTypeEvent type = (ProxyDebugTypeEvent)e;
                this.completeCommand(e.getBitSet(), type.getType());
                break;
            }
            case 106: {
                ProxyDebugDataEvent data = (ProxyDebugDataEvent)e;
                this.completeCommand(e.getBitSet(), data.getData());
                break;
            }
            case 108: {
                if (this.currFrame == null) {
                    return;
                }
                ProxyDebugVarsEvent varsEvent = (ProxyDebugVarsEvent)e;
                ArrayList<LocalVariable> varList = new ArrayList<LocalVariable>();
                IPProcess[] varProcs = this.getProcesses(varsEvent.getBitSet());
                if (varProcs.length > 0) {
                    int taskId = varProcs[0].getTaskId();
                    IPCDITarget target = this.getSession().getTarget(taskId);
                    Thread thread = new Thread((Target)target, 0);
                    String[] vars = varsEvent.getVariables();
                    int j = 0;
                    while (j < vars.length) {
                        LocalVariable var = new LocalVariable((Target)target, thread, (StackFrame)this.currFrame, vars[j], vars[j], vars.length - j, this.currFrame.getLevel(), null);
                        varList.add(var);
                        ++j;
                    }
                }
                this.completeCommand(e.getBitSet(), varList.toArray(new IPCDILocalVariable[0]));
                break;
            }
            case 109: {
                if (this.currFrame == null) {
                    return;
                }
                ProxyDebugArgsEvent argsEvent = (ProxyDebugArgsEvent)e;
                ArrayList<Argument> argList = new ArrayList<Argument>();
                IPProcess[] argProcs = this.getProcesses(argsEvent.getBitSet());
                if (argProcs.length > 0) {
                    int taskId = argProcs[0].getTaskId();
                    IPCDITarget target = this.getSession().getTarget(taskId);
                    Thread thread = new Thread((Target)target, 0);
                    String[] args = argsEvent.getVariables();
                    int j = 0;
                    while (j < args.length) {
                        Argument arg = new Argument((Target)target, thread, (StackFrame)this.currFrame, args[j], args[j], args.length - j, this.currFrame.getLevel(), null);
                        argList.add(arg);
                        ++j;
                    }
                }
                this.completeCommand(e.getBitSet(), argList.toArray(new IPCDIArgument[0]));
                break;
            }
            case 102: {
                System.out.println("======================= EVENT_DBG_EXIT ====================");
                this.handleProcessTerminatedEvent(e.getBitSet());
                break;
            }
            case 101: {
                ProxyDebugSignalEvent sigEvent = (ProxyDebugSignalEvent)e;
                this.completeCommand(e.getBitSet(), sigEvent.getLocator());
                break;
            }
            case 112: {
                System.err.println("======================= EVENT_DBG_ERROR ====================");
                ProxyDebugErrorEvent errEvent = (ProxyDebugErrorEvent)e;
                this.completeCommand(e.getBitSet(), (Object)new PCDIException(errEvent.getErrorMessage(), this.getErrorCode(errEvent.getErrorCode())));
            }
        }
    }

    private int getErrorCode(int internalErrorCode) {
        switch (internalErrorCode) {
            case 4: 
            case 26: 
            case 33: {
                return 2;
            }
            case 38: {
                return 0;
            }
        }
        return 1;
    }

    private IPCDIStackFrame convertFrame(IPCDIThread thread, ProxyDebugStackframe frame) {
        int level = frame.getLevel();
        String file = frame.getLocator().getFile();
        String func = frame.getLocator().getFunction();
        int line = frame.getLocator().getLineNumber();
        BigInteger addr = frame.getLocator().getAddress();
        System.out.println("frame " + level + " " + file + " " + func + " " + line + " " + addr);
        return new StackFrame((Thread)thread, level, file, func, line, addr.toString(16));
    }

    private IPCDIStackFrame[] convertFrames(IPProcess proc, ProxyDebugStackframe[] frames) {
        ArrayList<IPCDIStackFrame> frameList = new ArrayList<IPCDIStackFrame>();
        int taskId = proc.getTaskId();
        IPCDITarget target = this.getSession().getTarget(taskId);
        Thread thread = new Thread((Target)target, 0);
        int j = 0;
        while (j < frames.length) {
            frameList.add(this.convertFrame(thread, frames[j]));
            ++j;
        }
        return frameList.toArray(new IPCDIStackFrame[0]);
    }

    private int newBreakpointId() {
        return this.bpId++;
    }
}

