/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ptp.core.proxy.AbstractProxyClient;
import org.eclipse.ptp.core.proxy.event.IProxyEvent;
import org.eclipse.ptp.core.proxy.event.IProxyEventListener;
import org.eclipse.ptp.core.proxy.event.ProxyErrorEvent;
import org.eclipse.ptp.core.proxy.event.ProxyOKEvent;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.external.core.proxy.event.IProxyDebugEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.IProxyDebugEventListener;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugErrorEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugEvent;

public abstract class AbstractProxyDebugClient
extends AbstractProxyClient
implements IProxyEventListener {
    protected List listeners = new ArrayList(2);
    private boolean waiting = false;
    private boolean connected = false;

    public AbstractProxyDebugClient() {
        super.addEventListener((IProxyEventListener)this);
    }

    public synchronized void waitForConnect() throws IOException {
        try {
            while (!this.connected) {
                this.waiting = true;
                ((Object)((Object)this)).wait();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void sendCommand(String cmd, BitList set) throws IOException {
        String setStr = this.encodeBitSet(set);
        this.sendCommand(cmd, setStr);
    }

    protected void sendCommand(String cmd, BitList set, String arg1) throws IOException {
        String setStr = this.encodeBitSet(set);
        this.sendCommand(cmd, setStr, arg1);
    }

    protected void sendCommand(String cmd, BitList set, String arg1, String arg2) throws IOException {
        String setStr = this.encodeBitSet(set);
        this.sendCommand(cmd, setStr, arg1, arg2);
    }

    protected void sendCommand(String cmd, BitList set, String[] args) throws IOException {
        String setStr = this.encodeBitSet(set);
        this.sendCommand(cmd, setStr, args);
    }

    public void addEventListener(IProxyDebugEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(IProxyDebugEventListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void handleEvent(IProxyEvent event) {
        IProxyDebugEvent e = null;
        System.out.println("AbstractProxyDebugClientgot event " + event);
        if (this.listeners == null) {
            return;
        }
        switch (event.getEventID()) {
            case 0: {
                e = (IProxyDebugEvent)ProxyDebugEvent.toEvent(((ProxyOKEvent)event).getData());
                break;
            }
            case 1: {
                e = new ProxyDebugErrorEvent(new BitList(0), ((ProxyErrorEvent)event).getErrorCode(), ((ProxyErrorEvent)event).getErrorMessage());
                break;
            }
            case 2: {
                this.connected = true;
                if (this.waiting) {
                    ((Object)((Object)this)).notifyAll();
                    this.waiting = false;
                }
                return;
            }
        }
        if (e != null) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                IProxyDebugEventListener listener = (IProxyDebugEventListener)i.next();
                listener.handleEvent(e);
            }
        }
    }
}

