/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.proxy;

import java.io.IOException;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.external.core.proxy.AbstractProxyDebugClient;

public class ProxyDebugClient
extends AbstractProxyDebugClient {
    public static final int STEP_INTO = 0;
    public static final int STEP_OVER = 1;
    public static final int STEP_FINISH = 2;

    public void debugStartSession(String prog, String path, String dir, String[] args) throws IOException {
        this.sendCommand("INI", prog, path, dir, args);
    }

    public void debugSetLineBreakpoint(BitList procs, int bpid, boolean isTemporary, boolean isHardware, String file, int line, String expression, int ignoreCount, int tid) throws IOException {
        String[] args = new String[]{Integer.toString(bpid), Integer.toString(isTemporary ? 1 : 0), Integer.toString(isHardware ? 1 : 0), file, Integer.toString(line), expression, Integer.toString(ignoreCount), Integer.toString(tid)};
        this.sendCommand("SLB", procs, args);
    }

    public void debugSetFuncBreakpoint(BitList procs, int bpid, boolean isTemporary, boolean isHardware, String file, String func, String expression, int ignoreCount, int tid) throws IOException {
        String[] args = new String[]{Integer.toString(bpid), Integer.toString(isTemporary ? 1 : 0), Integer.toString(isHardware ? 1 : 0), file, func, expression, Integer.toString(ignoreCount), Integer.toString(tid)};
        this.sendCommand("SFB", procs, args);
    }

    public void debugDeleteBreakpoint(BitList procs, int bpid) throws IOException {
        this.sendCommand("DBP", procs, Integer.toString(bpid));
    }

    public void debugEnableBreakpoint(BitList procs, int bpid) throws IOException {
        this.sendCommand("EAB", procs, Integer.toString(bpid));
    }

    public void debugDisableBreakpoint(BitList procs, int bpid) throws IOException {
        this.sendCommand("DAB", procs, Integer.toString(bpid));
    }

    public void debugConditionBreakpoint(BitList procs, int bpid, String expr) throws IOException {
        this.sendCommand("CBP", procs, Integer.toString(bpid), expr);
    }

    public void debugGo(BitList procs) throws IOException {
        this.sendCommand("GOP", procs);
    }

    public void debugStep(BitList procs, int count, int type) throws IOException {
        this.sendCommand("STP", procs, Integer.toString(count), Integer.toString(type));
    }

    public void debugTerminate(BitList procs) throws IOException {
        this.sendCommand("TRM", procs);
    }

    public void debugInterrupt(BitList procs) throws IOException {
        this.sendCommand("HLT", procs);
    }

    public void debugListStackframes(BitList procs, int current) throws IOException {
        this.sendCommand("LSF", procs, Integer.toString(current));
    }

    public void debugSetCurrentStackframe(BitList procs, int level) throws IOException {
        this.sendCommand("SCS", procs, Integer.toString(level));
    }

    public void debugEvaluateExpression(BitList procs, String expr) throws IOException {
        this.sendCommand("EEX", procs, expr);
    }

    public void debugGetType(BitList procs, String expr) throws IOException {
        this.sendCommand("TYP", procs, expr);
    }

    public void debugListLocalVariables(BitList procs) throws IOException {
        this.sendCommand("LLV", procs);
    }

    public void debugListArguments(BitList procs, int level) throws IOException {
        this.sendCommand("LAR", procs, Integer.toString(level));
    }

    public void debugListGlobalVariables(BitList procs) throws IOException {
        this.sendCommand("LGV", procs);
    }
}

