/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.proxy.event;

import java.math.BigInteger;
import org.eclipse.ptp.core.proxy.event.IProxyEvent;
import org.eclipse.ptp.core.proxy.event.ProxyEvent;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.ExtFormat;
import org.eclipse.ptp.debug.core.aif.AIF;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.IPCDICondition;
import org.eclipse.ptp.debug.core.cdi.IPCDILineLocation;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.external.core.cdi.Condition;
import org.eclipse.ptp.debug.external.core.cdi.Locator;
import org.eclipse.ptp.debug.external.core.cdi.breakpoints.LineBreakpoint;
import org.eclipse.ptp.debug.external.core.cdi.model.LineLocation;
import org.eclipse.ptp.debug.external.core.proxy.ProxyDebugStackframe;
import org.eclipse.ptp.debug.external.core.proxy.event.AbstractProxyDebugEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugArgsEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugBreakpointHitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugBreakpointSetEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugDataEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugErrorEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugExitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugInitEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugOKEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSignalEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugStackframeEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugStepEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugSuspendEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugTypeEvent;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugVarsEvent;

public class ProxyDebugEvent
extends ProxyEvent {
    public static IProxyEvent toEvent(String str) {
        AbstractProxyDebugEvent evt = null;
        String[] args = str.split(" ");
        int type = Integer.parseInt(args[0]);
        BitList set = ProxyEvent.decodeBitSet((String)args[1]);
        switch (type) {
            case 111: {
                evt = new ProxyDebugOKEvent(set);
                break;
            }
            case 112: {
                int errCode = Integer.parseInt(args[2]);
                evt = new ProxyDebugErrorEvent(set, errCode, ProxyDebugEvent.decodeString((String)args[3]));
                break;
            }
            case 100: {
                int hitId = Integer.parseInt(args[2]);
                evt = new ProxyDebugBreakpointHitEvent(set, hitId);
                break;
            }
            case 104: {
                int setId = Integer.parseInt(args[2]);
                IPCDILineLocation loc = ProxyDebugEvent.toLineLocation(args[8], args[11]);
                IPCDIBreakpoint bpt = ProxyDebugEvent.toBreakpoint(args[4], args[5], args[6], args[7], loc);
                evt = new ProxyDebugBreakpointSetEvent(set, setId, bpt);
                break;
            }
            case 101: {
                int sigTid = Integer.parseInt(args[4]);
                IPCDILocator sigLoc = null;
                if (args[5].compareTo("*") != 0) {
                    sigLoc = ProxyDebugEvent.toLocator(args[6], args[7], args[8], args[9]);
                }
                evt = new ProxyDebugSignalEvent(set, ProxyDebugEvent.decodeString((String)args[2]), ProxyDebugEvent.decodeString((String)args[3]), sigTid, sigLoc);
                break;
            }
            case 102: {
                int status = Integer.parseInt(args[2]);
                evt = new ProxyDebugExitEvent(set, status);
                break;
            }
            case 113: {
                IPCDILocator suspendLoc = ProxyDebugEvent.toLocator(args[3], args[4], args[5], args[6]);
                evt = new ProxyDebugSuspendEvent(set, suspendLoc);
                break;
            }
            case 103: {
                ProxyDebugStackframe frame = ProxyDebugEvent.toFrame(args[2], args[3], args[4], args[6], args[5]);
                evt = new ProxyDebugStepEvent(set, frame);
                break;
            }
            case 105: {
                int numFrames = Integer.parseInt(args[2]);
                ProxyDebugStackframe[] frames = new ProxyDebugStackframe[numFrames];
                int i = 0;
                while (i < numFrames) {
                    int frameLevel = Integer.parseInt(args[5 * i + 3]);
                    int line = Integer.parseInt(args[5 * i + 7]);
                    frames[i] = new ProxyDebugStackframe(frameLevel, ProxyDebugEvent.decodeString((String)args[5 * i + 4]), ProxyDebugEvent.decodeString((String)args[5 * i + 5]), line, ProxyDebugEvent.decodeString((String)args[5 * i + 6]));
                    ++i;
                }
                evt = new ProxyDebugStackframeEvent(set, frames);
                break;
            }
            case 106: {
                AIF data = new AIF(ProxyDebugEvent.decodeString((String)args[2]), ProxyDebugEvent.decodeBytes((String)args[3]), ProxyDebugEvent.decodeString((String)args[4]));
                evt = new ProxyDebugDataEvent(set, (IAIF)data);
                break;
            }
            case 107: {
                evt = new ProxyDebugTypeEvent(set, ProxyDebugEvent.decodeString((String)args[2]));
                break;
            }
            case 108: {
                int numVars = Integer.parseInt(args[2]);
                String[] vars = new String[numVars];
                int i = 0;
                while (i < numVars) {
                    vars[i] = ProxyDebugEvent.decodeString((String)args[i + 3]);
                    ++i;
                }
                evt = new ProxyDebugVarsEvent(set, vars);
                break;
            }
            case 109: {
                int numArgs = Integer.parseInt(args[2]);
                String[] arg_strs = new String[numArgs];
                int i = 0;
                while (i < numArgs) {
                    arg_strs[i] = ProxyDebugEvent.decodeString((String)args[i + 3]);
                    ++i;
                }
                evt = new ProxyDebugArgsEvent(set, arg_strs);
                break;
            }
            case 110: {
                int num_servers = Integer.parseInt(args[2]);
                evt = new ProxyDebugInitEvent(set, num_servers);
            }
        }
        return evt;
    }

    public static BigInteger decodeAddr(String str) {
        String[] parts = str.split(":");
        int len = Integer.parseInt(parts[0], 16) - 1;
        byte[] strBytes = new byte[len];
        int i = 0;
        int p = 0;
        while (i < len) {
            byte c = (byte)((Character.digit(parts[1].charAt(p), 16) & 0xF) << 4);
            strBytes[i] = c = (byte)(c | (byte)(Character.digit(parts[1].charAt(p + 1), 16) & 0xF));
            ++i;
            p += 2;
        }
        BigInteger a = new BigInteger(strBytes);
        return a;
    }

    public static IPCDIBreakpoint toBreakpoint(String ignoreStr, String spec, String del, String typeStr, IPCDILineLocation loc) {
        LineBreakpoint bpt = null;
        int ignore = Integer.parseInt(ignoreStr);
        Condition cond = new Condition(ignore, null, null);
        String type = ProxyDebugEvent.decodeString((String)typeStr);
        int typeVal = type.compareTo("breakpoint") == 0 ? 0 : (type.compareTo("hw") == 0 ? 2 : 1);
        bpt = new LineBreakpoint(typeVal, loc, (IPCDICondition)cond);
        return bpt;
    }

    public static IPCDILineLocation toLineLocation(String fileStr, String lineStr) {
        String file = ProxyDebugEvent.decodeString((String)fileStr);
        int line = Integer.parseInt(lineStr);
        return new LineLocation(file, line);
    }

    public static IPCDILocator toLocator(String fileStr, String funcStr, String addrStr, String lineStr) {
        String file = ProxyDebugEvent.decodeString((String)fileStr);
        String func = ProxyDebugEvent.decodeString((String)funcStr);
        int line = Integer.parseInt(lineStr);
        String addr = ProxyDebugEvent.decodeString((String)addrStr);
        return new Locator(file, func, line, ExtFormat.getBigInteger((String)addr));
    }

    public static ProxyDebugStackframe toFrame(String level, String file, String func, String line, String addr) {
        int stepLevel = Integer.parseInt(level);
        int stepLine = Integer.parseInt(line);
        return new ProxyDebugStackframe(stepLevel, ProxyDebugEvent.decodeString((String)file), ProxyDebugEvent.decodeString((String)func), stepLine, ProxyDebugEvent.decodeString((String)addr));
    }
}

