/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.simulator;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ptp.debug.external.core.simulator.DInputStream;
import org.eclipse.ptp.debug.external.core.simulator.DOutputStream;
import org.eclipse.ptp.debug.external.core.simulator.DQueue;
import org.eclipse.ptp.debug.external.core.simulator.DebugSimulator;

public class DProcess
extends Process {
    boolean finished;
    InputStream err;
    InputStream in;
    OutputStream out;
    int id;
    String name;
    DQueue commands;
    Thread procThread;
    DebugSimulator dD;

    public DProcess(String nm, int pId, int numThreads, DQueue cmds, DebugSimulator debugger) {
        this.dD = debugger;
        this.finished = false;
        this.id = pId;
        this.name = nm;
        this.commands = cmds;
        this.err = null;
        this.in = new DInputStream();
        this.out = new DOutputStream();
        this.procThread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        String output = (String)DProcess.this.commands.removeItem();
                        ((DInputStream)DProcess.this.in).printString(output);
                        if (!output.equals("exit")) continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                DProcess.this.finished = true;
                ((DInputStream)DProcess.this.in).destroy();
            }
        };
        this.procThread.start();
    }

    public int exitValue() {
        if (this.finished) {
            return 0;
        }
        throw new IllegalThreadStateException();
    }

    public int waitFor() throws InterruptedException {
        try {
            this.procThread.join();
        }
        catch (InterruptedException interruptedException) {}
        return 0;
    }

    public void destroy() {
        this.finished = true;
        ((DInputStream)this.in).destroy();
    }

    public InputStream getErrorStream() {
        return this.err;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }
}

