/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.simulator;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IDebugger;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILineBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.external.core.AbstractDebugger;
import org.eclipse.ptp.debug.external.core.PTPDebugExternalPlugin;
import org.eclipse.ptp.debug.external.core.cdi.breakpoints.LineBreakpoint;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.Argument;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.LocalVariable;
import org.eclipse.ptp.debug.external.core.simulator.DProcess;
import org.eclipse.ptp.debug.external.core.simulator.DQueue;
import org.eclipse.ptp.rtsystem.simulation.SimProcess;
import org.eclipse.ptp.rtsystem.simulation.SimStackFrame;
import org.eclipse.ptp.rtsystem.simulation.SimThread;
import org.eclipse.ptp.rtsystem.simulation.SimVariable;

public class DebugSimulator
extends AbstractDebugger
implements IDebugger,
Observer {
    final int RUNNING = 10;
    final int SUSPENDED = 11;
    int state = 0;
    boolean finished = false;
    private Process debuggerProcess = null;
    DQueue debuggerOutput = null;

    public void connection() {
        this.completeCommand(null, "OK");
    }

    public void getAIFValue(BitList tasks, String expr) throws PCDIException {
        throw new PCDIException("not implemented yet");
    }

    private void initializeSimulatedProcessesCode(DQueue dQ) {
        dQ.addItem("DEBUG SIMULATOR");
        dQ.addItem("Look at this console window for output from the Debug Simulator");
        dQ.addItem("  ");
    }

    public int getDebuggerPort() {
        return 0;
    }

    public void startDebugger(IPJob job) {
        this.state = 11;
        this.debuggerOutput = new DQueue();
        this.initializeSimulatedProcessesCode(this.debuggerOutput);
        this.debuggerProcess = new DProcess("Debugger", -1, 1, this.debuggerOutput, this);
        int i = 0;
        while (i < this.procs.length) {
            ((SimProcess)this.procs[i]).getThread(0).addObserver((Observer)this);
            ++i;
        }
    }

    public void stopDebugger() {
        PTPDebugExternalPlugin.getDefault().getLogger().finer("");
        this.finished = true;
    }

    public Process getDebuggerProcess() {
        return this.debuggerProcess;
    }

    public void listStackFrames(BitList tasks) throws PCDIException {
        ArrayList<StackFrame> list = new ArrayList<StackFrame>();
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            int taskId = processes[i].getTaskId();
            IPCDITarget target = this.getSession().getTarget(taskId);
            SimThread simThread = ((SimProcess)processes[i]).getThread(0);
            Thread thread = new Thread((Target)target, simThread.getThreadId());
            SimStackFrame[] simFrames = simThread.getStackFrames();
            int j = 0;
            while (j < simFrames.length) {
                int level = simFrames[j].getLevel();
                String file = simFrames[j].getFile();
                String func = simFrames[j].getFunction();
                int line = simFrames[j].getLine();
                String addr = simFrames[j].getAddress();
                StackFrame frame = new StackFrame(thread, level, file, func, line, addr);
                list.add(frame);
                ++j;
            }
            ++i;
        }
        throw new PCDIException("Need reimplemented again");
    }

    public void setCurrentStackFrame(BitList tasks, IPCDIStackFrame frame) throws PCDIException {
        throw new PCDIException("not implemented yet");
    }

    public void evaluateExpression(BitList tasks, String expr) throws PCDIException {
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            SimThread simThread = ((SimProcess)processes[i]).getThread(0);
            SimStackFrame[] simFrames = simThread.getStackFrames();
            int j = 0;
            while (j < simFrames.length) {
                SimVariable[] args = simFrames[j].getArgs();
                int k = 0;
                while (k < args.length) {
                    String aName = args[k].getName();
                    args[k].getValue();
                    aName.equals(expr);
                    ++k;
                }
                SimVariable[] local = simFrames[j].getLocalVars();
                int k2 = 0;
                while (k2 < local.length) {
                    String aName = local[k2].getName();
                    local[k2].getValue();
                    aName.equals(expr);
                    ++k2;
                }
                ++j;
            }
            ++i;
        }
        throw new PCDIException("Need reimplemented again");
    }

    public void getVariableType(BitList tasks, String varName) throws PCDIException {
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            SimThread simThread = ((SimProcess)processes[i]).getThread(0);
            SimStackFrame[] simFrames = simThread.getStackFrames();
            int j = 0;
            while (j < simFrames.length) {
                SimVariable[] args = simFrames[j].getArgs();
                int k = 0;
                while (k < args.length) {
                    String aName = args[k].getName();
                    args[k].getType();
                    aName.equals(varName);
                    ++k;
                }
                SimVariable[] local = simFrames[j].getLocalVars();
                int k2 = 0;
                while (k2 < local.length) {
                    String aName = local[k2].getName();
                    local[k2].getType();
                    aName.equals(varName);
                    ++k2;
                }
                ++j;
            }
            ++i;
        }
        throw new PCDIException("Need reimplemented again");
    }

    public void listArguments(BitList tasks, IPCDIStackFrame frame) throws PCDIException {
        ArrayList<Argument> list = new ArrayList<Argument>();
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            int taskId = processes[i].getTaskId();
            IPCDITarget target = this.getSession().getTarget(taskId);
            SimThread simThread = ((SimProcess)processes[i]).getThread(0);
            Thread thread = new Thread((Target)target, simThread.getThreadId());
            SimStackFrame[] simFrames = simThread.getStackFrames();
            int j = 0;
            while (j < simFrames.length) {
                String addr;
                int line;
                String func;
                String file;
                int level = simFrames[j].getLevel();
                StackFrame newFrame = new StackFrame(thread, level, file = simFrames[j].getFile(), func = simFrames[j].getFunction(), line = simFrames[j].getLine(), addr = simFrames[j].getAddress());
                if (newFrame.getLocator().equals((ICDILocation)frame.getLocator())) {
                    SimVariable[] args = simFrames[j].getArgs();
                    int k = 0;
                    while (k < args.length) {
                        String aName = args[k].getName();
                        Argument arg = new Argument((Target)target, thread, (StackFrame)frame, aName, aName, args.length - k, frame.getLevel(), null);
                        list.add(arg);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        throw new PCDIException("Need reimplemented again");
    }

    public void listLocalVariables(BitList tasks, IPCDIStackFrame frame) throws PCDIException {
        ArrayList<LocalVariable> list = new ArrayList<LocalVariable>();
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            int taskId = processes[i].getTaskId();
            IPCDITarget target = this.getSession().getTarget(taskId);
            SimThread simThread = ((SimProcess)processes[i]).getThread(0);
            Thread thread = new Thread((Target)target, simThread.getThreadId());
            SimStackFrame[] simFrames = simThread.getStackFrames();
            int j = 0;
            while (j < simFrames.length) {
                String addr;
                int line;
                String func;
                String file;
                int level = simFrames[j].getLevel();
                StackFrame newFrame = new StackFrame(thread, level, file = simFrames[j].getFile(), func = simFrames[j].getFunction(), line = simFrames[j].getLine(), addr = simFrames[j].getAddress());
                if (newFrame.getLocator().equals((ICDILocation)frame.getLocator())) {
                    SimVariable[] args = simFrames[j].getLocalVars();
                    int k = 0;
                    while (k < args.length) {
                        String aName = args[k].getName();
                        LocalVariable arg = new LocalVariable((Target)target, thread, (StackFrame)frame, aName, aName, args.length - k, frame.getLevel(), null);
                        list.add(arg);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        throw new PCDIException("Need reimplemented again");
    }

    public void listGlobalVariables(BitList tasks) throws PCDIException {
        throw new PCDIException("not implemented yet");
    }

    public void stepInto(BitList tasks, int count) throws PCDIException {
        PTPDebugExternalPlugin.getDefault().getLogger().finer("");
        this.state = 10;
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            ((SimProcess)processes[i]).getThread(0).stepInto(count);
            ++i;
        }
    }

    public void stepOver(BitList tasks, int count) throws PCDIException {
        PTPDebugExternalPlugin.getDefault().getLogger().finer("");
        this.state = 10;
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            ((SimProcess)processes[i]).getThread(0).stepOver(count);
            ++i;
        }
    }

    public void stepFinish(BitList tasks, int count) throws PCDIException {
        PTPDebugExternalPlugin.getDefault().getLogger().finer("");
        this.state = 10;
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            ((SimProcess)processes[i]).getThread(0).stepFinish(count);
            ++i;
        }
    }

    public void go(BitList tasks) throws PCDIException {
        PTPDebugExternalPlugin.getDefault().getLogger().finer("");
        this.state = 10;
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            SimProcess p = (SimProcess)processes[i];
            if (!p.getStatus().equals("exited")) {
                p.getThread(0).resume();
            }
            ++i;
        }
    }

    public void halt(BitList tasks) throws PCDIException {
        PTPDebugExternalPlugin.getDefault().getLogger().finer("");
        this.state = 11;
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            SimProcess p = (SimProcess)processes[i];
            if (!p.getStatus().equals("exited")) {
                p.getThread(0).suspend();
            }
            ++i;
        }
    }

    public void kill(BitList tasks) throws PCDIException {
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            processes[i].setTerminated(true);
            ++i;
        }
    }

    public void run(String[] args) throws PCDIException {
    }

    public void restart() throws PCDIException {
    }

    public void setLineBreakpoint(BitList tasks, IPCDILineBreakpoint bpt) throws PCDIException {
        PTPDebugExternalPlugin.getDefault().getLogger().finer("");
        int line = ((LineBreakpoint)bpt).getLineNumber();
        IPProcess[] processes = this.getProcesses(tasks);
        int i = 0;
        while (i < processes.length) {
            ((SimProcess)processes[i]).getThread(0).addBreakpoint(line);
            ++i;
        }
    }

    public void setFunctionBreakpoint(BitList tasks, IPCDIFunctionBreakpoint bpt) throws PCDIException {
        PTPDebugExternalPlugin.getDefault().getLogger().finer("");
    }

    public void deleteBreakpoint(BitList tasks, int bpid) throws PCDIException {
    }

    public void enableBreakpoint(BitList tasks, int bpid) throws PCDIException {
    }

    public void disableBreakpoint(BitList tasks, int bpid) throws PCDIException {
    }

    public void conditionBreakpoint(BitList tasks, int bpid, String expr) throws PCDIException {
    }

    public void update(Observable o, Object arg) {
        ArrayList list = (ArrayList)arg;
        int procId = (Integer)list.get(0);
        String event = (String)list.get(1);
        BitList procs = new BitList(this.procs.length);
        procs.set(procId);
        if (event.equals("BREAKPOINTHIT")) {
            this.debuggerOutput.addItem("BreakpointHit Event for " + procId);
        } else if (event.equals("ENDSTEPPINGRANGE")) {
            this.handleEndSteppingEvent(procs, (Integer)list.get(3), (String)list.get(2));
            this.debuggerOutput.addItem("EndSteppingRange Event for " + procId);
        } else if (event.equals("RESUMED")) {
            this.handleProcessResumedEvent(procs);
            this.debuggerOutput.addItem("InferiorResumed Event for " + procId);
        } else if (event.equals("TERMINATED")) {
            this.handleProcessTerminatedEvent(procs);
            this.debuggerOutput.addItem("InferiorExited Event for " + procId);
        } else if (event.equals("SUSPENDED")) {
            this.handleEndSteppingEvent(procs, (Integer)list.get(3), (String)list.get(2));
            this.debuggerOutput.addItem("EndSteppingRange Event for " + procId);
        }
    }
}

