/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.simulator2;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.eclipse.ptp.debug.external.core.simulator2.DebugSimulation2;
import org.eclipse.ptp.debug.external.core.simulator2.SimulateFrame;

public class SimulateProgram
extends Observable
implements Runnable {
    public static final int SIM_PROGRAM_LINE = 37;
    public static final int MAIN_METHOD_LINE = 6;
    private final int END_STEP_LINE = 15;
    private int start_step_line = 0;
    private int current_line = 0;
    private boolean isStepping = false;
    private int tid = -1;
    private String file = "";
    private List lines = new ArrayList();
    private List bpts = new ArrayList();
    private boolean isStopInMain = false;
    private boolean isPause = false;

    public SimulateProgram(int tid, String file) {
        this.tid = tid;
        this.file = file;
    }

    public SimulateFrame[] getSimStackFrames() {
        int frameLength = DebugSimulation2.random(1, 3);
        String addr = "0x" + DebugSimulation2.random(10000, 50000);
        SimulateFrame[] frames = new SimulateFrame[frameLength];
        int i = 0;
        while (i < frames.length) {
            frames[i] = new SimulateFrame(i, this.file, this.file, this.current_line - i, addr);
            ++i;
        }
        return frames;
    }

    private synchronized void waitForNotify() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            System.out.println("----- Err in waiting: " + e.getMessage());
        }
    }

    private void waitForWhile(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            System.out.println("----- Err in waiting: " + e.getMessage());
        }
    }

    public synchronized void run() {
        this.notifyAll();
        this.waitForNotify();
        while (this.current_line < 37) {
            if (this.isStopInMain) {
                this.isStopInMain = false;
                this.printMessage();
                this.gotoLine(6);
                continue;
            }
            if (this.isPause) {
                this.printMessage();
                this.setChanged();
                this.notifyObservers(new String[]{String.valueOf(this.tid), "STEP_END", this.file, String.valueOf(this.current_line)});
                this.waitForNotify();
                continue;
            }
            if (this.isHitBreakpoint(this.current_line)) {
                this.isPause = true;
                this.printMessage();
                this.setChanged();
                this.notifyObservers(new String[]{String.valueOf(this.tid), "HIT_BPT", this.file, String.valueOf(this.getHitBreakpointID(this.current_line))});
                this.waitForNotify();
                continue;
            }
            if (this.isStepping) {
                this.printMessage();
                this.setChanged();
                this.notifyObservers(new String[]{String.valueOf(this.tid), "STEP_END", this.file, String.valueOf(this.current_line)});
                this.waitForNotify();
                continue;
            }
            this.printMessage();
            this.nextLine();
            this.waitForWhile(50L);
        }
        System.out.println("==== finished: " + this.tid);
        this.setChanged();
        this.notifyObservers(new String[]{String.valueOf(this.tid), "EXIT", this.file, String.valueOf(this.current_line)});
    }

    public synchronized void startProgram() {
        new Thread(this).start();
        try {
            this.wait(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void stopProgram() {
        this.current_line = 37;
        if (this.isPause || this.isStepping) {
            this.go();
        }
    }

    private synchronized void printMessage() {
    }

    public synchronized void gotoLine(int line) {
        this.current_line = line;
    }

    public synchronized void go() {
        this.isPause = false;
        this.isStepping = false;
        this.notifyAll();
        this.nextLine();
    }

    public synchronized void stepFinish() {
        if (this.isStepping) {
            if (this.start_step_line > 0) {
                this.gotoLine(this.start_step_line);
                this.start_step_line = 0;
            }
            this.isPause = true;
            this.isStepping = false;
            this.notifyAll();
        }
    }

    public synchronized void stepOverLine() {
        if (this.isStepping && this.start_step_line > 0 && this.current_line == 15) {
            this.stepFinish();
        } else {
            this.isPause = false;
            this.isStepping = true;
            this.nextLine();
            this.notifyAll();
        }
    }

    public synchronized void stepLine() {
        if (!this.isStepping) {
            this.start_step_line = this.current_line;
        }
        this.isPause = false;
        this.isStepping = true;
        this.nextLine();
        this.notifyAll();
    }

    public void suspend() {
        this.isPause = true;
    }

    public synchronized void nextLine() {
        ++this.current_line;
    }

    public boolean isHitBreakpoint(int line) {
        return this.lines.contains(new Integer(line));
    }

    public int getHitBreakpointID(int line) {
        int index = this.lines.indexOf(new Integer(line));
        return (Integer)this.bpts.get(index);
    }

    public void deleteBpt(int bpt_id) {
        int index = this.bpts.indexOf(new Integer(bpt_id));
        this.bpts.remove(index);
        this.lines.remove(index);
    }

    public void setBpt(int line, int bpt_id) {
        Integer lineInt = new Integer(line);
        Integer bptInt = new Integer(bpt_id);
        if (!this.bpts.contains(bptInt) && !this.lines.contains(lineInt)) {
            this.lines.add(lineInt);
            this.bpts.add(bptInt);
        }
    }

    public void setStopInMain(int line, int bpt_id) {
        this.setBpt(line, bpt_id);
        this.isStopInMain = true;
    }
}

