/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;

public class ControlSystemChoices {
    public static final int SIMULATED = 100;
    public static final int ORTE = 101;
    public static final int LAMPI = 102;
    public static final int LAMMPI = 103;
    public static final int MPICH1 = 104;
    public static final int MPICH2 = 105;
    private static String[] NonDevelCSChoices = new String[]{"Open Runtime Environment (ORTE)", "Los Alamos MPI (LAMPI)", "LAM-MPI", "MPICH 1.x", "MPICH 2.x (MPD)"};
    private static int[] NonDevelCSIDs = new int[]{101, 102, 103, 104, 105};
    private static String[] DevelCSChoices = new String[]{"Simulated", "Open Runtime Environment (ORTE)", "Los Alamos MPI (LAMPI)", "LAM-MPI", "MPICH 1.x", "MPICH 2.x (MPD)"};
    private static int[] DevelCSIDs = new int[]{100, 101, 102, 103, 104, 105};

    public static boolean queryDevelMode() {
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean("DEVELOPER_MODE");
    }

    public static String[] queryCSChoices() {
        if (ControlSystemChoices.queryDevelMode()) {
            return DevelCSChoices;
        }
        return NonDevelCSChoices;
    }

    public static int[] queryCSIDs() {
        if (ControlSystemChoices.queryDevelMode()) {
            return DevelCSIDs;
        }
        return NonDevelCSIDs;
    }

    public static String[] getCSStrings() {
        return ControlSystemChoices.queryCSChoices();
    }

    public static int getCSArrayIndexByName(String CSname) {
        int i = 0;
        while (i < ControlSystemChoices.queryCSChoices().length) {
            if (CSname.equals(ControlSystemChoices.queryCSChoices()[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getCSArrayIndexByID(int ID) {
        int i = 0;
        while (i < ControlSystemChoices.queryCSIDs().length) {
            if (ID == ControlSystemChoices.queryCSIDs()[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getCSIDByName(String CSname) {
        int idx = ControlSystemChoices.getCSArrayIndexByName(CSname);
        if (idx < 0) {
            return idx;
        }
        return ControlSystemChoices.queryCSIDs()[idx];
    }

    public static int getCSIDByIndex(int idx) {
        if (idx < 0 || idx >= ControlSystemChoices.queryCSIDs().length) {
            return -1;
        }
        return ControlSystemChoices.queryCSIDs()[idx];
    }

    public static String getCSNameByID(int ID) {
        int i = 0;
        while (i < ControlSystemChoices.queryCSIDs().length) {
            if (ID == ControlSystemChoices.queryCSIDs()[i]) {
                return ControlSystemChoices.queryCSChoices()[i];
            }
            ++i;
        }
        return "<UNDEFINED CS>";
    }

    public static String getCSNameByIndex(int idx) {
        if (idx < 0 || idx >= ControlSystemChoices.queryCSChoices().length) {
            return "<UNDEFINED CS>";
        }
        return ControlSystemChoices.queryCSChoices()[idx];
    }
}

