/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core;

import java.io.File;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.core.IDGenerator;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.internal.core.ModelManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PTPCorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.core";
    private IModelManager modelManager = null;
    private static PTPCorePlugin plugin;
    private ResourceBundle resourceBundle;
    private IDGenerator IDGen;

    public PTPCorePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.core.ParallelPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.IDGen = new IDGenerator();
    }

    public int getNewID() {
        return this.IDGen.getNewID();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.modelManager = new ModelManager();
    }

    public void stop(BundleContext context) throws Exception {
        this.modelManager.shutdown();
        super.stop(context);
    }

    public IModelManager getModelManager() {
        return this.modelManager;
    }

    public static PTPCorePlugin getDefault() {
        return plugin;
    }

    public void refreshParallelPluginActions() {
        this.refreshPluginActions();
    }

    public static String getUniqueIdentifier() {
        if (PTPCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PTPCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = PTPCorePlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PTPCorePlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void log(String msg) {
        PTPCorePlugin.log((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(IStatus status) {
        PTPCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PTPCorePlugin.log((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Internal Error", e));
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void errorDialog(final String title, final String message, final Throwable t) {
        PTPCorePlugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                PTPCorePlugin.errorDialog(PTPCorePlugin.getDisplay().getActiveShell(), title, message, t);
            }
        });
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
        } else {
            status = new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "Error within PTP Core: ", t);
            PTPCorePlugin.log(status);
        }
        PTPCorePlugin.errorDialog(shell, title, message, status);
    }

    public static void errorDialog(Shell shell, String title, IStatus s) {
        PTPCorePlugin.errorDialog(shell, title, s.getMessage(), s);
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        if (s != null && message != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void warningDialog(final String title, final String message) {
        PTPCorePlugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openWarning((Shell)PTPCorePlugin.getDisplay().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    public static void informationDialog(final String title, final String message) {
        PTPCorePlugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)PTPCorePlugin.getDisplay().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    public String locateFragmentFile(String fragment, String file) {
        Bundle[] frags = Platform.getFragments((Bundle)Platform.getBundle((String)PLUGIN_ID));
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        String os_arch = String.valueOf(os) + "." + arch;
        System.out.println("OS = '" + os + "', Architecture = '" + arch + "', OS_ARCH combo = '" + os_arch + "'");
        String ptp_version = (String)PTPCorePlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
        System.out.println("PTP Version = " + ptp_version);
        System.out.println("All Found Fragments:");
        int i = 0;
        while (i < frags.length) {
            System.out.println("\t" + frags[i].toString());
            ++i;
        }
        i = 0;
        while (i < frags.length) {
            Bundle frag = frags[i];
            URL path = frag.getEntry("/");
            try {
                URL local_path = Platform.asLocalURL((URL)path);
                String str_path = local_path.getPath();
                System.out.println("Testing fragment " + (i + 1) + " with this OS/arch - path: '" + str_path + "'");
                int idx = str_path.indexOf(os_arch);
                if (idx > 0) {
                    System.out.println("\tCorrect fragment for our OS & arch");
                    String file_path = String.valueOf(str_path) + "bin/" + file;
                    System.out.println("\tSearching for file in '" + file_path + "'");
                    File f = new File(file_path);
                    if (f.exists()) {
                        System.out.println("\t\t**** FOUND IT!");
                        return file_path;
                    }
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return null;
    }
}

