/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ptp.core.PTPCorePlugin;

public abstract class AbstractAttachDebugger {
    protected String pidText = null;
    protected String debugConfigName = "";
    protected ILaunch debugLaunch = null;

    public AbstractAttachDebugger(String pidText, String debugConfigName) {
        this.pidText = pidText;
        this.debugConfigName = debugConfigName;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected abstract ILaunchConfiguration createDebugConfiguration(IFile var1) throws CoreException;

    protected abstract boolean createLaunch(ILaunchConfiguration var1) throws CoreException;

    public abstract void attachDebugger(ILaunchConfiguration var1) throws CoreException;

    protected IFile findExeFile(ILaunchConfiguration ptpConfig) throws CoreException {
        IProject project;
        IFile programPath;
        String projectName = ptpConfig.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
        String programName = ptpConfig.getAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", null);
        if (projectName != null && !projectName.equals("") && (programPath = (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).getFile(programName)) != null && programPath.exists() && programPath.getLocation().toFile().exists()) {
            return programPath;
        }
        Status status = new Status(4, PTPCorePlugin.getUniqueIdentifier(), 1, "No such program(" + programName + ") found.", null);
        throw new CoreException((IStatus)status);
    }

    protected String renderTargetLabel(String name) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, name, timestamp);
    }

    protected int getPid() throws CoreException {
        int pid = -1;
        if (this.pidText != null && !this.pidText.equals("")) {
            try {
                pid = Integer.parseInt(this.pidText);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return pid;
    }
}

