/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.ControlSystemChoices;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.core.IParallelModelListener;
import org.eclipse.ptp.core.MonitoringSystemChoices;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.internal.core.CoreMessages;
import org.eclipse.ptp.internal.core.PJob;
import org.eclipse.ptp.internal.core.PMachine;
import org.eclipse.ptp.internal.core.PNode;
import org.eclipse.ptp.internal.core.PProcess;
import org.eclipse.ptp.rtsystem.IControlSystem;
import org.eclipse.ptp.rtsystem.IMonitoringSystem;
import org.eclipse.ptp.rtsystem.IRuntimeListener;
import org.eclipse.ptp.rtsystem.IRuntimeProxy;
import org.eclipse.ptp.rtsystem.JobRunConfiguration;
import org.eclipse.ptp.rtsystem.ompi.OMPIMonitoringSystem;
import org.eclipse.ptp.rtsystem.simulation.SimulationMonitoringSystem;

public class ModelManager
implements IModelManager,
IRuntimeListener {
    protected List listeners = new ArrayList(2);
    protected int currentState = 3;
    protected IPJob processRoot = null;
    protected IPUniverse universe = null;
    protected ILaunchConfiguration config = null;
    protected IControlSystem controlSystem = null;
    protected IMonitoringSystem monitoringSystem = null;
    protected IRuntimeProxy runtimeProxy = null;
    private int currentControlSystem = -1;
    private int currentMonitoringSystem = -1;

    public void setPTPConfiguration(ILaunchConfiguration config) {
        this.config = config;
    }

    public ILaunchConfiguration getPTPConfiguration() {
        return this.config;
    }

    public ModelManager() {
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        int MSChoiceID = preferences.getInt("MONITORING_SYSTEM_SELECTION");
        String MSChoice = MonitoringSystemChoices.getMSNameByID(MSChoiceID);
        int CSChoiceID = preferences.getInt("CONTROL_SYSTEM_SELECTION");
        String CSChoice = ControlSystemChoices.getCSNameByID(CSChoiceID);
        System.out.println("Your Control System Choice: '" + CSChoice + "'");
        System.out.println("Your Monitoring System Choice: '" + MSChoice + "'");
        if (ControlSystemChoices.getCSArrayIndexByID(CSChoiceID) == -1 || MonitoringSystemChoices.getMSArrayIndexByID(MSChoiceID) == -1) {
            int MSI = 101;
            int CSI = 101;
            Preferences p = PTPCorePlugin.getDefault().getPluginPreferences();
            p.setValue("MONITORING_SYSTEM_SELECTION", MSI);
            p.setValue("CONTROL_SYSTEM_SELECTION", CSI);
            PTPCorePlugin.getDefault().savePluginPreferences();
            System.err.println("No previous (or invalid) control or monitoring system selected.\n\nDefault systems set to Open Runtime Environment (ORTE).  To change, use the Window->Preferences->PTP preferences page.");
            MSChoiceID = preferences.getInt("MONITORING_SYSTEM_SELECTION");
            MSChoice = MonitoringSystemChoices.getMSNameByID(MSChoiceID);
            CSChoiceID = preferences.getInt("CONTROL_SYSTEM_SELECTION");
            CSChoice = ControlSystemChoices.getCSNameByID(CSChoiceID);
            System.out.println("Your Control System Choice: '" + CSChoice + "'");
            System.out.println("Your Monitoring System Choice: '" + MSChoice + "'");
        }
    }

    public IControlSystem getControlSystem() {
        return this.controlSystem;
    }

    public int getControlSystemID() {
        return this.currentControlSystem;
    }

    public IMonitoringSystem getMonitoringSystem() {
        return this.monitoringSystem;
    }

    public int getMonitoringSystemID() {
        return this.currentMonitoringSystem;
    }

    public void refreshRuntimeSystems(IProgressMonitor monitor, boolean force) throws CoreException {
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        int MSChoiceID = preferences.getInt("MONITORING_SYSTEM_SELECTION");
        int CSChoiceID = preferences.getInt("CONTROL_SYSTEM_SELECTION");
        int curMSID = this.getControlSystemID();
        int curCSID = this.getMonitoringSystemID();
        if (force || curMSID != MSChoiceID || curCSID != CSChoiceID) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this.refreshRuntimeSystems(CSChoiceID, MSChoiceID, monitor);
        }
    }

    /*
     * Exception decompiling
     */
    public void refreshRuntimeSystems(int controlSystemID, int monitoringSystemID, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 597->601)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setupMS(IProgressMonitor monitor) throws CoreException {
        String[] ne = this.monitoringSystem.getMachines();
        monitor.beginTask("", ne.length * 2);
        int i = 0;
        while (i < ne.length) {
            monitor.setTaskName("Creating machines...");
            if (monitor.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            String ids = ne[i].substring(new String("machine").length());
            int machID = new Integer(ids);
            PMachine mac = new PMachine(this.universe, ne[i], machID);
            this.universe.addChild(mac);
            monitor.internalWorked(1.0);
            String[] ne2 = this.monitoringSystem.getNodes(mac);
            System.out.println("MACHINE: " + ne[i] + " - #nodes = " + ne2.length);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            subMonitor.beginTask("", ne2.length);
            subMonitor.setTaskName("Creating nodes...");
            if (this.monitoringSystem instanceof OMPIMonitoringSystem) {
                int num_attribs = 5;
                String[] keys = new String[]{"ATTRIB_NODE_NAME", "ATTRIB_NODE_USER", "ATTRIB_NODE_GROUP", "ATTRIB_NODE_STATE", "ATTRIB_NODE_MODE"};
                String[] attribs = this.monitoringSystem.getAllNodesAttributes(mac, keys);
                if (attribs == null || attribs.length == 0) {
                    return;
                }
                int j = 0;
                while (j < attribs.length) {
                    System.out.println("*** attribs[" + j + "] = " + attribs[j]);
                    ++j;
                }
                j = 0;
                while (j < ne2.length) {
                    if (subMonitor.isCanceled()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    String nodename = "" + j;
                    if (attribs.length > j * num_attribs) {
                        nodename = attribs[j * num_attribs];
                    }
                    PNode node = new PNode(mac, ne2[j], "" + j, j);
                    node.setAttrib("ATTRIB_NODE_NAME", nodename);
                    System.out.println("NodeName According to ORTE = '" + node.getAttrib("ATTRIB_NODE_NAME") + "'");
                    System.out.println("\t#attribs returned: " + attribs.length);
                    if (attribs.length > j * num_attribs + 1) {
                        node.setAttrib("ATTRIB_NODE_USER", attribs[j * num_attribs + 1]);
                    } else {
                        node.setAttrib("ATTRIB_NODE_USER", "UNKNOWN");
                    }
                    if (attribs.length > j * num_attribs + 2) {
                        node.setAttrib("ATTRIB_NODE_GROUP", attribs[j * num_attribs + 2]);
                    } else {
                        node.setAttrib("ATTRIB_NODE_GROUP", "UNKNOWN");
                    }
                    if (attribs.length > j * num_attribs + 3) {
                        node.setAttrib("ATTRIB_NODE_STATE", attribs[j * num_attribs + 3]);
                    } else {
                        node.setAttrib("ATTRIB_NODE_STATE", "up");
                    }
                    if (attribs.length > j * num_attribs + 4) {
                        node.setAttrib("ATTRIB_NODE_MODE", attribs[j * num_attribs + 4]);
                    } else {
                        node.setAttrib("ATTRIB_NODE_MODE", "73");
                    }
                    mac.addChild(node);
                    subMonitor.worked(1);
                    ++j;
                }
            } else if (this.monitoringSystem instanceof SimulationMonitoringSystem) {
                int j = 0;
                while (j < ne2.length) {
                    if (subMonitor.isCanceled()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    PNode node = new PNode(mac, ne2[j], "" + j, j);
                    node.setAttrib("ATTRIB_NODE_NAME", this.monitoringSystem.getNodeAttributes(node, new String[]{"ATTRIB_NODE_NAME"})[0]);
                    node.setAttrib("ATTRIB_NODE_USER", this.monitoringSystem.getNodeAttributes(node, new String[]{"ATTRIB_NODE_USER"})[0]);
                    node.setAttrib("ATTRIB_NODE_GROUP", this.monitoringSystem.getNodeAttributes(node, new String[]{"ATTRIB_NODE_GROUP"})[0]);
                    node.setAttrib("ATTRIB_NODE_STATE", this.monitoringSystem.getNodeAttributes(node, new String[]{"ATTRIB_NODE_STATE"})[0]);
                    node.setAttrib("ATTRIB_NODE_MODE", this.monitoringSystem.getNodeAttributes(node, new String[]{"ATTRIB_NODE_MODE"})[0]);
                    mac.addChild(node);
                    ++j;
                }
            }
            ++i;
        }
        ne = this.controlSystem.getJobs();
        if (ne != null) {
            i = 0;
            while (i < ne.length) {
                monitor.setTaskName("Creating jobs...");
                if (monitor.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                System.out.println("JOB: " + ne[i]);
                int x = 0;
                try {
                    x = new Integer(ne[i].substring(3));
                }
                catch (NumberFormatException numberFormatException) {}
                PJob job = new PJob(this.universe, ne[i], "" + (10000 + x), x);
                this.universe.addChild(job);
                String[] ne2 = this.controlSystem.getProcesses(job);
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                subMonitor.beginTask("", ne2.length);
                subMonitor.setTaskName("Creating processes...");
                int j = 0;
                while (j < ne2.length) {
                    if (subMonitor.isCanceled()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    PProcess proc = new PProcess(job, String.valueOf(ne[i]) + "_process" + j, "" + j, "0", j, "starting", "", "");
                    job.addChild(proc);
                    subMonitor.worked(1);
                    ++j;
                }
                try {
                    this.getProcsStatusForNewJob(ne[i], job, (IProgressMonitor)new SubProgressMonitor(monitor, ne2.length));
                }
                catch (CoreException coreException) {
                    this.universe.deleteJob(job);
                    return;
                }
                ++i;
            }
        }
        monitor.worked(1);
        this.monitoringSystem.addRuntimeListener(this);
        this.controlSystem.addRuntimeListener(this);
        monitor.done();
    }

    private void getProcsStatusForNewJob(String nejob, IPJob job, IProgressMonitor monitor) throws CoreException {
        int numProcs = job.totalProcesses();
        if (numProcs <= 0) {
            return;
        }
        System.out.println("getProcsStatusForNewJob:" + nejob + " - #procs = " + numProcs);
        int num_attribs = 2;
        String[] keys = new String[]{"ATTRIB_PROCESS_PID", "ATTRIB_PROCESS_NODE_NAME"};
        String[] attribs = this.controlSystem.getAllProcessesAttributes(job, keys);
        int i = 0;
        while (i < attribs.length) {
            System.out.println("*** attribs[" + i + "] = " + attribs[i]);
            ++i;
        }
        monitor.beginTask("", numProcs);
        monitor.setTaskName("Initialing the processes...");
        i = 0;
        while (i < numProcs) {
            if (monitor.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            IPProcess proc = job.findProcessByName(String.valueOf(nejob) + "_process" + i);
            if (proc == null) {
                System.err.println("*** ERROR: Unable to find process #" + i + " on job " + nejob);
            } else {
                IPNode node;
                proc.setPid(attribs[i * num_attribs]);
                String nname = attribs[i * num_attribs + 1];
                if (nname.equals("localhost")) {
                    nname = "0";
                }
                if ((node = this.universe.findNodeByName(nname = new String("machine0_node" + nname))) == null && (node = this.universe.findNodeByHostname(attribs[i * num_attribs + 1])) == null) {
                    throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "No available node found.", null));
                }
                proc.setNode(node);
                monitor.worked(1);
            }
            ++i;
        }
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        monitor.done();
    }

    private void refreshJobStatus(String nejob) {
        System.err.println("TODO: refreshJobStatus(" + nejob + ") called - finish this.");
    }

    public void runtimeNodeGeneralChange(String ne, String key, String value) {
        System.out.println("ModelManager.runtimeNodeGeneralName - node '" + ne + ", key='" + key + "', value='" + value + "'");
        IPNode n = this.universe.findNodeByName(ne);
        if (n != null) {
            System.out.print("\t before, val = " + n.getAttrib(key));
            n.setAttrib(key, value);
            System.out.println("\t after, val = " + n.getAttrib(key));
            this.fireEvent(n, 3);
        }
    }

    public void runtimeNodeStatusChange(String ne) {
        IPNode n = this.universe.findNodeByName(ne);
        if (n != null) {
            n.setAttrib("ATTRIB_NODE_STATE", this.monitoringSystem.getNodeAttributes(n, new String[]{"ATTRIB_NODE_STATE"}));
            this.fireEvent(n, 3);
        }
    }

    public void runtimeProcessOutput(String ne, String output) {
        IPProcess p = this.universe.findProcessByName(ne);
        if (p != null) {
            p.addOutput(output);
        }
    }

    public void runtimeJobExited(String ne) {
        this.refreshJobStatus(ne);
        IPJob job = this.universe.findJobByName(ne);
        this.fireEvent(job, 6);
        this.fireState(4, null);
        this.clearUsedMemory();
    }

    public void runtimeJobStateChanged(String nejob, String state) {
        System.out.println("*********** JOB STATE CHANGE: " + state + " (job = " + nejob + ")");
        IPJob job = this.universe.findJobByName(nejob);
        if (job != null) {
            IPProcess[] procs = job.getProcesses();
            if (procs != null) {
                int i = 0;
                while (i < procs.length) {
                    procs[i].setStatus(state);
                    ++i;
                }
            }
            this.fireEvent(job, 5);
        }
    }

    public void runtimeNewJob(String ne) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IPJob job = this.universe.findJobByName(ne);
        if (job != null) {
            IPProcess[] procs = job.getProcesses();
            int i = 0;
            while (i < procs.length) {
                IPNode node = procs[i].getNode();
                node.removeChild(procs[i]);
                ++i;
            }
            job.removeChildren();
            this.universe.removeChild(job);
        }
        int x = 0;
        try {
            x = new Integer(ne.substring(3));
        }
        catch (NumberFormatException numberFormatException) {}
        PJob pjob = new PJob(this.universe, ne, "" + (10000 + x), x);
        this.universe.addChild(pjob);
        String[] ne2 = this.controlSystem.getProcesses(pjob);
        int j = 0;
        while (j < ne2.length) {
            PProcess proc = new PProcess(pjob, String.valueOf(ne) + "_process" + j, "" + j, "0", j, "starting", "", "");
            pjob.addChild(proc);
            ++j;
        }
        try {
            this.getProcsStatusForNewJob(ne, pjob, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, ne2.length));
        }
        catch (CoreException coreException) {
            this.universe.deleteJob(job);
            return;
        }
        this.fireEvent(job, 5);
    }

    public void shutdown() {
        this.listeners.clear();
        this.listeners = null;
        if (this.monitoringSystem != null) {
            this.monitoringSystem.shutdown();
        }
        if (this.controlSystem != null) {
            this.controlSystem.shutdown();
        }
        if (this.runtimeProxy != null) {
            this.runtimeProxy.shutdown();
        }
    }

    public void addParallelLaunchListener(IParallelModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeParallelLaunchListener(IParallelModelListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fireState(int state, String arg) {
        this.setCurrentState(state);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IParallelModelListener listener = (IParallelModelListener)i.next();
            switch (state) {
                case 0: {
                    listener.start();
                    System.out.println("++++++++++++ Started ++++++++++++++");
                    break;
                }
                case 1: {
                    listener.run(arg);
                    break;
                }
                case 3: {
                    System.out.println("++++++++++++ Exit ++++++++++++++");
                    listener.exit();
                    break;
                }
                case 2: {
                    listener.abort();
                    break;
                }
                case 4: {
                    System.out.println("++++++++++++ Stopped ++++++++++++++");
                    listener.stopped();
                }
            }
        }
    }

    protected synchronized void fireEvent(Object object, int event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IParallelModelListener listener = (IParallelModelListener)i.next();
            switch (event) {
                case 7: {
                    listener.monitoringSystemChangeEvent(object);
                    break;
                }
                case 2: {
                    listener.execStatusChangeEvent(object);
                    break;
                }
                case 3: {
                    listener.sysStatusChangeEvent(object);
                    break;
                }
                case 1: {
                    listener.processOutputEvent(object);
                    break;
                }
                case 4: {
                    listener.errorEvent(object);
                    break;
                }
                case 5: {
                    listener.updatedStatusEvent();
                    break;
                }
                case 6: {
                    listener.execStatusChangeEvent(object);
                }
            }
        }
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(int currentState) {
        this.currentState = currentState;
    }

    protected String renderLabel(String name) {
        String format = CoreMessages.getResourceString("ModelManager.{0}_({1})");
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, name, timestamp);
    }

    public synchronized void abortJob(String jobName) throws CoreException {
        IPJob j = this.getUniverse().findJobByName(jobName);
        if (j == null) {
            System.err.println("ERROR: tried to delete a job that was not found '" + jobName + "'");
            return;
        }
        this.controlSystem.terminateJob(j);
        System.out.println("***** NEED TO REFRESH JOB STATUS HERE in abortJob() of ModelManager ONCE WE KNOW THE JOBID!");
        this.refreshJobStatus(jobName);
        this.fireState(2, null);
    }

    public IPJob run(ILaunch launch, JobRunConfiguration jobRunConfig, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName("Creating the job...");
        int jobID = this.controlSystem.run(jobRunConfig);
        if (jobID < 0) {
            throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, "cannot create a job.", null));
        }
        System.out.println("ModelManager.run() - new JobID = " + jobID);
        return this.newJob(jobID, jobRunConfig.getNumberOfProcesses(), jobRunConfig.isDebug(), monitor);
    }

    protected void clearUsedMemory() {
        long wasFree;
        System.out.println("********** clearUsedMemory");
        Runtime rt = Runtime.getRuntime();
        long isFree = rt.freeMemory();
        do {
            wasFree = isFree;
            rt.gc();
        } while ((isFree = rt.freeMemory()) > wasFree);
        rt.runFinalization();
    }

    public IPUniverse getUniverse() {
        return this.universe;
    }

    private IPJob newJob(int jobID, int numProcesses, boolean debug, IProgressMonitor monitor) throws CoreException {
        String jobName = "job" + jobID;
        System.out.println("MODEL MANAGER: newJob(" + jobID + ")");
        PJob job = new PJob(this.universe, jobName, "" + (10000 + jobID), jobID);
        if (debug) {
            job.setDebug();
        }
        this.universe.addChild(job);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", numProcesses);
        monitor.setTaskName("Creating processes....");
        int i = 0;
        while (i < numProcesses) {
            PProcess proc = new PProcess(job, String.valueOf(jobName) + "_process" + i, "" + i, "0", i, "starting", "", "");
            job.addChild(proc);
            ++i;
        }
        try {
            monitor.internalWorked(0.0);
            monitor.subTask("Setting process status...");
            this.getProcsStatusForNewJob(jobName, job, (IProgressMonitor)new SubProgressMonitor(monitor, numProcesses));
        }
        catch (CoreException e) {
            this.controlSystem.terminateJob(job);
            this.universe.deleteJob(job);
            throw e;
        }
        this.fireState(1, jobName);
        return job;
    }
}

