/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.HashMap;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ptp.core.IPElement;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.internal.core.PElementInfo;

public abstract class PElement
extends PlatformObject
implements IPElement,
Comparable {
    protected HashMap attribs = new HashMap();
    protected int ID = PTPCorePlugin.getDefault().getNewID();
    private PElementInfo elementInfo = null;

    protected PElement(IPElement parent, String name, String key, int type) {
        this.attribs.put("ATTRIB_PARENT", parent);
        this.attribs.put("ATTRIB_NAME", name);
        this.attribs.put("ATTRIB_TYPE", new Integer(type));
    }

    protected PElementInfo getElementInfo() {
        if (this.elementInfo == null) {
            this.elementInfo = new PElementInfo(this);
        }
        return this.elementInfo;
    }

    public Object getAttribute(String key) {
        return this.attribs.get(key);
    }

    public void setAttribute(String key, Object o) {
        this.attribs.put(key, o);
    }

    public String getElementName() {
        return (String)this.attribs.get("ATTRIB_NAME");
    }

    public int getID() {
        return this.ID;
    }

    public String getIDString() {
        return "" + this.ID;
    }

    public void setElementName(String name) {
        this.attribs.put("ATTRIB_NAME", name);
    }

    public IPElement getParent() {
        return (IPElement)this.attribs.get("ATTRIB_PARENT");
    }

    public void setParent(IPElement parent) {
        this.attribs.put("ATTRIB_PARENT", parent);
    }

    public int getElementType() {
        Integer i = (Integer)this.attribs.get("ATTRIB_TYPE");
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setElementType(int type) {
        this.attribs.put("ATTRIB_TYPE", new Integer(type));
    }

    public String toString() {
        return this.getElementName();
    }

    public int size() {
        return this.getElementInfo().size();
    }

    public int compareTo(Object obj) {
        if (obj instanceof IPElement) {
            int his_rank;
            int my_rank = this.getID();
            if (my_rank < (his_rank = ((IPElement)obj).getID())) {
                return -1;
            }
            if (my_rank == his_rank) {
                return 0;
            }
            if (my_rank > his_rank) {
                return 1;
            }
        }
        return 0;
    }

    public int computeScore(String pageId, Object element) {
        if (element instanceof IPElement) {
            return 90;
        }
        return 0;
    }
}

