/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.core.IPElement;

public class PElementInfo {
    private Map fChildren = null;
    protected IPElement element;

    public PElementInfo(IPElement element) {
        this.element = element;
        this.fChildren = new HashMap(0);
    }

    public IPElement getElement() {
        return this.element;
    }

    public void addChild(IPElement member) {
        this.fChildren.put(member.getIDString(), member);
    }

    public void removeChild(IPElement member) {
        this.fChildren.remove(member.getIDString());
    }

    public IPElement findChild(String key) {
        if (this.fChildren.containsKey(key)) {
            return (IPElement)this.fChildren.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPElement[] getChildren() {
        Map map = this.fChildren;
        synchronized (map) {
            return this.fChildren.values().toArray(new IPElement[this.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getCollection() {
        Map map = this.fChildren;
        synchronized (map) {
            return this.fChildren.values();
        }
    }

    public boolean includesChild(IPElement child) {
        return this.fChildren.containsKey(child.getIDString());
    }

    public void removeChildren() {
        this.fChildren.clear();
    }

    public void setChildren(Map children) {
        this.fChildren.putAll(children);
    }

    public boolean hasChildren() {
        return this.size() > 0;
    }

    public int size() {
        return this.fChildren.size();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }
}

