/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.ptp.core.IPElement;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.internal.core.Parent;

public class PJob
extends Parent
implements IPJob {
    protected String NAME_TAG = "root ";
    protected boolean isDebugJob = false;
    private ArrayList taskIdMap = new ArrayList();
    public static final int BASE_OFFSET = 10000;
    public static final int STATE_NEW = 5000;

    public PJob(IPUniverse uni, String name, String key, int jobNumber) {
        super(uni, name, key, 13);
        this.attribs.put("ATTRIB_JOBID", new Integer(jobNumber));
    }

    public boolean isDebug() {
        return this.isDebugJob;
    }

    public void setDebug() {
        this.isDebugJob = true;
    }

    public IPMachine[] getMachines() {
        IPNode[] nodes = this.getNodes();
        ArrayList<IPMachine> array = new ArrayList<IPMachine>(0);
        int i = 0;
        while (i < nodes.length) {
            if (!array.contains(nodes[i].getMachine())) {
                array.add(nodes[i].getMachine());
            }
            ++i;
        }
        return array.toArray(new IPMachine[array.size()]);
    }

    public String getJobNumber() {
        return "" + (Integer)this.attribs.get("ATTRIB_JOBID");
    }

    public int getJobNumberInt() {
        return (Integer)this.attribs.get("ATTRIB_JOBID");
    }

    public synchronized IPNode[] getSortedNodes() {
        IPElement[] nodes = this.getNodes();
        this.sort(nodes);
        return nodes;
    }

    public synchronized IPNode[] getNodes() {
        IPProcess[] processes = this.getProcesses();
        ArrayList<IPNode> array = new ArrayList<IPNode>(0);
        int i = 0;
        while (i < processes.length) {
            if (!array.contains(processes[i].getNode())) {
                array.add(processes[i].getNode());
            }
            ++i;
        }
        return array.toArray(new IPNode[array.size()]);
    }

    public synchronized IPProcess[] getProcesses() {
        return this.getCollection().toArray(new IPProcess[this.size()]);
    }

    public synchronized IPProcess[] getSortedProcesses() {
        IPElement[] processes = this.getProcesses();
        this.sort(processes);
        return processes;
    }

    public synchronized IPProcess findProcess(String processNumber) {
        IPElement element = this.findChild(processNumber);
        if (element != null) {
            return (IPProcess)element;
        }
        return null;
    }

    public synchronized IPProcess findProcessByName(String pname) {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            IPProcess proc;
            Object ob = it.next();
            if (!(ob instanceof IPProcess) || !(proc = (IPProcess)ob).getElementName().equals(pname)) continue;
            return proc;
        }
        return null;
    }

    public int totalNodes() {
        return this.getNodes().length;
    }

    public int totalProcesses() {
        return this.size();
    }

    public void removeAllProcesses() {
        IPProcess[] processes = this.getProcesses();
        int i = 0;
        while (i < processes.length) {
            processes[i].clearOutput();
            ++i;
        }
        this.removeChildren();
    }

    public IPUniverse getUniverse() {
        IPElement current = this;
        do {
            if (!(current instanceof IPUniverse)) continue;
            return (IPUniverse)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public void addChild(IPElement member) {
        super.addChild(member);
        if (member instanceof IPProcess) {
            IPProcess p = (IPProcess)member;
            this.taskIdMap.add(p.getTaskId(), "" + p.getID());
        }
    }

    public synchronized IPProcess findProcessByTaskId(int taskId) {
        String procNumber = (String)this.taskIdMap.get(taskId);
        if (procNumber == null) {
            return null;
        }
        return this.findProcess(procNumber);
    }
}

