/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.ptp.core.IPElement;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.internal.core.Parent;

public class PMachine
extends Parent
implements IPMachine {
    protected String NAME_TAG = "machine ";
    protected String arch = "undefined";

    public PMachine(IPUniverse uni, String name, int machineID) {
        super(uni, name, "" + machineID, 11);
        this.attribs.put("ATTRIB_MACHINEID", new Integer(machineID));
    }

    public String getMachineNumber() {
        return "" + (Integer)this.attribs.get("ATTRIB_MACHINEID");
    }

    public int getMachineNumberInt() {
        return (Integer)this.attribs.get("ATTRIB_MACHINEID");
    }

    public IPUniverse getUniverse() {
        IPElement current = this;
        do {
            if (!(current instanceof IPUniverse)) continue;
            return (IPUniverse)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public synchronized IPNode[] getNodes() {
        return this.getCollection().toArray(new IPNode[this.size()]);
    }

    public synchronized IPNode[] getSortedNodes() {
        IPElement[] nodes = this.getNodes();
        this.sort(nodes);
        return nodes;
    }

    public synchronized IPNode findNode(String nodeNumber) {
        IPElement element = this.findChild(nodeNumber);
        if (element != null) {
            return (IPNode)element;
        }
        return null;
    }

    public synchronized IPNode findNodeByName(String nname) {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            IPNode node;
            Object ob = it.next();
            if (!(ob instanceof IPNode) || !(node = (IPNode)ob).getElementName().equals(nname)) continue;
            return node;
        }
        return null;
    }

    public synchronized IPProcess[] getProcesses() {
        ArrayList array = new ArrayList(0);
        IPNode[] nodes = this.getNodes();
        int i = 0;
        while (i < nodes.length) {
            array.addAll(nodes[i].getCollection());
            ++i;
        }
        return array.toArray(new IPProcess[array.size()]);
    }

    public synchronized IPProcess[] getSortedProcesses() {
        IPElement[] processes = this.getProcesses();
        this.sort(processes);
        return processes;
    }

    public void removeAllProcesses() {
        IPProcess[] processes = this.getProcesses();
        int i = 0;
        while (i < processes.length) {
            processes[i].clearOutput();
            ++i;
        }
        this.removeChildren();
    }

    public int totalNodes() {
        return this.size();
    }

    public int totalProcesses() {
        int counter = 0;
        IPNode[] nodes = this.getNodes();
        int i = 0;
        while (i < nodes.length) {
            counter += nodes[i].size();
            ++i;
        }
        return counter;
    }

    public synchronized IPJob[] getJobs() {
        IPProcess[] processes = this.getProcesses();
        ArrayList<IPJob> array = new ArrayList<IPJob>(0);
        int i = 0;
        while (i < processes.length) {
            if (!array.contains(processes[i].getJob())) {
                array.add(processes[i].getJob());
            }
            ++i;
        }
        return array.toArray(new IPJob[array.size()]);
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }
}

