/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.core.INodeEvent;
import org.eclipse.ptp.core.INodeListener;
import org.eclipse.ptp.core.IPElement;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.internal.core.Parent;

public class PNode
extends Parent
implements IPNode {
    protected String NAME_TAG = "node ";
    protected Map attribs = null;
    protected List listeners = new ArrayList();

    public PNode(IPElement mac, String name, String key, int nodeNumber) {
        super(mac, name, key, 12);
        this.attribs = new HashMap(0);
        this.attribs.put("ATTRIB_NODE_NUMBER", new Integer(nodeNumber));
    }

    public IPMachine getMachine() {
        IPElement current = this;
        do {
            if (!(current instanceof IPMachine)) continue;
            return (IPMachine)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public String getNodeNumber() {
        return "" + (Integer)this.attribs.get("ATTRIB_NODE_NUMBER");
    }

    public int getNodeNumberInt() {
        return (Integer)this.attribs.get("ATTRIB_NODE_NUMBER");
    }

    public IPProcess[] getProcesses() {
        return this.getCollection().toArray(new IPProcess[this.size()]);
    }

    public IPProcess[] getSortedProcesses() {
        IPElement[] processes = this.getProcesses();
        this.sort(processes);
        return processes;
    }

    public IPProcess findProcess(String processNumber) {
        IPElement element = this.findChild(processNumber);
        if (element != null) {
            return (IPProcess)element;
        }
        return null;
    }

    public void setAttrib(String key, Object val) {
        if (this.attribs.containsKey(key)) {
            this.attribs.remove(key);
        }
        this.attribs.put(key, val);
    }

    public Object getAttrib(String key) {
        if (!this.attribs.containsKey(key)) {
            return null;
        }
        return this.attribs.get(key);
    }

    public IPJob[] getJobs() {
        IPProcess[] processes = this.getProcesses();
        ArrayList<IPJob> array = new ArrayList<IPJob>(0);
        int i = 0;
        while (i < processes.length) {
            if (!array.contains(processes[i].getJob())) {
                array.add(processes[i].getJob());
            }
            ++i;
        }
        return array.toArray(new IPJob[array.size()]);
    }

    public void fireEvent(INodeEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            INodeListener listener = (INodeListener)i.next();
            listener.nodeEvent(event);
        }
    }

    public void addNodeListener(INodeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removerNodeListener(INodeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

