/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.IPElement;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IProcessEvent;
import org.eclipse.ptp.core.IProcessListener;
import org.eclipse.ptp.core.NodeEvent;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.ProcessEvent;
import org.eclipse.ptp.internal.core.OutputTextFile;
import org.eclipse.ptp.internal.core.Parent;

public class PProcess
extends Parent
implements IPProcess {
    protected String NAME_TAG = "process ";
    private String pid = null;
    private String status = null;
    private String exitCode = null;
    private String signalName = null;
    private boolean isTerminated = false;
    private OutputTextFile outputFile = null;
    protected String outputDirPath = null;
    protected int storeLine = 0;
    private List listeners = new ArrayList();
    protected IPNode node;

    public PProcess(IPElement element, String name, String key, String pid, int taskId, String status, String exitCode, String signalName) {
        super(element, name, key, 14);
        this.pid = pid;
        this.attribs.put("ATTRIB_TASKID", new Integer(taskId));
        this.attribs.put("ATTRIB_ISREGISTERED", new Boolean(false));
        this.exitCode = exitCode;
        this.status = status;
        this.setOutputStore();
        this.outputFile = new OutputTextFile(name, this.outputDirPath, this.storeLine);
    }

    private void setOutputStore() {
        File outputDirectory;
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        this.outputDirPath = preferences.getString("OUTPUT_DIR");
        this.storeLine = preferences.getInt("STORE_LINE");
        if (this.outputDirPath == null || this.outputDirPath.length() == 0) {
            this.outputDirPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append("output").toOSString();
        }
        if (this.storeLine == 0) {
            this.storeLine = 100;
        }
        if (!(outputDirectory = new File(this.outputDirPath)).exists()) {
            outputDirectory.mkdir();
        }
    }

    public IPJob getJob() {
        IPElement current = this;
        do {
            if (!(current instanceof IPJob)) continue;
            return (IPJob)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public String getProcessNumber() {
        return "" + this.getTaskId();
    }

    public void setStatus(String status) {
        String string = this.status = status == null ? "unknown" : status;
        if (status != null) {
            this.fireEvent(new ProcessEvent(this.getJob().getIDString(), this.getIDString(), 0, status));
            if (this.node != null && status.equals("exited")) {
                this.node.fireEvent(new NodeEvent(this.node.getMachine().getIDString(), this.node.getIDString(), 0, null));
            }
        }
    }

    public void setExitCode(String exitCode) {
        this.exitCode = exitCode;
        if (exitCode != null) {
            this.fireEvent(new ProcessEvent(this.getJob().getIDString(), this.getIDString(), 1, exitCode));
            if (this.node != null) {
                this.node.fireEvent(new NodeEvent(this.node.getMachine().getIDString(), this.node.getIDString(), 0, null));
            }
        }
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
        if (signalName != null) {
            this.fireEvent(new ProcessEvent(this.getJob().getIDString(), this.getIDString(), 2, signalName));
        }
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getPid() {
        return this.pid;
    }

    public String getExitCode() {
        return this.exitCode;
    }

    public String getSignalName() {
        return this.signalName;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void removeProcess() {
        ((IPNode)this.getParent()).removeChild(this);
    }

    public void setTerminated(boolean isTerminated) {
        this.isTerminated = isTerminated;
    }

    public void addOutput(String output) {
        this.outputFile.write(String.valueOf(output) + "\n");
        this.fireEvent(new ProcessEvent(this.getJob().getIDString(), this.getIDString(), 3, String.valueOf(output) + "\n"));
    }

    public String getContents() {
        return this.outputFile.getContents();
    }

    public String[] getOutputs() {
        return null;
    }

    public void clearOutput() {
        this.outputFile.delete();
    }

    public boolean isAllStop() {
        return this.getStatus().startsWith("exited") || this.getStatus().startsWith("error");
    }

    public void setNode(IPNode node) {
        this.node = node;
        if (node != null) {
            node.addChild(this);
        }
    }

    public IPNode getNode() {
        return this.node;
    }

    public int getTaskId() {
        return (Integer)this.attribs.get("ATTRIB_TASKID");
    }

    public void fireEvent(IProcessEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IProcessListener listener = (IProcessListener)i.next();
            listener.processEvent(event);
        }
    }

    public void addProcessListener(IProcessListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removerProcessListener(IProcessListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

