/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.ptp.core.IPElement;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.internal.core.Parent;

public class PUniverse
extends Parent
implements IPUniverse {
    protected String NAME_TAG = "universe ";

    public PUniverse() {
        super(null, "TheUniverse", "1", 10);
    }

    public synchronized IPMachine[] getMachines() {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        Vector<IPMachine> m = new Vector<IPMachine>();
        while (it.hasNext()) {
            Object ob = it.next();
            if (!(ob instanceof IPMachine)) continue;
            m.add((IPMachine)ob);
        }
        Object[] o = m.toArray();
        IPMachine[] mac = new IPMachine[o.length];
        int i = 0;
        while (i < o.length) {
            mac[i] = (IPMachine)o[i];
            ++i;
        }
        return mac;
    }

    public synchronized IPMachine[] getSortedMachines() {
        IPElement[] macs = this.getMachines();
        this.sort(macs);
        return macs;
    }

    public synchronized IPMachine findMachineByName(String mname) {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            IPMachine mac;
            Object ob = it.next();
            if (!(ob instanceof IPMachine) || !(mac = (IPMachine)ob).getElementName().equals(mname)) continue;
            return mac;
        }
        return null;
    }

    public synchronized IPNode findNodeByName(String nname) {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            IPNode node;
            Object ob = it.next();
            if (!(ob instanceof IPMachine) || (node = ((IPMachine)ob).findNodeByName(nname)) == null) continue;
            return node;
        }
        return null;
    }

    public synchronized IPNode findNodeByHostname(String nname) {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Object ob = it.next();
            if (!(ob instanceof IPMachine)) continue;
            IPNode[] nodes = ((IPMachine)ob).getNodes();
            int i = 0;
            while (i < nodes.length) {
                String aname = (String)nodes[i].getAttrib("ATTRIB_NODE_NAME");
                if (aname.equals(nname)) {
                    return nodes[i];
                }
                int idx = aname.indexOf(46);
                if (idx > 0) {
                    aname = aname.substring(0, idx);
                }
                if (aname.equals(nname)) {
                    return nodes[i];
                }
                ++i;
            }
        }
        return null;
    }

    public synchronized IPJob[] getJobs() {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        Vector<IPJob> m = new Vector<IPJob>();
        while (it.hasNext()) {
            Object ob = it.next();
            if (!(ob instanceof IPJob)) continue;
            m.add((IPJob)ob);
        }
        Object[] o = m.toArray();
        IPJob[] job = new IPJob[o.length];
        int i = 0;
        while (i < o.length) {
            job[i] = (IPJob)o[i];
            ++i;
        }
        return job;
    }

    public synchronized IPJob[] getSortedJobs() {
        IPElement[] jobs = this.getJobs();
        this.sort(jobs);
        return jobs;
    }

    public synchronized IPJob findJobByName(String jname) {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            IPJob job;
            Object ob = it.next();
            if (!(ob instanceof IPJob) || !(job = (IPJob)ob).getElementName().equals(jname)) continue;
            return job;
        }
        return null;
    }

    public synchronized IPProcess findProcessByName(String pname) {
        Collection col = this.getCollection();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            IPProcess proc;
            Object ob = it.next();
            if (!(ob instanceof IPJob) || (proc = ((IPJob)ob).findProcessByName(pname)) == null) continue;
            return proc;
        }
        return null;
    }

    public void deleteJob(IPJob job) {
        Iterator i = job.getCollection().iterator();
        while (i.hasNext()) {
            IPNode node;
            IPProcess process = (IPProcess)i.next();
            if (process == null || (node = process.getNode()) == null) continue;
            node.removeChild(process);
        }
        job.removeAllProcesses();
        this.removeChild(job);
    }
}

