/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.ompi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.rtsystem.IControlSystem;
import org.eclipse.ptp.rtsystem.IRuntimeListener;
import org.eclipse.ptp.rtsystem.JobRunConfiguration;
import org.eclipse.ptp.rtsystem.RuntimeEvent;
import org.eclipse.ptp.rtsystem.ompi.OMPIProxyRuntimeClient;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEventListener;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeJobStateEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeProcessOutputEvent;

public class OMPIControlSystem
implements IControlSystem,
IProxyRuntimeEventListener {
    private Process orted_process = null;
    private Vector knownJobs = null;
    protected List listeners = new ArrayList(2);
    private OMPIProxyRuntimeClient proxy = null;
    private boolean failed_init = false;

    public OMPIControlSystem(OMPIProxyRuntimeClient proxy) {
        this.proxy = proxy;
    }

    public void startup() {
        this.knownJobs = new Vector();
        this.proxy.addRuntimeEventListener(this);
    }

    public int run(JobRunConfiguration jobRunConfig) {
        String[] env;
        String[] args;
        int jobID = -1;
        System.out.println("JAVA OMPI: run() with args:\n" + jobRunConfig.toString());
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("execName");
        argList.add(jobRunConfig.getExecName());
        String path = jobRunConfig.getPathToExec();
        if (path != null) {
            argList.add("pathToExec");
            argList.add(path);
        }
        argList.add("numOfProcs");
        argList.add(Integer.toString(jobRunConfig.getNumberOfProcesses()));
        argList.add("procsPerNode");
        argList.add(Integer.toString(jobRunConfig.getNumberOfProcessesPerNode()));
        argList.add("firstNodeNum");
        argList.add(Integer.toString(jobRunConfig.getFirstNodeNumber()));
        String dir = jobRunConfig.getWorkingDir();
        if (dir != null) {
            argList.add("workingDir");
            argList.add(dir);
        }
        if ((args = jobRunConfig.getArguments()) != null) {
            int i = 0;
            while (i < args.length) {
                argList.add("progArg");
                argList.add(args[i]);
                ++i;
            }
        }
        if ((env = jobRunConfig.getEnvironment()) != null) {
            int i = 0;
            while (i < env.length) {
                argList.add("progEnv");
                argList.add(env[i]);
                ++i;
            }
        }
        if (jobRunConfig.isDebug()) {
            argList.add("debuggerPath");
            argList.add(jobRunConfig.getDebuggerPath());
            String[] dbgArgs = jobRunConfig.getDebuggerArgs();
            if (dbgArgs != null) {
                int i = 0;
                while (i < dbgArgs.length) {
                    argList.add("debuggerArg");
                    argList.add(dbgArgs[i]);
                    ++i;
                }
            }
        }
        try {
            jobID = this.proxy.runJob(argList.toArray(new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jobID;
    }

    public void terminateJob(IPJob job) {
        if (job == null) {
            System.err.println("ERROR: Tried to abort a null job.");
            return;
        }
        int jobID = job.getJobNumberInt();
        if (jobID >= 0) {
            System.out.println("OMPIControlSystem: abortJob() with name " + job.toString() + " and ID " + jobID);
            try {
                this.proxy.terminateJob(jobID);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("ERROR: Tried to abort a null job.");
        }
    }

    public String[] getJobs() {
        if (this.knownJobs == null) {
            System.out.println("NULL JOBS!");
            return null;
        }
        Object[] a = this.knownJobs.toArray();
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return null;
        }
        return (String[])a;
    }

    public String[] getProcesses(IPJob job) {
        int jobID = job.getJobNumberInt();
        int numProcs = -1;
        try {
            numProcs = this.proxy.getJobProcesses(jobID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (numProcs <= 0) {
            return null;
        }
        String[] ne = new String[numProcs];
        int i = 0;
        while (i < numProcs) {
            ne[i] = new String("job" + jobID + "_process" + i);
            ++i;
        }
        return ne;
    }

    public String[] getAllProcessesAttributes(IPJob job, String[] attribs) {
        String[] values = null;
        try {
            int jobID = job.getJobNumberInt();
            values = this.proxy.getAllProcessesAttribuesBlocking(jobID, attribs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return values;
    }

    public String[] getProcessAttributes(IPProcess proc, String[] attrib) {
        String[] values = null;
        IPJob job = proc.getJob();
        try {
            int jobID = job.getJobNumberInt();
            int procID = proc.getTaskId();
            values = this.proxy.getProcessAttributesBlocking(jobID, procID, attrib);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return values;
    }

    public void addRuntimeListener(IRuntimeListener listener) {
        this.listeners.add(listener);
    }

    public void removeRuntimeListener(IRuntimeListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fireEvent(String ID, RuntimeEvent event) {
        if (this.listeners == null) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IRuntimeListener listener = (IRuntimeListener)i.next();
            switch (event.getEventNumber()) {
                case 1: {
                    listener.runtimeNodeStatusChange(ID);
                    break;
                }
                case 2: {
                    listener.runtimeProcessOutput(ID, event.getText());
                    break;
                }
                case 3: {
                    listener.runtimeJobExited(ID);
                    break;
                }
                case 4: {
                    listener.runtimeJobStateChanged(ID, event.getText());
                    break;
                }
                case 5: {
                    listener.runtimeNewJob(ID);
                }
            }
        }
    }

    public void shutdown() {
        System.out.println("OMPIControlSystem: shutdown() called");
        this.listeners.clear();
        this.listeners = null;
    }

    public synchronized void handleEvent(IProxyRuntimeEvent e) {
        if (e instanceof ProxyRuntimeJobStateEvent) {
            RuntimeEvent re = new RuntimeEvent(4);
            int state = ((ProxyRuntimeJobStateEvent)e).getJobState();
            String stateStr = "error";
            switch (state) {
                case 1: 
                case 3: {
                    stateStr = "starting";
                    break;
                }
                case 4: {
                    stateStr = "running";
                    break;
                }
                case 8: 
                case 9: {
                    stateStr = "exited";
                }
            }
            re.setText(stateStr);
            this.fireEvent("job" + ((ProxyRuntimeJobStateEvent)e).getJobID(), re);
        } else if (e instanceof ProxyRuntimeProcessOutputEvent) {
            RuntimeEvent re = new RuntimeEvent(2);
            int jobID = ((ProxyRuntimeProcessOutputEvent)e).getJobID();
            int procID = ((ProxyRuntimeProcessOutputEvent)e).getProcessID();
            String text = ((ProxyRuntimeProcessOutputEvent)e).getText();
            re.setText(text);
            this.fireEvent("job" + jobID + "_process" + procID, re);
        }
    }
}

