/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.ompi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ptp.core.IPMachine;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.rtsystem.IMonitoringSystem;
import org.eclipse.ptp.rtsystem.IRuntimeListener;
import org.eclipse.ptp.rtsystem.RuntimeEvent;
import org.eclipse.ptp.rtsystem.ompi.OMPIProxyRuntimeClient;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEventListener;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeNodeChangeEvent;

public class OMPIMonitoringSystem
implements IMonitoringSystem,
IProxyRuntimeEventListener {
    protected List listeners = new ArrayList(2);
    private OMPIProxyRuntimeClient proxy = null;

    public OMPIMonitoringSystem(OMPIProxyRuntimeClient proxy) {
        this.proxy = proxy;
        proxy.addRuntimeEventListener(this);
    }

    public void addRuntimeListener(IRuntimeListener listener) {
        this.listeners.add(listener);
    }

    public void removeRuntimeListener(IRuntimeListener listener) {
        this.listeners.remove(listener);
    }

    public void startup() {
        System.out.println("OMPIMonitoringSystem startup()");
    }

    public void shutdown() {
        System.out.println("OMPIMonitoringSystem shutdown()");
        this.listeners.clear();
        this.listeners = null;
    }

    public String[] getMachines() {
        System.out.println("JAVA OMPI: getMachines() called");
        String[] ne = new String[]{new String("machine0")};
        return ne;
    }

    public String[] getNodes(IPMachine machine) {
        System.out.println("OMPIMonitoringSystem: getNodes(" + machine.getElementName() + ") called");
        int numNodes = 0;
        int machID = machine.getMachineNumberInt();
        try {
            numNodes = this.proxy.getNumNodesBlocking(machID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (numNodes <= 0) {
            String[] ne = new String[]{new String(String.valueOf(machine.getElementName()) + "_node0")};
            return ne;
        }
        String[] ne = new String[numNodes];
        int i = 0;
        while (i < numNodes) {
            ne[i] = new String(String.valueOf(machine.getElementName()) + "_node" + i);
            ++i;
        }
        return ne;
    }

    public String getNodeMachineName(String nodeName) {
        System.out.println("JAVA OMPI: getNodeMachineName(" + nodeName + ") called");
        return "machine0";
    }

    public String[] getNodeAttributes(IPNode node, String[] attribs) {
        System.out.println("ORTE Monitoring System: getNodeAttribute(" + node.getElementName() + ", " + attribs + ") called");
        IPMachine machine = node.getMachine();
        int machID = machine.getMachineNumberInt();
        int nodeID = node.getNodeNumberInt();
        String[] values = null;
        try {
            values = this.proxy.getNodeAttributesBlocking(machID, nodeID, attribs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return values;
    }

    public String[] getAllNodesAttributes(IPMachine machine, String[] attribs) {
        int machID = machine.getMachineNumberInt();
        String[] values = null;
        try {
            values = this.proxy.getAllNodesAttributesBlocking(machID, attribs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (values == null || values.length == 0) {
            System.out.println("NOTHING RETURNED FROM ORTE_SERVER, faking it with some blank data.");
            IPNode[] nodes = machine.getSortedNodes();
            int nlen = nodes.length;
            if (nodes == null || nodes.length == 0) {
                nlen = 1;
            }
            values = new String[attribs.length * nlen];
            int i = 0;
            while (i < nlen) {
                int j = 0;
                while (j < attribs.length) {
                    String attrib = attribs[j];
                    if (attrib.equals("ATTRIB_NODE_NAME")) {
                        values[i * attribs.length + j] = new String("" + i);
                    } else if (attrib.equals("ATTRIB_NODE_USER")) {
                        values[i * attribs.length + j] = System.getProperty("user.name");
                    } else if (attrib.equals("ATTRIB_NODE_GROUP")) {
                        values[i * attribs.length + j] = new String("ptp");
                    } else if (attrib.equals("ATTRIB_NODE_STATE")) {
                        values[i * attribs.length + j] = new String("up");
                    } else if (attrib.equals("ATTRIB_NODE_MODE")) {
                        values[i * attribs.length + j] = new String("73");
                    }
                    ++j;
                }
                ++i;
            }
        }
        return values;
    }

    public synchronized void handleEvent(IProxyRuntimeEvent e) {
        if (e instanceof ProxyRuntimeNodeChangeEvent) {
            RuntimeEvent re = new RuntimeEvent(6);
            String key = ((ProxyRuntimeNodeChangeEvent)e).getKey();
            String val = ((ProxyRuntimeNodeChangeEvent)e).getValue();
            int machID = ((ProxyRuntimeNodeChangeEvent)e).getMachineID();
            String nodeName = ((ProxyRuntimeNodeChangeEvent)e).getNodeName();
            String valid_key = null;
            if (key.equals("orte-node-bproc-user")) {
                valid_key = "ATTRIB_NODE_USER";
            } else if (key.equals("orte-node-bproc-mode")) {
                valid_key = "ATTRIB_NODE_MODE";
            } else if (key.equals("orte-node-bproc-group")) {
                valid_key = "ATTRIB_NODE_GROUP";
            } else if (key.equals("orte-node-bproc-status")) {
                valid_key = "ATTRIB_NODE_STATE";
            }
            if (valid_key != null) {
                re.setText(valid_key);
                re.setAltText(val);
                this.fireEvent("machine" + machID + "_node" + nodeName, re);
            } else {
                System.out.println("UNKNOWN KEY '" + key + "', value '" + val + "' - IGNORING.");
            }
        }
    }

    protected synchronized void fireEvent(String ID, RuntimeEvent event) {
        if (this.listeners == null) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IRuntimeListener listener = (IRuntimeListener)i.next();
            switch (event.getEventNumber()) {
                case 6: {
                    listener.runtimeNodeGeneralChange(ID, event.getText(), event.getAltText());
                }
            }
        }
    }
}

