/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.ompi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.BitSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.util.Queue;
import org.eclipse.ptp.rtsystem.IRuntimeProxy;
import org.eclipse.ptp.rtsystem.proxy.ProxyRuntimeClient;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.IProxyRuntimeEventListener;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeErrorEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeNewJobEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeNodeAttributeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeNodesEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeProcessAttributeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeProcessesEvent;

public class OMPIProxyRuntimeClient
extends ProxyRuntimeClient
implements IRuntimeProxy,
IProxyRuntimeEventListener {
    protected Queue events = new Queue();
    protected BitSet waitEvents = new BitSet();
    protected IModelManager modelManager;

    public OMPIProxyRuntimeClient(IModelManager modelManager) {
        super.addRuntimeEventListener(this);
        this.modelManager = modelManager;
    }

    public int runJob(String[] args) throws IOException {
        this.setWaitEvent(211);
        this.run(args);
        IProxyRuntimeEvent event = this.waitForRuntimeEvent();
        return ((ProxyRuntimeNewJobEvent)event).getJobID();
    }

    public int getJobProcesses(int jobID) throws IOException {
        this.setWaitEvent(204);
        this.getProcesses(jobID);
        IProxyRuntimeEvent event = this.waitForRuntimeEvent();
        return ((ProxyRuntimeProcessesEvent)event).getNumProcs();
    }

    public String[] getProcessAttributesBlocking(int jobID, int procID, String[] keys) throws IOException {
        this.setWaitEvent(205);
        this.getProcessAttribute(jobID, procID, keys);
        IProxyRuntimeEvent event = this.waitForRuntimeEvent();
        return ((ProxyRuntimeProcessAttributeEvent)event).getValues();
    }

    public String[] getAllProcessesAttribuesBlocking(int jobID, String[] keys) throws IOException {
        this.setWaitEvent(205);
        this.getProcessAttribute(jobID, -1, keys);
        IProxyRuntimeEvent event = this.waitForRuntimeEvent();
        return ((ProxyRuntimeProcessAttributeEvent)event).getValues();
    }

    public int getNumNodesBlocking(int machineID) throws IOException {
        this.setWaitEvent(207);
        this.getNodes(machineID);
        IProxyRuntimeEvent event = this.waitForRuntimeEvent();
        return ((ProxyRuntimeNodesEvent)event).getNumNodes();
    }

    public String[] getNodeAttributesBlocking(int machID, int nodeID, String[] keys) throws IOException {
        this.setWaitEvent(208);
        this.getNodeAttribute(machID, nodeID, keys);
        IProxyRuntimeEvent event = this.waitForRuntimeEvent();
        return ((ProxyRuntimeNodeAttributeEvent)event).getValues();
    }

    public String[] getAllNodesAttributesBlocking(int machID, String[] keys) throws IOException {
        this.setWaitEvent(208);
        this.getNodeAttribute(machID, -1, keys);
        IProxyRuntimeEvent event = this.waitForRuntimeEvent();
        return ((ProxyRuntimeNodeAttributeEvent)event).getValues();
    }

    public boolean startup(final IProgressMonitor monitor) {
        System.out.println("OMPIProxyRuntimeClient - firing up proxy, waiting for connecting.  Please wait!  This can take a minute . . .");
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        String proxyPath = preferences.getString("ORTE_SERVER_PATH");
        System.out.println("ORTE_SERVER path = '" + proxyPath + "'");
        if (proxyPath.equals("")) {
            proxyPath = PTPCorePlugin.getDefault().locateFragmentFile("org.eclipse.ptp.orte", "orte_server");
            if (proxyPath != null) {
                preferences.setValue("ORTE_SERVER_PATH", proxyPath);
            } else {
                String err = "Could not find the ORTE server ('orte_server' binary).  File not found in the fragment directory or developer directories.  Defaulting to Simulation Mode.";
                System.err.println(err);
                int MSI = 100;
                int CSI = 100;
                preferences.setValue("MONITORING_SYSTEM_SELECTION", MSI);
                preferences.setValue("CONTROL_SYSTEM_SELECTION", CSI);
                PTPCorePlugin.getDefault().savePluginPreferences();
                return false;
            }
        }
        final String proxyPath2 = preferences.getString("ORTE_SERVER_PATH");
        try {
            this.setWaitEvent(210);
            this.sessionCreate();
            if (preferences.getBoolean("ORTE_LAUNCH_MANUALLY")) {
                monitor.subTask("Waiting for manual lauch of orte_server on port " + this.getSessionPort() + "...");
            } else {
                Thread runThread = new Thread("Proxy Server Thread"){

                    public void run() {
                        block2: {
                            String cmd = String.valueOf(proxyPath2) + " --port=" + OMPIProxyRuntimeClient.this.getSessionPort();
                            System.out.println("RUNNING PROXY SERVER COMMAND: '" + cmd + "'");
                            try {
                                Process process = Runtime.getRuntime().exec(cmd);
                                BufferedReader err_reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                                BufferedReader out_reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                new Thread(new Runnable(this, out_reader){
                                    final /* synthetic */ 1 this$1;
                                    private final /* synthetic */ BufferedReader val$out_reader;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$out_reader = bufferedReader;
                                    }

                                    public void run() {
                                        try {
                                            String output;
                                            while ((output = this.val$out_reader.readLine()) != null) {
                                                System.out.println("++++++++++ orte_server: " + output);
                                            }
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }, "Program output Thread").start();
                                new Thread(new Runnable(this, err_reader){
                                    final /* synthetic */ 1 this$1;
                                    private final /* synthetic */ BufferedReader val$err_reader;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$err_reader = bufferedReader;
                                    }

                                    public void run() {
                                        try {
                                            String line;
                                            while ((line = this.val$err_reader.readLine()) != null) {
                                                PTPCorePlugin.log(line);
                                            }
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }, "Error output Thread").start();
                            }
                            catch (IOException e) {
                                PTPCorePlugin.errorDialog("Running Proxy Server", null, e);
                                if (monitor == null) break block2;
                                monitor.setCanceled(true);
                            }
                        }
                    }
                };
                runThread.setDaemon(true);
                runThread.start();
            }
            System.out.println("Waiting on accept.");
            this.waitForRuntimeEvent(monitor);
            this.setWaitEvent(200);
            this.sendCommand("STARTDAEMON");
            this.waitForRuntimeEvent();
        }
        catch (IOException iOException) {
            System.err.println("Exception starting up proxy. :(");
            try {
                this.sessionFinish();
            }
            catch (IOException e1) {
                PTPCorePlugin.log(e1);
            }
            return false;
        }
        return true;
    }

    public void shutdown() {
        try {
            System.out.println("OMPIProxyRuntimeClient shutting down server...");
            this.setWaitEvent(200);
            this.sessionFinish();
            this.waitForRuntimeEvent();
            System.out.println("OMPIProxyRuntimeClient shut down.");
        }
        catch (IOException e) {
            PTPCorePlugin.log(e);
        }
    }

    private void setWaitEvent(int eventID) {
        this.waitEvents.set(eventID);
        this.waitEvents.set(201);
    }

    private IProxyRuntimeEvent waitForRuntimeEvent() throws IOException {
        return this.waitForRuntimeEvent(null);
    }

    private synchronized IProxyRuntimeEvent waitForRuntimeEvent(IProgressMonitor monitor) throws IOException {
        IProxyRuntimeEvent event = null;
        System.out.println("OMPIProxyRuntimeClient waiting on " + this.waitEvents.toString());
        while (this.events.isEmpty()) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {}
            if (monitor == null || !monitor.isCanceled()) continue;
            throw new IOException("Cancelled by user");
        }
        System.out.println("OMPIProxyRuntimeClient awoke!");
        try {
            event = (IProxyRuntimeEvent)this.events.removeItem();
        }
        catch (InterruptedException e) {
            this.waitEvents.clear();
            throw new IOException(e.getMessage());
        }
        if (event instanceof ProxyRuntimeErrorEvent) {
            this.waitEvents.clear();
            throw new IOException(((ProxyRuntimeErrorEvent)event).getErrorMessage());
        }
        this.waitEvents.clear();
        return event;
    }

    public synchronized void handleEvent(IProxyRuntimeEvent e) {
        System.out.println("OMPIProxyRuntimeClient got event: " + e.toString());
        if (this.waitEvents.get(e.getEventID())) {
            System.out.println("OMPIProxyRuntimeClient notifying...");
            this.events.addItem(e);
            this.notifyAll();
        }
    }
}

