/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ptp.debug.internal.ui.PInstructionPointerAnnotation;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;

public class AnnotationGroup {
    private List annotationList = Collections.synchronizedList(new ArrayList());

    public boolean contains(Annotation annotation) {
        return this.annotationList.contains(annotation);
    }

    public void addAnnotation(PInstructionPointerAnnotation annotation) {
        if (!this.contains((Annotation)annotation)) {
            this.annotationList.add(annotation);
        }
    }

    public void removeAnnotations(Collection removedAnnotations) {
        this.annotationList.removeAll(removedAnnotations);
    }

    public void removeAnnotation(PInstructionPointerAnnotation annotation) {
        if (this.contains((Annotation)annotation)) {
            this.annotationList.remove((Object)annotation);
        }
    }

    public void removeAnnotations() {
        this.removeAllMarkers();
        this.annotationList.clear();
    }

    public int size() {
        return this.annotationList.size();
    }

    public Iterator getAnnotationIterator() {
        return this.annotationList.iterator();
    }

    public boolean isEmpty() {
        return this.annotationList.isEmpty();
    }

    public void clear() {
        this.annotationList.clear();
    }

    public void removeAllMarkers() {
        Iterator i = this.annotationList.iterator();
        while (i.hasNext()) {
            ((PInstructionPointerAnnotation)((Object)i.next())).deleteMarker();
        }
    }

    public void retrieveAllMarkers() {
        Iterator i = this.annotationList.iterator();
        while (i.hasNext()) {
            PInstructionPointerAnnotation annotation = (PInstructionPointerAnnotation)((Object)i.next());
            try {
                String type = annotation.getType();
                if (type.equals(IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT)) {
                    type = IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT;
                }
                annotation.setMarker(this.createMarker(annotation.getMarker().getResource(), type));
                annotation.getAnnotationModel().addAnnotation((Annotation)annotation, annotation.getPosition());
                annotation.setMessage(!type.equals(IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT));
            }
            catch (CoreException e) {
                PTPDebugUIPlugin.log(e);
            }
        }
    }

    public IMarker createMarker(IResource resource, String type) throws CoreException {
        return resource.createMarker(type);
    }
}

