/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.internal.ui.AnnotationGroup;
import org.eclipse.ptp.debug.internal.ui.PInstructionPointerAnnotation;
import org.eclipse.ptp.debug.internal.ui.UIDebugManager;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.listeners.IRegListener;
import org.eclipse.ptp.ui.listeners.IJobChangeListener;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PAnnotationManager
implements IRegListener,
IJobChangeListener {
    private static PAnnotationManager instance = null;
    protected UIDebugManager uiDebugManager = null;
    private Map annotationMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$0;

    public PAnnotationManager(UIDebugManager uiDebugManager) {
        this.uiDebugManager = uiDebugManager;
        uiDebugManager.addRegListener(this);
        uiDebugManager.addJobChangeListener(this);
        if (instance == null) {
            instance = this;
        }
    }

    public static PAnnotationManager getDefault() {
        if (instance == null) {
            instance = new PAnnotationManager(PTPDebugUIPlugin.getDefault().getUIDebugManager());
        }
        return instance;
    }

    public void shutdown() {
        this.uiDebugManager.removeRegListener(this);
        this.uiDebugManager.removeJobChangeListener(this);
        this.clearAllAnnotations();
        this.annotationMap = null;
    }

    public void clearAllAnnotations() {
        Iterator i = this.annotationMap.values().iterator();
        while (i.hasNext()) {
            ((AnnotationGroup)i.next()).removeAnnotations();
        }
        this.annotationMap.clear();
    }

    public void removeAnnotationGroup(String job_id) {
        if (!this.annotationMap.containsKey(job_id)) {
            return;
        }
        AnnotationGroup annotationGroup = (AnnotationGroup)this.annotationMap.remove(job_id);
        if (annotationGroup != null) {
            annotationGroup.removeAllMarkers();
            annotationGroup.clear();
        }
    }

    public void putAnnotationGroup(String job_id, AnnotationGroup annotationGroup) {
        this.annotationMap.put(job_id, annotationGroup);
    }

    public AnnotationGroup getAnnotationGroup(String job_id) {
        return (AnnotationGroup)this.annotationMap.get(job_id);
    }

    protected IStackFrame getTopStackFrame(IThread thread) {
        try {
            return thread.getTopStackFrame();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    protected IEditorPart openEditor(final IWorkbenchPage page, final IEditorInput input, final String id) {
        final IEditorPart[] editor = new IEditorPart[1];
        Runnable r = new Runnable(){

            public void run() {
                try {
                    editor[0] = page.openEditor(input, id, false);
                }
                catch (PartInitException e) {
                    PTPDebugUIPlugin.errorDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), "Error", "Cannot open editor", e);
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)r);
        return editor[0];
    }

    protected IEditorPart getEditorPart(final IFile file) {
        String fileExt = file.getFileExtension();
        if (fileExt == null || !fileExt.equals("c") && !fileExt.equals("cpp")) {
            return null;
        }
        final IEditorPart[] editor = new IEditorPart[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IEditorInput editorInput;
                IWorkbenchPage page = PTPDebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.getActiveEditor();
                if (editorPart != null && (editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput && ((IFileEditorInput)editorInput).getFile().equals((Object)file)) {
                    page.bringToTop((IWorkbenchPart)editorPart);
                    editor[0] = editorPart;
                    return;
                }
                if (editor == null) {
                    IEditorReference[] refs = page.getEditorReferences();
                    int i = 0;
                    while (i < refs.length) {
                        IEditorPart refEditor = refs[i].getEditor(false);
                        IEditorInput editorInput2 = refEditor.getEditorInput();
                        if (editorInput2 instanceof IFileEditorInput && ((IFileEditorInput)editorInput2).getFile().equals((Object)file)) {
                            page.bringToTop((IWorkbenchPart)refEditor);
                            editor[0] = refEditor;
                            return;
                        }
                        ++i;
                    }
                }
                try {
                    editor[0] = page.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.cdt.ui.editor.CEditor", false);
                }
                catch (PartInitException e) {
                    PTPDebugUIPlugin.errorDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), "Error", "Cannot open editor", e);
                }
            }
        });
        return editor[0];
    }

    protected IFile findFile(String fileName) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(fileName);
        if (path.isAbsolute()) {
            return workspaceRoot.getFileForLocation((IPath)path);
        }
        return workspaceRoot.getFile((IPath)path);
    }

    protected ITextEditor getTextEditor(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            return (ITextEditor)editorPart;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ITextEditor)editorPart.getAdapter((Class)clazz);
    }

    protected IFile getFile(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    protected Position createPosition(int lineNumber, IDocument doc) {
        if (doc == null) {
            return null;
        }
        try {
            IRegion region = doc.getLineInformation(lineNumber - 1);
            int charStart = region.getOffset();
            int length = region.getLength();
            if (charStart < 0) {
                return null;
            }
            return new Position(charStart, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public BitList getTasks(IDebugTarget debugTarget) {
        if (debugTarget instanceof IPDebugTarget) {
            int taskId = ((IPDebugTarget)debugTarget).getTargetID();
            if (taskId == -1) {
                return null;
            }
            BitList tasks = new BitList(100);
            tasks.set(taskId);
            return tasks;
        }
        return null;
    }

    public BitList getTasks(IThread thread) {
        return this.getTasks(thread.getDebugTarget());
    }

    public BitList getTasks(IStackFrame stackFrame) {
        return this.getTasks(stackFrame.getDebugTarget());
    }

    private boolean isRegisterType(String type) {
        return type.equals(IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_CURRENT) || type.equals(IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_SECONDARY);
    }

    public void focusAnnotation(IEditorPart editorPart, IStackFrame stackFrame) throws CoreException {
        IRegion region;
        ITextEditor textEditor = this.getTextEditor(editorPart);
        int charStart = stackFrame.getCharStart();
        if (charStart > 0) {
            textEditor.selectAndReveal(charStart, 0);
            return;
        }
        int lineNumber = stackFrame.getLineNumber();
        if ((region = this.getLineInformation(textEditor, --lineNumber)) != null) {
            textEditor.selectAndReveal(region.getOffset(), 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IEditorInput input;
        IDocumentProvider provider;
        block7: {
            IRegion iRegion;
            provider = editor.getDocumentProvider();
            input = editor.getEditorInput();
            try {
                provider.connect((Object)input);
            }
            catch (CoreException coreException) {
                return null;
            }
            try {
                try {
                    IDocument document = provider.getDocument((Object)input);
                    if (document == null) break block7;
                    iRegion = document.getLineInformation(lineNumber);
                    Object var6_7 = null;
                }
                catch (BadLocationException badLocationException) {
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                provider.disconnect((Object)input);
                throw throwable;
            }
            provider.disconnect((Object)input);
            return iRegion;
        }
        Object var6_9 = null;
        provider.disconnect((Object)input);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(IEditorPart editorPart, IStackFrame stackFrame) throws CoreException {
        ITextEditor textEditor = this.getTextEditor(editorPart);
        if (textEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IFile file = this.getFile(textEditor.getEditorInput());
        if (file == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        BitList tasks = this.getTasks(stackFrame);
        if (tasks == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IStackFrame tos = this.getTopStackFrame(stackFrame.getThread());
        String type = tos == null || stackFrame.equals(tos) ? IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_CURRENT : IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_SECONDARY;
        String job_id = this.uiDebugManager.getCurrentJobId();
        AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
        if (annotationGroup == null) {
            annotationGroup = new AnnotationGroup();
        }
        BitList bitList = tasks;
        synchronized (bitList) {
            this.addAnnotation(annotationGroup, textEditor, file, stackFrame.getLineNumber(), tasks, type);
            this.putAnnotationGroup(job_id, annotationGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(String job_id, String fullPathFileName, int lineNumber, BitList tasks, boolean isRegister) throws CoreException {
        if (tasks.isEmpty()) {
            return;
        }
        IFile file = this.findFile(fullPathFileName);
        if (file == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IEditorPart editorPart = this.getEditorPart(file);
        if (editorPart == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        ITextEditor textEditor = this.getTextEditor(editorPart);
        if (textEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        String type = isRegister ? IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_CURRENT : (this.containsCurrentSet(tasks) ? IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT : IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT);
        AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
        if (annotationGroup == null) {
            annotationGroup = new AnnotationGroup();
        }
        BitList bitList = tasks;
        synchronized (bitList) {
            if (this.uiDebugManager.getCurrentJobId().equals(job_id)) {
                this.addAnnotation(annotationGroup, textEditor, file, lineNumber, tasks, type);
                this.putAnnotationGroup(job_id, annotationGroup);
            }
        }
    }

    public boolean containsCurrentSet(BitList aTasks) {
        String set_id = this.uiDebugManager.getCurrentSetId();
        if (set_id.equals("Root")) {
            return true;
        }
        try {
            BitList tasks = PTPDebugCorePlugin.getDebugModel().getTasks(this.uiDebugManager.getCurrentJobId(), set_id);
            return tasks != null && tasks.intersects(aTasks);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public synchronized void addAnnotation(AnnotationGroup annotationGroup, final ITextEditor textEditor, IFile file, int lineNumber, BitList tasks, String type) throws CoreException {
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        IAnnotationModel annotationModel = docProvider.getAnnotationModel((Object)textEditor.getEditorInput());
        if (annotationModel == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        final Position position = this.createPosition(lineNumber, docProvider.getDocument((Object)textEditor.getEditorInput()));
        if (position == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        boolean isRegister = this.isRegisterType(type);
        PInstructionPointerAnnotation annotation = this.findAnnotation(annotationGroup, position, type);
        if (annotation == null) {
            IMarker marker = annotationGroup.createMarker((IResource)file, type);
            annotation = new PInstructionPointerAnnotation(marker, position, annotationModel);
            annotationGroup.addAnnotation(annotation);
            annotationModel.addAnnotation((Annotation)annotation, position);
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                textEditor.selectAndReveal(position.getOffset(), 0);
            }
        });
        annotation.addTasks(tasks);
        annotation.setMessage(isRegister);
    }

    public PInstructionPointerAnnotation findAnnotation(AnnotationGroup annotationGroup, Position position, String type) {
        Iterator i = annotationGroup.getAnnotationIterator();
        while (i.hasNext()) {
            String annotationType;
            PInstructionPointerAnnotation annotation = (PInstructionPointerAnnotation)((Object)i.next());
            if (!annotation.getPosition().equals((Object)position) || !(annotationType = annotation.getType()).equals(type)) continue;
            return annotation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotation(IEditorPart editorPart, IThread thread) throws CoreException {
        BitList tasks = this.getTasks(thread);
        if (tasks == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        String job_id = this.uiDebugManager.getCurrentJobId();
        AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
        if (annotationGroup != null) {
            BitList bitList = tasks;
            synchronized (bitList) {
                this.removeAnnotation(annotationGroup, tasks);
                if (annotationGroup.isEmpty()) {
                    this.removeAnnotationGroup(job_id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotation(String job_id, BitList tasks) throws CoreException {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
        if (annotationGroup != null) {
            BitList bitList = tasks;
            synchronized (bitList) {
                this.removeAnnotation(annotationGroup, tasks);
                if (annotationGroup.isEmpty()) {
                    this.removeAnnotationGroup(job_id);
                }
            }
        }
    }

    public synchronized void removeAnnotation(AnnotationGroup annotationGroup, BitList tasks) throws CoreException {
        ArrayList<PInstructionPointerAnnotation> removedList = new ArrayList<PInstructionPointerAnnotation>(0);
        Iterator i = annotationGroup.getAnnotationIterator();
        while (i.hasNext()) {
            PInstructionPointerAnnotation annotation = (PInstructionPointerAnnotation)((Object)i.next());
            annotation.removeTasks(tasks);
            if (annotation.isEmpty()) {
                if (!annotation.deleteMarker()) continue;
                removedList.add(annotation);
                continue;
            }
            annotation.setMessage(this.isRegisterType(annotation.getType()));
        }
        annotationGroup.removeAnnotations(removedList);
    }

    public Iterator findAnnotationIterator(AnnotationGroup annotationGroup, String type) {
        ArrayList<PInstructionPointerAnnotation> annotations = new ArrayList<PInstructionPointerAnnotation>();
        Iterator i = annotationGroup.getAnnotationIterator();
        while (i.hasNext()) {
            PInstructionPointerAnnotation annotation = (PInstructionPointerAnnotation)((Object)i.next());
            if (!annotation.getType().equals(type)) continue;
            annotations.add(annotation);
        }
        return annotations.iterator();
    }

    public Position findAnnotationPosition(AnnotationGroup annotationGroup, BitList tasks) {
        PInstructionPointerAnnotation annotation = this.findAnnotation(annotationGroup, tasks);
        if (annotation != null) {
            return annotation.getPosition();
        }
        return null;
    }

    public synchronized PInstructionPointerAnnotation findAnnotation(AnnotationGroup annotationGroup, BitList tasks) {
        if (tasks.isEmpty()) {
            return null;
        }
        Iterator i = annotationGroup.getAnnotationIterator();
        while (i.hasNext()) {
            PInstructionPointerAnnotation annotation = (PInstructionPointerAnnotation)((Object)i.next());
            if (!annotation.contains(tasks)) continue;
            return annotation;
        }
        return null;
    }

    public synchronized PInstructionPointerAnnotation findOtherAnnotation(AnnotationGroup annotationGroup, Position position, boolean isRegister) {
        if (position == null) {
            return null;
        }
        Iterator i = annotationGroup.getAnnotationIterator();
        while (i.hasNext()) {
            PInstructionPointerAnnotation annotation = (PInstructionPointerAnnotation)((Object)i.next());
            if (!annotation.getPosition().equals((Object)position)) continue;
            String annotationType = annotation.getType();
            if (!(isRegister ? annotationType.equals(IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT) || annotationType.equals(IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT) : annotationType.equals(IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_CURRENT) || annotationType.equals(IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_SECONDARY))) continue;
            return annotation;
        }
        return null;
    }

    public void changeAnnotationType(PInstructionPointerAnnotation annotation, String type) {
        if (!annotation.getType().equals(type)) {
            annotation.setType(type);
        }
    }

    public void updateAnnotation(final IElementSet currentSet, IElementSet preSet) throws CoreException {
        final AnnotationGroup annotationGroup = this.getAnnotationGroup(this.uiDebugManager.getCurrentJobId());
        if (annotationGroup == null) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                new Job(this, "Update Annotation", currentSet, annotationGroup){
                    final /* synthetic */ 4 this$1;
                    private final /* synthetic */ IElementSet val$currentSet;
                    private final /* synthetic */ AnnotationGroup val$annotationGroup;
                    {
                        this.this$1 = var1_1;
                        this.val$currentSet = iElementSet;
                        this.val$annotationGroup = annotationGroup;
                    }

                    protected IStatus run(IProgressMonitor pmonitor) {
                        try {
                            BitList tasks = PTPDebugCorePlugin.getDebugModel().getTasks(4.access$0(this.this$1).uiDebugManager.getCurrentJobId(), this.val$currentSet.getID());
                            Iterator i = this.val$annotationGroup.getAnnotationIterator();
                            while (i.hasNext()) {
                                PInstructionPointerAnnotation annotation = (PInstructionPointerAnnotation)((Object)i.next());
                                if (PAnnotationManager.access$0(4.access$0(this.this$1), annotation.getType())) continue;
                                if (this.val$currentSet.isRootSet()) {
                                    4.access$0(this.this$1).changeAnnotationType(annotation, IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT);
                                    continue;
                                }
                                4.access$0(this.this$1).changeAnnotationType(annotation, annotation.contains(tasks) ? IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT : IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT);
                            }
                        }
                        catch (CoreException coreException) {
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            static /* synthetic */ PAnnotationManager access$0(4 var0) {
                return var0.PAnnotationManager.this;
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    public void register(final BitList tasks) {
        String job_id = this.uiDebugManager.getCurrentJobId();
        final AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
        if (annotationGroup == null) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                new Job(this, "Update Annotation", annotationGroup, tasks){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ AnnotationGroup val$annotationGroup;
                    private final /* synthetic */ BitList val$tasks;
                    {
                        this.this$1 = var1_1;
                        this.val$annotationGroup = annotationGroup;
                        this.val$tasks = bitList;
                    }

                    protected IStatus run(IProgressMonitor pmonitor) {
                        PInstructionPointerAnnotation annotation = 6.access$0(this.this$1).findAnnotation(this.val$annotationGroup, this.val$tasks);
                        if (annotation != null) {
                            boolean isRegister = PAnnotationManager.access$0(6.access$0(this.this$1), annotation.getType());
                            try {
                                if (isRegister) {
                                    PAnnotationManager.access$1(6.access$0(this.this$1), this.val$annotationGroup, annotation, this.val$tasks, isRegister);
                                } else {
                                    PAnnotationManager.access$2(6.access$0(this.this$1), this.val$annotationGroup, annotation, this.val$tasks, isRegister);
                                }
                            }
                            catch (CoreException coreException) {
                                return Status.CANCEL_STATUS;
                            }
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            static /* synthetic */ PAnnotationManager access$0(6 var0) {
                return var0.PAnnotationManager.this;
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
    }

    public void unregister(final BitList tasks) {
        String job_id = this.uiDebugManager.getCurrentJobId();
        final AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
        if (annotationGroup == null) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                new Job(this, "Update Annotation", annotationGroup, tasks){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ AnnotationGroup val$annotationGroup;
                    private final /* synthetic */ BitList val$tasks;
                    {
                        this.this$1 = var1_1;
                        this.val$annotationGroup = annotationGroup;
                        this.val$tasks = bitList;
                    }

                    protected IStatus run(IProgressMonitor pmonitor) {
                        PInstructionPointerAnnotation annotation = 8.access$0(this.this$1).findAnnotation(this.val$annotationGroup, this.val$tasks);
                        if (annotation != null) {
                            boolean isRegister = PAnnotationManager.access$0(8.access$0(this.this$1), annotation.getType());
                            try {
                                if (isRegister) {
                                    PAnnotationManager.access$2(8.access$0(this.this$1), this.val$annotationGroup, annotation, this.val$tasks, isRegister);
                                } else {
                                    PAnnotationManager.access$1(8.access$0(this.this$1), this.val$annotationGroup, annotation, this.val$tasks, isRegister);
                                }
                            }
                            catch (CoreException coreException) {
                                return Status.CANCEL_STATUS;
                            }
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            static /* synthetic */ PAnnotationManager access$0(8 var0) {
                return var0.PAnnotationManager.this;
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
    }

    private synchronized void addToExistedAnnotation(AnnotationGroup annotationGroup, PInstructionPointerAnnotation annotation, BitList tasks, boolean isRegister) throws CoreException {
        annotation.addTasks(tasks);
        annotation.setMessage(isRegister);
        PInstructionPointerAnnotation oAnnotation = this.findOtherAnnotation(annotationGroup, annotation.getPosition(), isRegister);
        if (oAnnotation != null) {
            oAnnotation.removeTasks(tasks);
            if (oAnnotation.isEmpty()) {
                if (oAnnotation.deleteMarker()) {
                    annotationGroup.removeAnnotation(oAnnotation);
                }
            } else {
                oAnnotation.setMessage(!isRegister);
            }
        } else {
            String type = isRegister ? IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_CURRENT : (this.containsCurrentSet(tasks) ? IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT : IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT);
            IMarker marker = annotationGroup.createMarker(annotation.getMarker().getResource(), type);
            oAnnotation = new PInstructionPointerAnnotation(marker, annotation.getPosition(), annotation.getAnnotationModel());
            annotationGroup.addAnnotation(oAnnotation);
            annotation.getAnnotationModel().addAnnotation((Annotation)oAnnotation, annotation.getPosition());
            oAnnotation.addTasks(tasks);
            oAnnotation.setMessage(!isRegister);
        }
    }

    private synchronized void removeFromExistedAnnotation(AnnotationGroup annotationGroup, PInstructionPointerAnnotation annotation, BitList tasks, boolean isRegister) throws CoreException {
        PInstructionPointerAnnotation oAnnotation;
        annotation.removeTasks(tasks);
        if (annotation.isEmpty()) {
            if (annotation.deleteMarker()) {
                annotationGroup.removeAnnotation(annotation);
            }
        } else {
            annotation.setMessage(isRegister);
        }
        if ((oAnnotation = this.findOtherAnnotation(annotationGroup, annotation.getPosition(), isRegister)) != null) {
            oAnnotation.addTasks(tasks);
            oAnnotation.setMessage(!isRegister);
        } else {
            String type = isRegister ? (this.containsCurrentSet(tasks) ? IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT : IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT) : IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_CURRENT;
            IMarker marker = annotationGroup.createMarker(annotation.getMarker().getResource(), type);
            oAnnotation = new PInstructionPointerAnnotation(marker, annotation.getPosition(), annotation.getAnnotationModel());
            annotationGroup.addAnnotation(oAnnotation);
            annotation.getAnnotationModel().addAnnotation((Annotation)oAnnotation, annotation.getPosition());
            oAnnotation.addTasks(tasks);
            oAnnotation.setMessage(!isRegister);
        }
    }

    public synchronized void changeJobEvent(String cur_job_id, String pre_job_id) {
        AnnotationGroup curAnnotationGroup;
        AnnotationGroup preAnnotationGroup;
        if (pre_job_id != null && !pre_job_id.equals("") && (preAnnotationGroup = this.getAnnotationGroup(pre_job_id)) != null) {
            preAnnotationGroup.removeAllMarkers();
        }
        if (cur_job_id != null && (curAnnotationGroup = this.getAnnotationGroup(cur_job_id)) != null) {
            curAnnotationGroup.retrieveAllMarkers();
        }
    }

    static /* synthetic */ boolean access$0(PAnnotationManager pAnnotationManager, String string) {
        return pAnnotationManager.isRegisterType(string);
    }

    static /* synthetic */ void access$1(PAnnotationManager pAnnotationManager, AnnotationGroup annotationGroup, PInstructionPointerAnnotation pInstructionPointerAnnotation, BitList bitList, boolean bl) throws CoreException {
        pAnnotationManager.addToExistedAnnotation(annotationGroup, pInstructionPointerAnnotation, bitList, bl);
    }

    static /* synthetic */ void access$2(PAnnotationManager pAnnotationManager, AnnotationGroup annotationGroup, PInstructionPointerAnnotation pInstructionPointerAnnotation, BitList bitList, boolean bl) throws CoreException {
        pAnnotationManager.removeFromExistedAnnotation(annotationGroup, pInstructionPointerAnnotation, bitList, bl);
    }
}

