/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.PCDIDebugModel;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.ProcessInputStream;
import org.eclipse.ptp.debug.core.cdi.IPCDIErrorInfo;
import org.eclipse.ptp.debug.core.cdi.IPCDILineLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIDebugExitedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIErrorEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEventListener;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIExitedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIResumedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDISuspendedEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocationBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.core.launch.IPLaunchEvent;
import org.eclipse.ptp.debug.core.launch.IPLaunchListener;
import org.eclipse.ptp.debug.core.launch.PDebugTargetRegisterEvent;
import org.eclipse.ptp.debug.core.launch.PDebugTargetUnRegisterEvent;
import org.eclipse.ptp.debug.core.launch.PLaunchStartedEvent;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPVariableManager;
import org.eclipse.ptp.debug.external.core.cdi.BreakpointHitInfo;
import org.eclipse.ptp.debug.external.core.cdi.EndSteppingRangeInfo;
import org.eclipse.ptp.debug.external.core.cdi.event.BreakpointCreatedEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.BreakpointHitEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.EndSteppingRangeEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.InferiorSignaledEvent;
import org.eclipse.ptp.debug.internal.ui.PAnnotationManager;
import org.eclipse.ptp.debug.internal.ui.PDebugUIUtils;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.events.IDebugActionEvent;
import org.eclipse.ptp.debug.ui.events.ResumedDebugEvent;
import org.eclipse.ptp.debug.ui.events.SuspendedDebugEvent;
import org.eclipse.ptp.debug.ui.events.TerminatedDebugEvent;
import org.eclipse.ptp.debug.ui.listeners.IDebugActionUpdateListener;
import org.eclipse.ptp.debug.ui.listeners.IRegListener;
import org.eclipse.ptp.internal.ui.AbstractUIManager;
import org.eclipse.ptp.internal.ui.JobManager;
import org.eclipse.ptp.ui.OutputConsole;
import org.eclipse.ptp.ui.UIUtils;
import org.eclipse.ptp.ui.listeners.ISetListener;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class UIDebugManager
extends JobManager
implements ISetListener,
IBreakpointListener,
IPCDIEventListener,
IPLaunchListener {
    private static final int REG_TYPE = 1;
    private static final int UNREG_TYPE = 2;
    private List regListeners = new ArrayList();
    private List debugEventListeners = new ArrayList();
    private PAnnotationManager annotationMgr = null;
    private PCDIDebugModel debugModel = null;
    private Map consoleWindows = new HashMap();
    private IPVariableManager variableManager = null;

    public UIDebugManager() {
        this.addSetListener(this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.debugModel = PTPDebugCorePlugin.getDebugModel();
        this.variableManager = PTPDebugCorePlugin.getPVariableManager();
        this.debugModel.addLaunchListener((IPLaunchListener)this);
        this.annotationMgr = new PAnnotationManager(this);
    }

    public void shutdown() {
        this.removeSetListener(this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.regListeners.clear();
        this.debugModel.removeLaunchListener((IPLaunchListener)this);
        this.annotationMgr.shutdown();
        super.shutdown();
    }

    public IPVariableManager getPVariableManager() {
        return this.variableManager;
    }

    public String getValueText(IPJob job, int taskID) {
        return this.variableManager.getValueText(job, taskID);
    }

    private void defaultRegister(IPCDISession session) {
        IPProcess proc;
        if (PTPDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IPDebugConstants.PREF_PTP_DEBUG_REGISTER_PROC_0) && (proc = session.getJob().findProcessByTaskId(0)) != null) {
            this.registerProcess(session, proc, true);
        }
    }

    public boolean isDebugMode(String job_id) {
        if (this.isNoJob(job_id)) {
            return false;
        }
        return this.isDebugMode(this.findJobById(job_id));
    }

    public boolean isDebugMode(IPJob job) {
        if (job == null) {
            return false;
        }
        return job.isDebug();
    }

    public boolean isRunning(IPJob job) {
        if (job == null) {
            return false;
        }
        return job != null && !job.isAllStop();
    }

    public boolean isRunning(String job_id) {
        if (this.isNoJob(job_id)) {
            return false;
        }
        return this.isRunning(this.findJobById(job_id));
    }

    public void fireJobChangeEvent(String cur_jid, String pre_jid) {
        this.updateBreakpointMarker("Root");
        try {
            this.removeAllRegisterElements(pre_jid);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
        super.fireJobChangeEvent(cur_jid, pre_jid);
    }

    public void addDebugEventListener(IDebugActionUpdateListener listener) {
        if (!this.debugEventListeners.contains(listener)) {
            this.debugEventListeners.add(listener);
        }
    }

    public void removeDebugEventListener(IDebugActionUpdateListener listener) {
        if (this.debugEventListeners.contains(listener)) {
            this.debugEventListeners.remove(listener);
        }
    }

    public void fireDebugEvent(final IDebugActionEvent event) {
        Iterator i = this.debugEventListeners.iterator();
        while (i.hasNext()) {
            final IDebugActionUpdateListener dListener = (IDebugActionUpdateListener)i.next();
            Platform.run((ISafeRunnable)new AbstractUIManager.SafeNotifier((AbstractUIManager)this){

                public void run() {
                    dListener.handleDebugActionEvent(event);
                }
            });
        }
    }

    public void addRegListener(IRegListener listener) {
        if (!this.regListeners.contains(listener)) {
            this.regListeners.add(listener);
        }
    }

    public void removeRegListener(IRegListener listener) {
        if (this.regListeners.contains(listener)) {
            this.regListeners.remove(listener);
        }
    }

    public synchronized void fireRegListener(final int type, final BitList tasks) {
        Iterator i = this.regListeners.iterator();
        while (i.hasNext()) {
            final IRegListener rListener = (IRegListener)i.next();
            Platform.run((ISafeRunnable)new AbstractUIManager.SafeNotifier((AbstractUIManager)this){

                public void run() {
                    switch (type) {
                        case 1: {
                            rListener.register(tasks);
                            break;
                        }
                        case 2: {
                            rListener.unregister(tasks);
                        }
                    }
                }
            });
        }
    }

    public IPCDISession getDebugSession(String job_id) {
        if (this.isNoJob(job_id)) {
            return null;
        }
        IPJob job = this.findJobById(job_id);
        if (job == null) {
            return null;
        }
        return this.getDebugSession(job);
    }

    public IPCDISession getDebugSession(IPJob job) {
        return this.debugModel.getPCDISession(job);
    }

    public int convertToInt(String id) {
        return Integer.parseInt(id);
    }

    private void addConsoleWindow(IPProcess proc) {
        this.consoleWindows.put(proc, new OutputConsole(proc.getElementName(), (InputStream)new ProcessInputStream(proc)));
    }

    private void removeConsoleWindow(IPProcess proc) {
        OutputConsole outputConsole = (OutputConsole)this.consoleWindows.remove(proc);
        if (outputConsole != null) {
            outputConsole.kill();
        }
    }

    public void handleLaunchEvent(IPLaunchEvent event) {
        IPJob job = event.getJob();
        if (event instanceof PLaunchStartedEvent) {
            this.addJob(job);
            this.getDebugSession(job).getEventManager().addEventListener((IPCDIEventListener)this);
            this.defaultRegister(this.getDebugSession(job));
        } else if (event instanceof PDebugTargetRegisterEvent) {
            IElementHandler elementHandler = this.getElementHandler(job.getIDString());
            BitList tasks = ((PDebugTargetRegisterEvent)event).getTasks();
            int[] processes = tasks.toArray();
            int j = 0;
            while (j < processes.length) {
                IPProcess proc = job.findProcessByTaskId(processes[j]);
                IElement element = elementHandler.getSetRoot().get(proc.getIDString());
                element.setRegistered(true);
                elementHandler.addRegisterElement(element);
                ++j;
            }
            this.fireRegListener(1, tasks);
        } else if (event instanceof PDebugTargetUnRegisterEvent) {
            IElementHandler elementHandler = this.getElementHandler(job.getIDString());
            BitList tasks = ((PDebugTargetUnRegisterEvent)event).getTasks();
            int[] processes = tasks.toArray();
            int j = 0;
            while (j < processes.length) {
                IPProcess proc = job.findProcessByTaskId(processes[j]);
                IElement element = elementHandler.getSetRoot().get(proc.getIDString());
                element.setRegistered(false);
                elementHandler.removeRegisterElement(element);
                ++j;
            }
            this.fireRegListener(2, tasks);
        }
    }

    public void focusOnDebugTarget(IPJob job, int task_id) {
        Object debugObj = this.getDebugObject(job, task_id);
        if (debugObj != null) {
            this.focusOnDebugView(debugObj);
        }
    }

    public Object getDebugObject(IPJob job, int task_id) {
        IPDebugTarget debugTarget;
        IPCDISession session = this.getDebugSession(job);
        if (session != null && (debugTarget = session.getLaunch().getDebugTarget(task_id)) != null) {
            try {
                IThread[] threads = debugTarget.getThreads();
                int i = 0;
                while (i < threads.length) {
                    IStackFrame frame = threads[i].getTopStackFrame();
                    if (frame != null) {
                        return frame;
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {
                return debugTarget;
            }
            return debugTarget;
        }
        return null;
    }

    public void focusOnDebugView(Object selection) {
        Viewer viewer;
        IViewPart part = UIUtils.findView((String)"org.eclipse.debug.ui.DebugView");
        if (part != null && part instanceof IDebugView && (viewer = ((IDebugView)part).getViewer()) != null) {
            viewer.setSelection((ISelection)new StructuredSelection(selection));
        }
    }

    public void registerProcess(IPCDISession session, IPProcess proc, boolean isChanged) {
        session.registerTarget(proc.getTaskId(), isChanged);
        this.addConsoleWindow(proc);
    }

    public void unregisterProcess(IPCDISession session, IPProcess proc, boolean isChanged) {
        session.unregisterTarget(proc.getTaskId(), isChanged);
        this.removeConsoleWindow(proc);
    }

    public void unregisterElements(IElement[] elements) throws CoreException {
        IPJob job = this.findJobById(this.getCurrentJobId());
        if (job == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No job found", null));
        }
        IPCDISession session = this.getDebugSession(job);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        int i = 0;
        while (i < elements.length) {
            IPProcess process;
            if (elements[i].isRegistered() && (process = this.findProcess(job, elements[i].getID())) != null) {
                this.unregisterProcess(session, process, true);
            }
            ++i;
        }
    }

    public void registerElements(IElement[] elements) throws CoreException {
        IPJob job = this.findJobById(this.getCurrentJobId());
        if (job == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No job found", null));
        }
        IPCDISession session = this.getDebugSession(job);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        int i = 0;
        while (i < elements.length) {
            IPProcess process;
            if (!elements[i].isRegistered() && (process = this.findProcess(job, elements[i].getID())) != null && !process.isAllStop()) {
                this.registerProcess(session, process, true);
            }
            ++i;
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (PTPDebugUIPlugin.isPTPDebugPerspective() && breakpoint instanceof ICLineBreakpoint) {
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, true);
            }
            catch (CoreException e) {
                System.out.println("Err: " + e.getMessage());
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void updateBreakpointMarker(String cur_sid) {
        try {
            this.debugModel.updatePBreakpoints(cur_sid);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
    }

    public void removeAllRegisterElements(final String job_id) throws CoreException {
        final IElementHandler elementHandler = this.getElementHandler(job_id);
        if (elementHandler == null) {
            return;
        }
        Job uiJob = new Job("Removing registered processes"){

            protected IStatus run(IProgressMonitor pmonitor) {
                IPCDISession session = UIDebugManager.this.getDebugSession(job_id);
                if (session == null) {
                    return Status.CANCEL_STATUS;
                }
                IElement[] registerElements = elementHandler.getRegisteredElements();
                pmonitor.beginTask("Removing registering processes....", registerElements.length);
                int i = 0;
                while (i < registerElements.length) {
                    IPProcess proc = UIDebugManager.this.findProcess(job_id, registerElements[i].getID());
                    if (proc != null) {
                        UIDebugManager.this.unregisterProcess(session, proc, false);
                    }
                    pmonitor.worked(1);
                    ++i;
                }
                pmonitor.done();
                return Status.OK_STATUS;
            }
        };
        uiJob.setPriority(10);
        PlatformUI.getWorkbench().getProgressService().showInDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), uiJob);
        uiJob.schedule();
    }

    public void updateRegisterUnRegisterElements(final IElementSet curSet, final IElementSet preSet, final String job_id) throws CoreException {
        final IElementHandler elementHandler = this.getElementHandler(job_id);
        if (elementHandler == null) {
            return;
        }
        Job uiJob = new Job("Updating registered/unregistered processes"){

            protected IStatus run(IProgressMonitor pmonitor) {
                IPCDISession session = UIDebugManager.this.getDebugSession(job_id);
                if (session == null) {
                    return Status.CANCEL_STATUS;
                }
                IElement[] registerElements = elementHandler.getRegisteredElements();
                pmonitor.beginTask("Registering process....", registerElements.length);
                int i = 0;
                while (i < registerElements.length) {
                    IPProcess proc;
                    if (curSet.contains(registerElements[i].getID())) {
                        if ((curSet.isRootSet() || preSet != null && !curSet.equals(preSet) && !preSet.contains(registerElements[i].getID())) && (proc = UIDebugManager.this.findProcess(job_id, registerElements[i].getID())) != null) {
                            UIDebugManager.this.registerProcess(session, proc, false);
                        }
                    } else {
                        proc = UIDebugManager.this.findProcess(job_id, registerElements[i].getID());
                        if (proc != null) {
                            UIDebugManager.this.unregisterProcess(session, proc, false);
                        }
                    }
                    pmonitor.worked(1);
                    ++i;
                }
                pmonitor.done();
                return Status.OK_STATUS;
            }
        };
        uiJob.setPriority(10);
        PlatformUI.getWorkbench().getProgressService().showInDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), uiJob);
        uiJob.schedule();
    }

    public void changeSetEvent(IElementSet curSet, IElementSet preSet) {
        if (curSet == null) {
            return;
        }
        this.updateBreakpointMarker(curSet.getID());
        try {
            this.updateRegisterUnRegisterElements(curSet, preSet, this.getCurrentJobId());
            this.annotationMgr.updateAnnotation(curSet, preSet);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
    }

    public void deleteSetEvent(IElementSet set) {
        try {
            this.debugModel.deletePBreakpointBySet(this.getCurrentJobId(), set.getID());
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
        try {
            this.debugModel.deleteSet(this.getCurrentJobId(), set.getID());
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
    }

    public void createSetEvent(IElementSet set, IElement[] elements) {
        BitList tasks = new BitList(set.getElementHandler().getSetRoot().size());
        int i = 0;
        while (i < elements.length) {
            tasks.set(this.convertToInt(elements[i].getName()));
            ++i;
        }
        try {
            this.debugModel.createSet(this.getCurrentJobId(), set.getID(), tasks);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
    }

    public void addElementsEvent(IElementSet set, IElement[] elements) {
        BitList tasks = new BitList(set.getElementHandler().getSetRoot().size());
        int i = 0;
        while (i < elements.length) {
            tasks.set(this.convertToInt(elements[i].getName()));
            ++i;
        }
        try {
            this.debugModel.addTasks(this.getCurrentJobId(), set.getID(), tasks);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
    }

    public void removeElementsEvent(IElementSet set, IElement[] elements) {
        BitList tasks = new BitList(set.getElementHandler().getSetRoot().size());
        int i = 0;
        while (i < elements.length) {
            tasks.set(this.convertToInt(elements[i].getName()));
            ++i;
        }
        try {
            this.debugModel.removeTasks(this.getCurrentJobId(), set.getID(), tasks);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
    }

    public void handleDebugEvents(final IPCDIEvent[] events) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                UIDebugManager.this.handleDebugEvents(events, monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.log(e);
        }
    }

    private synchronized void handleDebugEvents(IPCDIEvent[] events, IProgressMonitor monitor) {
        int i = 0;
        while (i < events.length) {
            block17: {
                Boolean condition;
                block19: {
                    IPJob job;
                    IPCDIEvent event;
                    block22: {
                        block21: {
                            block20: {
                                block18: {
                                    condition = null;
                                    event = events[i];
                                    System.out.println("===================== event: " + event);
                                    job = event.getDebugJob();
                                    if (job == null) break block17;
                                    String workingDebugDir = (String)job.getAttribute("debug_dir");
                                    if (!(event instanceof IPCDISuspendedEvent)) break block18;
                                    int lineNumber = 0;
                                    String fileName = String.valueOf(workingDebugDir) + "/";
                                    if (event instanceof BreakpointHitEvent) {
                                        IPCDIBreakpoint bpt = ((BreakpointHitInfo)((BreakpointHitEvent)event).getReason()).getBreakpoint();
                                        if (bpt instanceof IPCDILocationBreakpoint) {
                                            IPCDILocator locator = ((IPCDILocationBreakpoint)bpt).getLocator();
                                            lineNumber = locator.getLineNumber();
                                            fileName = String.valueOf(fileName) + locator.getFile();
                                        }
                                    } else if (event instanceof EndSteppingRangeEvent) {
                                        IPCDILineLocation lineLocation = ((EndSteppingRangeInfo)((EndSteppingRangeEvent)event).getReason()).getLineLocation();
                                        if (lineLocation != null) {
                                            lineNumber = lineLocation.getLineNumber();
                                            fileName = String.valueOf(fileName) + lineLocation.getFile();
                                        }
                                    } else {
                                        IPCDILocator locator = ((InferiorSignaledEvent)event).getLocator();
                                        if (locator != null) {
                                            lineNumber = locator.getLineNumber();
                                            fileName = String.valueOf(fileName) + locator.getFile();
                                        }
                                    }
                                    if (lineNumber == 0) {
                                        lineNumber = 1;
                                    }
                                    try {
                                        this.annotationMgr.addAnnotation(job.getIDString(), fileName, lineNumber, event.getAllUnregisteredProcesses(), false);
                                        this.annotationMgr.addAnnotation(job.getIDString(), fileName, lineNumber, event.getAllRegisteredProcesses(), true);
                                    }
                                    catch (CoreException e) {
                                        PTPDebugUIPlugin.getDisplay().asyncExec(new Runnable(){

                                            public void run() {
                                                PTPDebugUIPlugin.errorDialog("Error", e);
                                            }
                                        });
                                    }
                                    this.updateDebugVariables(job);
                                    this.fireSuspendEvent(job, event.getAllProcesses());
                                    break block19;
                                }
                                if (!(event instanceof IPCDIResumedEvent)) break block20;
                                this.removeAnnotation(job.getIDString(), event.getAllProcesses());
                                this.cleanupDebugVariables(job);
                                this.fireResumeEvent(job, event.getAllProcesses());
                                break block19;
                            }
                            if (!(event instanceof IPCDIExitedEvent)) break block21;
                            this.removeAnnotation(job.getIDString(), event.getAllProcesses());
                            this.cleanupDebugVariables(job);
                            this.fireTerminatedEvent(job, event.getAllProcesses());
                            break block19;
                        }
                        if (!(event instanceof IPCDIErrorEvent)) break block22;
                        final IPCDIErrorEvent errEvent = (IPCDIErrorEvent)event;
                        if (errEvent.getErrorCode() != 0) {
                            this.removeAnnotation(job.getIDString(), event.getAllProcesses());
                        }
                        PTPDebugUIPlugin.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                IPCDIErrorInfo info = (IPCDIErrorInfo)errEvent.getReason();
                                PTPDebugUIPlugin.errorDialog("Error", new Exception(String.valueOf(info.getMessage()) + " on tasks: " + PDebugUIUtils.arrayToString(errEvent.getAllProcesses().toArray())));
                            }
                        });
                        this.cleanupDebugVariables(job);
                        break block19;
                    }
                    if (event instanceof BreakpointCreatedEvent) break block17;
                    if (event instanceof IPCDIDebugExitedEvent) {
                        condition = new Boolean(true);
                        this.annotationMgr.removeAnnotationGroup(job.getIDString());
                        System.err.println("--- TESTING exit event and remove all annotation in job: " + job.getIDString());
                        this.getDebugSession(job).getEventManager().removeEventListener((IPCDIEventListener)this);
                        this.cleanupDebugVariables(job);
                    }
                }
                this.firePaintListener(condition);
            }
            ++i;
        }
    }

    private void removeAnnotation(String job_id, BitList tasks) {
        try {
            this.annotationMgr.removeAnnotation(job_id, tasks);
            System.err.println("--- TESTING err event and remove annotation of processes in this event: " + tasks.cardinality());
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PTPDebugUIPlugin.errorDialog("Error", e);
                }
            });
        }
    }

    public void fireSuspendEvent(IPJob job, BitList tasks) {
        this.fireDebugEvent(new SuspendedDebugEvent(job.getIDString(), (BitList)job.getAttribute("suspended"), (BitList)job.getAttribute("terminated")));
    }

    public void fireResumeEvent(IPJob job, BitList tasks) {
        this.fireDebugEvent(new ResumedDebugEvent(job.getIDString(), (BitList)job.getAttribute("suspended"), (BitList)job.getAttribute("terminated")));
    }

    public void fireTerminatedEvent(IPJob job, BitList tasks) {
        this.fireDebugEvent(new TerminatedDebugEvent(job.getIDString(), (BitList)job.getAttribute("terminated"), (BitList)job.getAttribute("suspended")));
    }

    public BitList getCurrentSetTasks(String job_id, String set_id) throws CoreException {
        return this.debugModel.getTasks(job_id, set_id);
    }

    public void resume() throws CoreException {
        this.resume(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void resume(String job_id, String set_id) throws CoreException {
        IPCDISession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        try {
            session.resume(this.getCurrentSetTasks(job_id, set_id));
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void suspend() throws CoreException {
        this.suspend(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void suspend(String job_id, String set_id) throws CoreException {
        IPCDISession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        try {
            session.suspend(this.getCurrentSetTasks(job_id, set_id));
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void terminate() throws CoreException {
        this.terminate(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void terminate(String job_id, String set_id) throws CoreException {
        IPJob job = this.findJobById(job_id);
        if (this.isDebugMode(job)) {
            IPCDISession session = this.getDebugSession(job);
            if (session == null) {
                throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
            }
            try {
                session.stop(this.getCurrentSetTasks(job_id, set_id));
            }
            catch (PCDIException e) {
                throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
            }
        } else {
            super.terminateAll(job_id);
        }
    }

    public void stepInto() throws CoreException {
        this.stepInto(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepInto(String job_id, String set_id) throws CoreException {
        IPCDISession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        try {
            session.steppingInto(this.getCurrentSetTasks(job_id, set_id));
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void stepOver() throws CoreException {
        this.stepOver(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepOver(String job_id, String set_id) throws CoreException {
        IPCDISession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        try {
            session.steppingOver(this.getCurrentSetTasks(job_id, set_id));
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void stepReturn() throws CoreException {
        this.stepReturn(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepReturn(String job_id, String set_id) throws CoreException {
        IPCDISession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No session found", null));
        }
        try {
            session.steppingReturn(this.getCurrentSetTasks(job_id, set_id));
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void removeJob(IPJob job) {
        if (job.isDebug()) {
            try {
                this.debugModel.deletePBreakpointBySet(job.getIDString());
            }
            catch (CoreException e) {
                PTPDebugUIPlugin.log(e);
            }
            this.debugModel.deleteJob(job.getIDString());
            this.debugModel.shutdownSession(job);
        }
        super.removeJob(job);
    }

    public void cleanupDebugVariables(IPJob job) {
        this.variableManager.cleanVariables(job);
    }

    public void updateDebugVariables() {
        this.updateDebugVariables(this.findJobById(this.getCurrentJobId()));
    }

    public void updateDebugVariables(final IPJob pJob) {
        if (this.variableManager.hasVariable() && PTPDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IPDebugConstants.PREF_UPDATE_VARIABLES)) {
            final Job job = new Job("Refresh runtime system"){

                public IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        try {
                            UIDebugManager.this.variableManager.updateVariables(pJob, UIDebugManager.this.getCurrentSetId(), monitor);
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            PTPDebugUIPlugin.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PlatformUI.getWorkbench().getProgressService().showInDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), job);
                }
            });
            job.schedule();
        }
    }
}

