/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.views.ParallelDebugView;
import org.eclipse.ptp.ui.UIUtils;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class GotoSet
implements IViewActionDelegate {
    private IStructuredSelection selection = null;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        IPBreakpoint breakpoint = this.getPBreakpoint();
        if (breakpoint != null) {
            UIUtils.showView((String)IPTPDebugUIConstants.ID_VIEW_PARALLELDEBUG);
            ParallelDebugView view = ParallelDebugView.getDebugViewInstance();
            if (view != null) {
                try {
                    String jid = breakpoint.getJobId();
                    if (jid.equals("Global")) {
                        jid = "";
                    }
                    view.changeJob(jid);
                    IElementHandler elementHandler = view.getCurrentElementHandler();
                    if (elementHandler != null) {
                        view.selectSet(elementHandler.getSet(breakpoint.getSetId()));
                    }
                    view.update();
                    view.refresh();
                }
                catch (CoreException e) {
                    PTPDebugUIPlugin.log(e);
                }
            }
        }
    }

    private IPBreakpoint getPBreakpoint() {
        if (this.selection.isEmpty()) {
            return null;
        }
        Object obj = this.selection.getFirstElement();
        if (obj instanceof IPBreakpoint) {
            return (IPBreakpoint)obj;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            action.setEnabled(this.selection.size() == 1 && this.getPBreakpoint() != null);
        }
    }
}

