/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.debug.core.model.IPVariable;
import org.eclipse.ptp.debug.internal.ui.actions.ActionMessages;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class PVariableActionDelegate
extends ActionDelegate
implements IObjectActionDelegate,
IViewActionDelegate {
    private IPVariable[] fVariables = null;
    private IViewPart fView = null;

    public void init(IViewPart view) {
        this.fView = view;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IPVariable[] vars = this.getVariables();
        if (vars != null && vars.length > 0) {
            final MultiStatus ms = new MultiStatus(PTPDebugUIPlugin.getUniqueIdentifier(), 5012, "", null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        PVariableActionDelegate.this.doAction(PVariableActionDelegate.this.getVariables());
                    }
                    catch (DebugException e) {
                        ms.merge(e.getStatus());
                    }
                }
            });
            if (!ms.isOK()) {
                IWorkbenchWindow window = PTPDebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null) {
                    PTPDebugUIPlugin.errorDialog(ActionMessages.getString("VariableFormatActionDelegate.0"), (IStatus)ms);
                } else {
                    PTPDebugUIPlugin.log((IStatus)ms);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList list = new ArrayList();
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Iterator i = ssel.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof IPVariable)) continue;
                list.add(o);
            }
            this.setVariables(list.toArray(new IPVariable[list.size()]));
            action.setEnabled(list.size() > 0);
        } else {
            action.setEnabled(false);
        }
    }

    protected IPVariable[] getVariables() {
        return this.fVariables;
    }

    private void setVariables(IPVariable[] variables) {
        this.fVariables = variables;
    }

    protected abstract void doAction(IPVariable[] var1) throws DebugException;

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart viewPart) {
        this.fView = viewPart;
    }
}

