/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.internal.ui.UIDebugManager;
import org.eclipse.ptp.debug.internal.ui.actions.ActionMessages;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    private UIDebugManager uiDebugManager = PTPDebugUIPlugin.getDefault().getUIDebugManager();
    static /* synthetic */ Class class$0;

    /*
     * Enabled aggressive block sorting
     */
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (!PTPDebugUIPlugin.isPTPDebugPerspective()) {
            return;
        }
        String errorMessage = null;
        if (!(part instanceof ITextEditor)) {
            errorMessage = ActionMessages.getString("RunToLineAdapter.Operation_is_not_supported_1");
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ITextEditor textEditor = (ITextEditor)part;
        IEditorInput input = textEditor.getEditorInput();
        if (input == null) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Empty_editor_1");
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_document_1");
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IResource resource = ToggleBreakpointAdapter.getResource((IWorkbenchPart)textEditor);
        if (resource == null) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_resource_1");
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
        int lineNumber = bv.getValidLineBreakpointLocation(document, ((ITextSelection)selection).getStartLine());
        if (lineNumber == -1) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        String jid = this.uiDebugManager.getCurrentJobId();
        String jobName = "";
        if (this.uiDebugManager.isNoJob(jid)) {
            jid = "Global";
            jobName = "Global";
        } else {
            jobName = this.uiDebugManager.getName(jid);
        }
        String sid = this.uiDebugManager.getCurrentSetId();
        sid = sid == null || sid.length() == 0 ? "Root" : sid;
        String sourceHandle = this.getSourceHandle(input);
        IPLineBreakpoint[] breakpoints = PTPDebugCorePlugin.getDebugModel().lineBreakpointsExists(sourceHandle, resource, lineNumber);
        if (jid.equals("Global") && breakpoints.length > 0) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints((IBreakpoint[])breakpoints, true);
            return;
        }
        if (breakpoints.length <= 0) {
            PTPDebugCorePlugin.getDebugModel().createLineBreakpoint(sourceHandle, resource, lineNumber, true, 0, "", true, sid, jid, jobName);
            return;
        }
        IPLineBreakpoint breakpoint = PTPDebugCorePlugin.getDebugModel().lineBreakpointExists(breakpoints, jid);
        if (breakpoint != null) {
            if (breakpoint.isGlobal()) return;
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            return;
        }
        PTPDebugCorePlugin.getDebugModel().createLineBreakpoint(sourceHandle, resource, lineNumber, true, 0, "", true, sid, jid, jobName);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        System.out.println("*** Not Implemented YET ***");
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    protected void report(String message, IWorkbenchPart part) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)part.getAdapter((Class)clazz)) != null) {
            if (message != null) {
                statusLine.setMessage(true, message, null);
            } else {
                statusLine.setMessage(true, null, null);
            }
        }
        if (message != null && PTPDebugUIPlugin.getActiveWorkbenchShell() != null) {
            PTPDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    protected static IResource getResource(IWorkbenchPart part) {
        IEditorInput editorInput;
        if (part instanceof IEditorPart && (editorInput = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private String getSourceHandle(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getLocation().toOSString();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getFullPath().toOSString();
        }
        return "";
    }

    private class BreakpointLocationVerifier {
        BreakpointLocationVerifier() {
        }

        public int getValidLineBreakpointLocation(IDocument doc, int lineNumber) {
            return lineNumber + 1;
        }

        public int getValidAddressBreakpointLocation(IDocument doc, int lineNumber) {
            return lineNumber + 1;
        }
    }
}

