/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.dialogs;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ptp.debug.internal.ui.dialogs.VariableDialog;
import org.eclipse.swt.widgets.Shell;

public class ArrayVariableDialog
extends VariableDialog {
    private static final String ARRAY_TAG = "[";

    public ArrayVariableDialog(Shell parent, IStackFrame frame) {
        super(parent, frame);
    }

    protected ViewerFilter getViewFilter() {
        return new ArrayFilter();
    }

    private class ArrayFilter
    extends ViewerFilter {
        ArrayFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IVariable) {
                try {
                    return this.isArray((IVariable)element);
                }
                catch (DebugException debugException) {
                    return false;
                }
            }
            return false;
        }

        private boolean isArray(IVariable variable) throws DebugException {
            return variable.getReferenceTypeName().indexOf(ArrayVariableDialog.ARRAY_TAG) > -1;
        }
    }
}

