/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.debug.internal.ui.dialogs.DialogMessages;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RangeDialog
extends Dialog {
    private Group rowGroup = null;
    private Group colGroup = null;
    private IntegerFieldEditor rowFromField = null;
    private IntegerFieldEditor rowToField = null;
    private IntegerFieldEditor colFromField = null;
    private IntegerFieldEditor colToField = null;
    private Text errorMessageText = null;
    private int maxRow = 0;
    private int maxCol = 0;
    private int fromRow = 0;
    private int toRow = 0;
    private int fromCol = 0;
    private int toCol = 0;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            int toValue;
            int fromValue;
            boolean hasError = false;
            if (RangeDialog.this.colGroup.isEnabled()) {
                boolean bl = hasError = !RangeDialog.this.colFromField.isValid() || !RangeDialog.this.colToField.isValid();
                if (!hasError) {
                    fromValue = RangeDialog.this.colFromField.getIntValue();
                    toValue = RangeDialog.this.colToField.getIntValue();
                    boolean bl2 = hasError = fromValue < 0 || fromValue >= toValue || toValue > RangeDialog.this.maxCol;
                }
            }
            if (RangeDialog.this.rowGroup.isEnabled() && !hasError) {
                boolean bl = hasError = !RangeDialog.this.rowFromField.isValid() || !RangeDialog.this.rowToField.isValid();
                if (!hasError) {
                    fromValue = RangeDialog.this.rowFromField.getIntValue();
                    toValue = RangeDialog.this.rowToField.getIntValue();
                    hasError = fromValue < 0 || fromValue >= toValue || toValue > RangeDialog.this.maxRow;
                }
            }
            RangeDialog.this.getOkButton().setEnabled(!hasError);
            RangeDialog.this.errorMessageText.setText(hasError ? "Invalid input" : "");
        }
    };

    public RangeDialog(Shell parentShell, int maxCol, int maxRow) {
        super(parentShell);
        this.maxCol = maxCol;
        this.toCol = maxCol;
        this.maxRow = maxRow;
        this.toRow = maxRow;
    }

    public int getFromRow() {
        return this.fromRow;
    }

    public int getToRow() {
        return this.toRow;
    }

    public int getFromCol() {
        return this.fromCol;
    }

    public int getToCol() {
        return this.toCol;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.fromRow = this.rowFromField.getIntValue();
            this.toRow = this.rowToField.getIntValue();
            this.fromCol = this.colFromField.getIntValue();
            this.toCol = this.colToField.getIntValue();
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DialogMessages.getString("RangeDialog.group"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setEnabled(false);
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.colGroup = new Group(composite, 0);
        this.colGroup.setText(DialogMessages.getString("RangeDialog.column"));
        this.colGroup.setLayout((Layout)new FillLayout());
        this.colGroup.setLayoutData((Object)new GridData(1808));
        this.colFromField = new RangeIntegerFieldEditor("colFromField", DialogMessages.getString("RangeDialog.from"), (Composite)this.colGroup);
        this.colFromField.setPropertyChangeListener(this.listener);
        this.colToField = new RangeIntegerFieldEditor("colToField", DialogMessages.getString("RangeDialog.to"), (Composite)this.colGroup);
        this.colToField.setPropertyChangeListener(this.listener);
        this.rowGroup = new Group(composite, 0);
        this.rowGroup.setText(DialogMessages.getString("RangeDialog.row"));
        this.rowGroup.setLayout((Layout)new FillLayout());
        this.rowGroup.setLayoutData((Object)new GridData(1808));
        this.rowFromField = new RangeIntegerFieldEditor("rowFromField", DialogMessages.getString("RangeDialog.from"), (Composite)this.rowGroup);
        this.rowFromField.setPropertyChangeListener(this.listener);
        this.rowToField = new RangeIntegerFieldEditor("rowToField", DialogMessages.getString("RangeDialog.to"), (Composite)this.rowGroup);
        this.rowToField.setPropertyChangeListener(this.listener);
        this.errorMessageText = new Text(composite, 8);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        return composite;
    }

    public int open(boolean showCol, boolean showRow, int fromCol, int toCol, int fromRow, int toRow) {
        this.fromCol = fromCol;
        this.toCol = toCol == 0 ? this.maxCol : toCol;
        this.fromRow = fromRow;
        this.toRow = toRow == 0 ? this.maxRow : toRow;
        return this.open(showCol, showRow);
    }

    private int open(boolean showCol, boolean showRow) {
        this.create();
        this.colGroup.setEnabled(showCol);
        this.colFromField.setEnabled(showCol, (Composite)this.colGroup);
        this.colToField.setEnabled(showCol, (Composite)this.colGroup);
        this.rowGroup.setEnabled(showRow);
        this.rowFromField.setEnabled(showRow, (Composite)this.rowGroup);
        this.rowToField.setEnabled(showRow, (Composite)this.rowGroup);
        this.colFromField.setStringValue("" + this.fromCol);
        this.colToField.setStringValue("" + this.toCol);
        this.rowFromField.setStringValue("" + this.fromRow);
        this.rowToField.setStringValue("" + this.toRow);
        return this.open();
    }

    private class RangeIntegerFieldEditor
    extends IntegerFieldEditor {
        RangeIntegerFieldEditor(String name, String label, Composite parent) {
            super(name, label, parent);
        }

        protected void createControl(Composite parent) {
            GridLayout layout = new GridLayout();
            layout.numColumns = this.getNumberOfControls();
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            layout.horizontalSpacing = 8;
            parent.setLayout((Layout)layout);
            this.doFillIntoGrid(parent, layout.numColumns);
        }
    }
}

