/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.array;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.ptp.debug.internal.ui.dialogs.RangeDialog;
import org.eclipse.ptp.debug.internal.ui.views.PTabFolder;
import org.eclipse.ptp.debug.internal.ui.views.PTabItem;
import org.eclipse.ptp.debug.internal.ui.views.array.ArrayMessages;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ArrayTabItem
extends PTabItem {
    private final int COL_TYPE = 0;
    private final int ROW_TYPE = 1;
    private SashForm sashForm = null;
    private Table colTable = null;
    private Table rowTable = null;
    private ScrolledComposite tableSC = null;
    private ScrolledComposite comboSC = null;
    private Combo[] comboBoxes = new Combo[0];
    private IVariable variable = null;
    private int startRow = 0;
    private int startCol = 0;
    private int endRow = 0;
    private int endCol = 0;
    private Button selectedRowButton = null;
    private Button selectedColButton = null;

    public ArrayTabItem(PTabFolder view, String tabText) {
        super(view, tabText);
        this.setControl();
    }

    public void init(final IVariable variable) {
        this.variable = variable;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor pmonitor) throws InvocationTargetException {
                if (pmonitor == null) {
                    pmonitor = new NullProgressMonitor();
                }
                pmonitor.beginTask(MessageFormat.format("{0}", ArrayMessages.getString("ArrayTabItem.initVariable")), 10);
                try {
                    try {
                        ArrayList varList = new ArrayList();
                        if (!ArrayTabItem.this.setVariables(varList, variable.getValue(), pmonitor)) {
                            throw new InvocationTargetException(new Exception(ArrayMessages.getString("ArrayTabItem.cancel")));
                        }
                        pmonitor.worked(3);
                        ArrayTabItem.this.setupComboBoxes(varList.toArray(new Integer[varList.size()]), pmonitor);
                    }
                    catch (DebugException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    pmonitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                pmonitor.done();
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this, runnable, null);
        }
        catch (InterruptedException e) {
            this.displayError(e);
        }
        catch (InvocationTargetException e1) {
            this.displayError(e1);
        }
    }

    public boolean setVariables(List varList, IValue value, IProgressMonitor monitor) throws DebugException {
        if (monitor.isCanceled()) {
            return false;
        }
        if (value.hasVariables()) {
            IVariable[] vars = value.getVariables();
            varList.add(new Integer(vars.length));
            return this.setVariables(varList, vars[0].getValue(), monitor);
        }
        return true;
    }

    protected void dispose() {
        this.clearContext();
        this.variable = null;
        this.comboBoxes = new Combo[0];
    }

    protected void clearContext() {
        this.disposeTable();
        this.selectedRowButton = null;
        this.selectedColButton = null;
    }

    public void displayTab() {
        if (!this.displayError) {
            this.fPageBook.showPage((Control)this.sashForm);
        }
    }

    public void createTabPage(Composite parent) {
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.setLayout((Layout)new FillLayout(512));
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.createComboBoxes((Composite)this.sashForm);
        this.createTableComposite((Composite)this.sashForm);
    }

    public void createComboBoxes(Composite parent) {
        this.comboSC = new ScrolledComposite(parent, 512);
        Composite comboComp = new Composite((Composite)this.comboSC, 0);
        comboComp.setLayout((Layout)new GridLayout(3, false));
        comboComp.setLayoutData((Object)new GridData(64));
        this.comboSC.setContent((Control)comboComp);
        this.comboSC.setExpandVertical(true);
        this.comboSC.setExpandHorizontal(true);
    }

    protected void createTableComposite(Composite parent) {
        this.tableSC = new ScrolledComposite(parent, 768);
        Composite tableComp = new Composite((Composite)this.tableSC, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tableComp.setLayout((Layout)layout);
        tableComp.setLayoutData((Object)new GridData(1808));
        this.tableSC.setContent((Control)tableComp);
        this.tableSC.setExpandVertical(true);
        this.tableSC.setExpandHorizontal(true);
    }

    protected void createRowTable(Composite parent, boolean showColHeader) {
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.rowTable = new Table(parent, 12);
        this.rowTable.setLayout((Layout)tableLayout);
        this.rowTable.setLayoutData((Object)new GridData(2));
        this.rowTable.setHeaderVisible(showColHeader);
        this.rowTable.setEnabled(false);
        this.rowTable.setBackground(Display.getDefault().getSystemColor(22));
        TableColumn rowColumn = new TableColumn(this.rowTable, 131072);
        rowColumn.setMoveable(false);
        rowColumn.setResizable(false);
    }

    protected void createColumnTable(Composite parent, boolean showColHeader) {
        this.colTable = new Table(parent, 65540);
        this.colTable.setLayoutData((Object)new GridData(1808));
        this.colTable.setHeaderVisible(showColHeader);
        this.colTable.setLinesVisible(true);
        this.colTable.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 8) {
                    ArrayTabItem.this.resetRangeAction();
                }
            }
        });
        this.colTable.setMenu(this.createPopupMenu());
    }

    protected Menu createPopupMenu() {
        Menu menu = new Menu((Control)this.colTable);
        MenuItem mItem = new MenuItem(menu, 8);
        mItem.setText(ArrayMessages.getString("ArrayTabItem.resetRange"));
        mItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayTabItem.this.resetRangeAction();
            }
        });
        return menu;
    }

    public boolean isTableDisposed() {
        return !(this.colTable != null && !this.colTable.isDisposed() || this.rowTable != null && !this.rowTable.isDisposed());
    }

    public void disposeTable() {
        if (this.colTable != null && !this.colTable.isDisposed()) {
            this.colTable.removeAll();
            this.colTable.dispose();
            this.colTable = null;
        }
        if (this.rowTable != null && !this.rowTable.isDisposed()) {
            this.rowTable.removeAll();
            this.rowTable.dispose();
            this.rowTable = null;
        }
        if (this.tableSC != null && !this.tableSC.isDisposed()) {
            this.tableSC.setMinSize(this.tableSC.getContent().computeSize(-1, -1));
        }
    }

    public void createTable(int sRow, int eRow, int sCol, int eCol, boolean showColHeader, boolean showRowHeader, IProgressMonitor monitor) {
        if (showRowHeader) {
            this.createRowTable((Composite)this.tableSC.getContent(), showColHeader);
            this.fillRowHeaders(sRow, eRow, monitor);
        }
        this.createColumnTable((Composite)this.tableSC.getContent(), showColHeader);
        if (showColHeader) {
            this.fillColumnHeaders(sCol, eCol, monitor);
        }
        this.tableSC.setMinSize(this.tableSC.getContent().computeSize(-1, -1));
    }

    public void updateTable() {
        this.updateTable(this.getIndex(this.selectedColButton), this.getIndex(this.selectedRowButton));
    }

    public void updateTable(int colIndex, int rowIndex) {
        if (colIndex == -1 && rowIndex == -1) {
            PTPDebugUIPlugin.errorDialog(this.fPageBook.getShell(), ArrayMessages.getString("ArrayTabItem.noIndexErrTitle"), ArrayMessages.getString("ArrayTabItem.noIndexErrMsg"), new Exception());
            return;
        }
        this.updateTableContent(colIndex, rowIndex);
    }

    private void updateTableContent(final int colIndex, final int rowIndex) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                if (ArrayTabItem.this.isTableDisposed()) {
                    ArrayTabItem.this.createTable(ArrayTabItem.this.startRow, ArrayTabItem.this.endRow, ArrayTabItem.this.startCol, ArrayTabItem.this.endCol, colIndex > -1, rowIndex > -1, monitor);
                }
                ArrayTabItem.this.colTable.removeAll();
                monitor.beginTask(MessageFormat.format("{0}", ArrayMessages.getString("ArrayTabItem.updateTable")), (ArrayTabItem.this.endRow - ArrayTabItem.this.startRow) * (ArrayTabItem.this.endCol - ArrayTabItem.this.startCol));
                try {
                    int i = ArrayTabItem.this.startRow;
                    block5: while (i < ArrayTabItem.this.endRow) {
                        TableItem item = new TableItem(ArrayTabItem.this.colTable, 0);
                        int colPos = 0;
                        int j = ArrayTabItem.this.startCol;
                        while (true) {
                            if (j >= ArrayTabItem.this.endCol) {
                                ++i;
                                continue block5;
                            }
                            if (monitor.isCanceled()) {
                                throw new InterruptedException(ArrayMessages.getString("ArrayTabItem.cancel"));
                            }
                            try {
                                item.setText(colPos++, ArrayTabItem.this.getValueString(rowIndex, i, colIndex, j));
                                monitor.worked(1);
                            }
                            catch (DebugException e) {
                                throw new InvocationTargetException(e);
                            }
                            ++j;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    monitor.subTask(ArrayMessages.getString("ArrayTabItem.done"));
                    monitor.done();
                    ArrayTabItem.this.tableSC.setFocus();
                    throw throwable;
                }
                {
                    Object var7_9 = null;
                }
                monitor.subTask(ArrayMessages.getString("ArrayTabItem.done"));
                monitor.done();
                ArrayTabItem.this.tableSC.setFocus();
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this, runnable, null);
        }
        catch (InterruptedException e) {
            this.disposeTable();
            this.displayError(e);
        }
        catch (InvocationTargetException e1) {
            this.disposeTable();
            this.displayError(e1);
        }
    }

    public String getValueString(int rowIndex, int row, int colIndex, int col) throws DebugException {
        IVariable var = this.variable;
        int i = 0;
        while (i < this.comboBoxes.length) {
            IVariable[] vars = var.getValue().getVariables();
            if (vars.length == 0) {
                throw new DebugException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No Value found", null));
            }
            var = i == rowIndex ? vars[row] : (i == colIndex ? vars[col] : vars[this.comboBoxes[i].getSelectionIndex()]);
            ++i;
        }
        return var.getValue().getValueString();
    }

    public void fillRowHeaders(int sRow, int eRow, IProgressMonitor monitor) {
        IProgressMonitor subMonitor = monitor;
        subMonitor.beginTask(ArrayMessages.getString("ArrayTabItem.initRow"), eRow - sRow);
        TableItem item = null;
        int i = sRow;
        while (i < eRow) {
            item = new TableItem(this.rowTable, 0);
            item.setText("" + i);
            subMonitor.worked(1);
            ++i;
        }
        this.rowTable.getColumn(0).setWidth(this.getTextSize((Composite)this.rowTable, (String)new StringBuffer().append((int)eRow).toString()).x - 2);
        subMonitor.done();
    }

    public void fillColumnHeaders(int sCol, int eCol, IProgressMonitor monitor) {
        IProgressMonitor subMonitor = monitor;
        subMonitor.beginTask(ArrayMessages.getString("ArrayTabItem.initCol"), eCol - sCol);
        TableColumn column = null;
        int i = sCol;
        while (i < eCol) {
            column = new TableColumn(this.colTable, 0x1000000);
            column.setText("" + i);
            column.setWidth(30);
            column.setMoveable(false);
            column.setResizable(true);
            subMonitor.worked(1);
            ++i;
        }
        subMonitor.done();
    }

    public void setupComboBoxes(Integer[] vars, IProgressMonitor monitor) {
        IProgressMonitor subMonitor = monitor;
        subMonitor.beginTask(ArrayMessages.getString("ArrayTabItem.initCombobox"), vars.length);
        Composite comboComp = (Composite)this.comboSC.getContent();
        new Label(comboComp, 8).setText(ArrayMessages.getString("ArrayTabItem.colHead"));
        new Label(comboComp, 8).setText(ArrayMessages.getString("ArrayTabItem.rowHead"));
        Button showTableButton = new Button(comboComp, 131076);
        showTableButton.setToolTipText(ArrayMessages.getString("ArrayTabItem.showTable"));
        showTableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayTabItem.this.updateTable();
            }
        });
        Button rowButton = null;
        Button colButton = null;
        this.comboBoxes = new Combo[vars.length];
        int i = 0;
        while (i < vars.length) {
            int total = vars[i];
            colButton = new Button(comboComp, 32);
            colButton.setLayoutData((Object)new GridData(64));
            colButton.setData((Object)new Integer(i));
            colButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayTabItem.this.setColButton((Button)e.getSource());
                }
            });
            rowButton = new Button(comboComp, 32);
            rowButton.setLayoutData((Object)new GridData(64));
            rowButton.setData((Object)new Integer(i));
            rowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayTabItem.this.setRowButton((Button)e.getSource());
                }
            });
            this.comboBoxes[i] = new Combo(comboComp, 8);
            this.comboBoxes[i].setLayoutData((Object)new GridData(256));
            subMonitor.subTask(ArrayMessages.getString("ArrayTabItem.creatingCombobox"));
            SubProgressMonitor subTotalMonitor = new SubProgressMonitor(subMonitor, total);
            int j = 0;
            while (j < total) {
                this.comboBoxes[i].add("" + j);
                subTotalMonitor.worked(1);
                ++j;
            }
            subTotalMonitor.done();
            this.comboBoxes[i].select(0);
            this.comboBoxes[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayTabItem.this.updateTable();
                }
            });
            subMonitor.worked(1);
            ++i;
        }
        subMonitor.done();
        Point pt = comboComp.computeSize(-1, -1);
        this.comboSC.setMinSize(pt);
        this.sashForm.setWeights(new int[]{pt.x + 30, this.view.getTabFolder().getClientArea().width});
    }

    private void setEnableComboBox(Button button, boolean isEnable) {
        int index = this.getIndex(button);
        if (index > -1) {
            this.comboBoxes[index].setEnabled(isEnable);
        }
    }

    private void unCheckedButton(int type) {
        this.checkedButton(type, null);
        switch (type) {
            case 0: {
                this.startCol = 0;
                this.endCol = 1;
                break;
            }
            case 1: {
                this.startRow = 0;
                this.endRow = 1;
            }
        }
    }

    private void checkedButton(int type, Button button) {
        switch (type) {
            case 0: {
                if (this.selectedColButton != null) {
                    this.selectedColButton.setSelection(false);
                    this.setEnableComboBox(this.selectedColButton, true);
                }
                this.selectedColButton = button;
                break;
            }
            case 1: {
                if (this.selectedRowButton != null) {
                    this.selectedRowButton.setSelection(false);
                    this.setEnableComboBox(this.selectedRowButton, true);
                }
                this.selectedRowButton = button;
            }
        }
        this.setEnableComboBox(button, false);
    }

    private boolean openRangeDialog(int colIndex, int rowIndex, int type) {
        int totalCol = colIndex > -1 ? this.comboBoxes[colIndex].getItemCount() : 1;
        int totalRow = rowIndex > -1 ? this.comboBoxes[rowIndex].getItemCount() : 1;
        int tmpStartCol = this.startCol;
        int tmpEndCol = this.endCol;
        int tmpStartRow = this.startRow;
        int tmpEndRow = this.endRow;
        switch (type) {
            case 0: {
                tmpStartCol = 0;
                tmpEndCol = totalCol;
                break;
            }
            case 1: {
                tmpStartRow = 0;
                tmpEndRow = totalRow;
            }
        }
        RangeDialog rangeDialog = new RangeDialog(this.tableSC.getShell(), totalCol, totalRow);
        if (rangeDialog.open(colIndex > -1, rowIndex > -1, tmpStartCol, tmpEndCol, tmpStartRow, tmpEndRow) == 0) {
            this.startCol = rangeDialog.getFromCol();
            this.endCol = rangeDialog.getToCol();
            this.startRow = rangeDialog.getFromRow();
            this.endRow = rangeDialog.getToRow();
            return true;
        }
        return false;
    }

    private void setRowButton(Button button) {
        boolean checked = button.getSelection();
        int colIndex = this.getIndex(this.selectedColButton);
        int rowIndex = this.getIndex(button);
        if (!checked) {
            this.unCheckedButton(1);
            this.disposeTable();
            return;
        }
        button.setSelection(!checked);
        if (this.openRangeDialog(colIndex, rowIndex, 1)) {
            if (colIndex == rowIndex) {
                this.unCheckedButton(0);
            }
            this.checkedButton(1, button);
            button.setSelection(checked);
            this.disposeTable();
        }
    }

    private void setColButton(Button button) {
        boolean checked = button.getSelection();
        int colIndex = this.getIndex(button);
        int rowIndex = this.getIndex(this.selectedRowButton);
        if (!checked) {
            this.unCheckedButton(0);
            this.disposeTable();
            return;
        }
        button.setSelection(!checked);
        if (this.openRangeDialog(colIndex, rowIndex, 0)) {
            if (colIndex == rowIndex) {
                this.unCheckedButton(1);
            }
            this.checkedButton(0, button);
            button.setSelection(checked);
            this.disposeTable();
        }
    }

    private int getIndex(Button button) {
        if (button == null) {
            return -1;
        }
        return (Integer)button.getData();
    }

    protected void resetRangeAction() {
        int rowIndex;
        int colIndex = this.getIndex(this.selectedColButton);
        if (this.openRangeDialog(colIndex, rowIndex = this.getIndex(this.selectedRowButton), -1)) {
            this.disposeTable();
            this.updateTable(colIndex, rowIndex);
        }
    }
}

