/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.ui.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.internal.ui.UIDebugManager;
import org.eclipse.ptp.debug.internal.ui.actions.RegisterAction;
import org.eclipse.ptp.debug.internal.ui.actions.ResumeAction;
import org.eclipse.ptp.debug.internal.ui.actions.StepIntoAction;
import org.eclipse.ptp.debug.internal.ui.actions.StepOverAction;
import org.eclipse.ptp.debug.internal.ui.actions.StepReturnAction;
import org.eclipse.ptp.debug.internal.ui.actions.SuspendAction;
import org.eclipse.ptp.debug.internal.ui.actions.TerminateAction;
import org.eclipse.ptp.debug.internal.ui.actions.UnregisterAction;
import org.eclipse.ptp.debug.internal.ui.actions.UpdateVariablesAction;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.events.IDebugActionEvent;
import org.eclipse.ptp.debug.ui.events.IResumedDebugEvent;
import org.eclipse.ptp.debug.ui.events.ISuspendedDebugEvent;
import org.eclipse.ptp.debug.ui.events.ITerminatedDebugEvent;
import org.eclipse.ptp.debug.ui.listeners.IDebugActionUpdateListener;
import org.eclipse.ptp.ui.actions.ParallelAction;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.ParallelJobView;
import org.eclipse.ui.IActionBars;

public class ParallelDebugView
extends ParallelJobView
implements IDebugActionUpdateListener {
    private static ParallelDebugView instance = null;
    protected ParallelAction resumeAction = null;
    protected ParallelAction suspendAction = null;
    protected ParallelAction terminateAction = null;
    protected ParallelAction stepIntoAction = null;
    protected ParallelAction stepOverAction = null;
    protected ParallelAction stepReturnAction = null;
    protected ParallelAction registerAction = null;
    protected ParallelAction unregisterAction = null;

    public ParallelDebugView() {
        instance = this;
        this.manager = PTPDebugUIPlugin.getDefault().getUIDebugManager();
        ((UIDebugManager)this.manager).addDebugEventListener(this);
    }

    public void dispose() {
        ((UIDebugManager)this.manager).removeDebugEventListener(this);
        super.dispose();
    }

    public static ParallelDebugView getDebugViewInstance() {
        if (instance == null) {
            instance = new ParallelDebugView();
        }
        return instance;
    }

    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.appendToGroup("actiongroup", (IAction)this.resumeAction);
        manager.appendToGroup("actiongroup", (IAction)this.suspendAction);
        manager.appendToGroup("actiongroup", (IAction)this.terminateAction);
        manager.appendToGroup("actiongroup", (IContributionItem)new Separator());
        manager.appendToGroup("actiongroup", (IAction)this.stepIntoAction);
        manager.appendToGroup("actiongroup", (IAction)this.stepOverAction);
        manager.appendToGroup("actiongroup", (IAction)this.stepReturnAction);
    }

    protected void createToolBarActions(IToolBarManager toolBarMgr) {
        this.resumeAction = new ResumeAction(this);
        this.suspendAction = new SuspendAction(this);
        this.terminateAction = new TerminateAction(this);
        this.stepIntoAction = new StepIntoAction(this);
        this.stepOverAction = new StepOverAction(this);
        this.stepReturnAction = new StepReturnAction(this);
        this.registerAction = new RegisterAction(this);
        this.unregisterAction = new UnregisterAction(this);
        toolBarMgr.appendToGroup("actiongroup", (IAction)this.resumeAction);
        toolBarMgr.appendToGroup("actiongroup", (IAction)this.suspendAction);
        toolBarMgr.appendToGroup("actiongroup", (IAction)this.terminateAction);
        toolBarMgr.appendToGroup("actiongroup", (IContributionItem)new Separator());
        toolBarMgr.appendToGroup("actiongroup", (IAction)this.stepIntoAction);
        toolBarMgr.appendToGroup("actiongroup", (IAction)this.stepOverAction);
        toolBarMgr.appendToGroup("actiongroup", (IAction)this.stepReturnAction);
        toolBarMgr.appendToGroup("actiongroup", (IContributionItem)new Separator());
        toolBarMgr.appendToGroup("actiongroup", (IAction)this.registerAction);
        toolBarMgr.appendToGroup("actiongroup", (IAction)this.unregisterAction);
        super.buildInToolBarActions(toolBarMgr);
        this.createOrientationActions();
    }

    protected void createOrientationActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)new UpdateVariablesAction(this));
        viewMenu.add((IContributionItem)new Separator());
    }

    public void handleAction(int type, int index) {
        IElement element = this.canvas.getElement(index);
        if (type == 6) {
            if (element.isRegistered()) {
                IPJob job = ((UIDebugManager)this.manager).findJobById(this.getCurrentID());
                ((UIDebugManager)this.manager).focusOnDebugTarget(job, Integer.parseInt(element.getName()));
            }
        } else if (type == 5) {
            this.doubleClick(element);
        }
    }

    public void doubleClick(IElement element) {
        try {
            this.registerElement(element);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.errorDialog(this.getViewSite().getShell(), "Error", e.getStatus());
        }
    }

    public String[] getToolTipText(Object obj) {
        String[] header = super.getToolTipText(obj);
        IPJob job = ((UIDebugManager)this.manager).findJobById(this.getCurrentID());
        String variableText = ((UIDebugManager)this.manager).getValueText(job, ((IPProcess)obj).getTaskId());
        if (variableText != null && variableText.length() > 0) {
            return new String[]{header[0], variableText};
        }
        return header;
    }

    public void registerElement(IElement element) throws CoreException {
        if (element.isRegistered()) {
            ((UIDebugManager)this.manager).unregisterElements(new IElement[]{element});
        } else {
            ((UIDebugManager)this.manager).registerElements(new IElement[]{element});
        }
    }

    public void registerSelectedElements() throws CoreException {
        if (this.cur_element_set != null) {
            ((UIDebugManager)this.manager).registerElements(this.canvas.getSelectedElements());
        }
    }

    public void unregisterSelectedElements() throws CoreException {
        if (this.cur_element_set != null) {
            ((UIDebugManager)this.manager).unregisterElements(this.canvas.getSelectedElements());
        }
    }

    public void run() {
        System.out.println("------------ debug run");
        this.initialView();
        this.refresh();
    }

    public void start() {
        System.out.println("------------ debug start");
        this.refresh();
    }

    protected void updateAction() {
        super.updateAction();
        IPJob job = ((UIDebugManager)this.manager).findJobById(this.getCurrentID());
        boolean isDebugMode = ((UIDebugManager)this.manager).isDebugMode(job);
        boolean isRunning = ((UIDebugManager)this.manager).isRunning(job);
        this.registerAction.setEnabled(isRunning && isDebugMode);
        this.unregisterAction.setEnabled(isRunning && isDebugMode);
        this.suspendAction.setEnabled(isRunning && isDebugMode);
        this.terminateAction.setEnabled(isRunning);
        if (isRunning && isDebugMode) {
            IElementHandler elementHandler = this.getCurrentElementHandler();
            if (elementHandler != null) {
                IElementSet set = this.getCurrentSet();
                BitList suspendedTaskList = (BitList)job.getAttribute("suspended");
                BitList terminatedTaskList = (BitList)job.getAttribute("terminated");
                this.updateSuspendResumeButton(suspendedTaskList, set, terminatedTaskList);
                this.updateTerminateButton(terminatedTaskList, set, suspendedTaskList);
            }
        } else {
            this.setEnableResumeButtonGroup(false);
        }
    }

    public void updateSuspendResumeButton(BitList tasks, IElementSet set, BitList targetTasks) {
        if (set == null || tasks == null) {
            return;
        }
        boolean isEnabled = false;
        if (set.isRootSet()) {
            isEnabled = !tasks.isEmpty();
            this.suspendAction.setEnabled(set.size() != tasks.cardinality());
        } else {
            try {
                BitList setTasks = ((UIDebugManager)this.manager).getCurrentSetTasks(this.getCurrentID(), set.getID());
                isEnabled = setTasks.intersects(tasks);
                BitList refTasks = tasks.copy();
                refTasks.and(setTasks);
                this.suspendAction.setEnabled(set.size() != refTasks.cardinality());
            }
            catch (CoreException e) {
                PTPDebugUIPlugin.log(e);
            }
        }
        this.setEnableResumeButtonGroup(isEnabled);
    }

    private void setEnableResumeButtonGroup(boolean isEnabled) {
        this.resumeAction.setEnabled(isEnabled);
        this.stepIntoAction.setEnabled(isEnabled);
        this.stepOverAction.setEnabled(isEnabled);
    }

    public void updateTerminateButton(BitList tasks, IElementSet set, BitList targetTasks) {
        boolean isEnabled;
        if (set == null || tasks == null) {
            return;
        }
        int setSize = set.size();
        int totalTerminatedSize = tasks.cardinality();
        int totalSuspendedSize = targetTasks == null || targetTasks.isEmpty() ? 0 : targetTasks.cardinality();
        boolean bl = isEnabled = setSize != totalTerminatedSize;
        if (!set.isRootSet()) {
            try {
                BitList setTasks = ((UIDebugManager)this.manager).getCurrentSetTasks(this.getCurrentID(), set.getID());
                setSize = setTasks.cardinality();
                BitList refTasks = tasks.copy();
                refTasks.and(setTasks);
                totalTerminatedSize = refTasks.cardinality();
                boolean bl2 = isEnabled = setSize != totalTerminatedSize;
                if (isEnabled) {
                    BitList tarRefTasks = targetTasks.copy();
                    tarRefTasks.and(setTasks);
                    totalSuspendedSize = tarRefTasks.cardinality();
                }
            }
            catch (CoreException e) {
                PTPDebugUIPlugin.log(e);
            }
        }
        this.terminateAction.setEnabled(isEnabled);
        if (isEnabled) {
            this.setEnableResumeButtonGroup(totalSuspendedSize > 0);
            this.suspendAction.setEnabled(totalSuspendedSize == 0 || setSize != totalTerminatedSize + totalSuspendedSize);
        } else {
            this.setEnableResumeButtonGroup(false);
            this.suspendAction.setEnabled(false);
        }
    }

    public void handleDebugActionEvent(IDebugActionEvent event) {
        String job_id = event.getJobId();
        if (!job_id.equals(this.getCurrentID()) || !((UIDebugManager)this.manager).isDebugMode(job_id)) {
            return;
        }
        BitList tasks = (BitList)event.getSource();
        BitList targetTasks = (BitList)event.getTarget();
        IElementSet set = this.getCurrentSet();
        if (event instanceof ISuspendedDebugEvent || event instanceof IResumedDebugEvent) {
            this.updateSuspendResumeButton(tasks, set, targetTasks);
        } else if (event instanceof ITerminatedDebugEvent) {
            this.updateTerminateButton(tasks, set, targetTasks);
        }
    }
}

