/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.internal.ui;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.ptp.debug.external.core.IExtLaunchConfigurationConstants;
import org.eclipse.ptp.debug.external.internal.ui.ControlFactory;
import org.eclipse.ptp.debug.external.internal.ui.ExternalDebugUIMessages;
import org.eclipse.ptp.debug.external.internal.ui.IExtLaunchConfigurationComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class SDMPage
extends AbstractLaunchConfigurationTab
implements Observer {
    protected TabFolder fTabFolder;
    protected Text fGDBCommandText;
    protected Text fGDBInitText;
    private IExtLaunchConfigurationComponent fSolibBlock;
    private boolean fIsInitializing = false;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fTabFolder = new TabFolder(comp, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.createTabs(this.fTabFolder);
        this.fTabFolder.setSelection(0);
        this.setControl((Control)comp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IExtLaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        configuration.setAttribute(IExtLaunchConfigurationConstants.ATTR_GDB_INIT, "");
        if (this.fSolibBlock != null) {
            this.fSolibBlock.setDefaults(configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid;
        boolean bl = valid = this.fGDBCommandText.getText().length() != 0;
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(ExternalDebugUIMessages.getString("GDBDebuggerPage.0"));
            this.setMessage(null);
        }
        return valid;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        String gdbCommand = "gdb";
        String gdbInit = "";
        try {
            gdbCommand = configuration.getAttribute(IExtLaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            gdbInit = configuration.getAttribute(IExtLaunchConfigurationConstants.ATTR_GDB_INIT, "");
        }
        catch (CoreException coreException) {}
        if (this.fSolibBlock != null) {
            this.fSolibBlock.initializeFrom(configuration);
        }
        this.fGDBCommandText.setText(gdbCommand);
        this.fGDBInitText.setText(gdbInit);
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String gdbStr = this.fGDBCommandText.getText();
        gdbStr.trim();
        configuration.setAttribute(IExtLaunchConfigurationConstants.ATTR_DEBUG_NAME, gdbStr);
        gdbStr = this.fGDBInitText.getText();
        gdbStr.trim();
        configuration.setAttribute(IExtLaunchConfigurationConstants.ATTR_GDB_INIT, gdbStr);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.performApply(configuration);
        }
    }

    public String getName() {
        return ExternalDebugUIMessages.getString("GDBDebuggerPage.1");
    }

    protected Shell getShell() {
        return super.getShell();
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void update(Observable o, Object arg) {
        if (!this.isInitializing()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    public void createTabs(TabFolder tabFolder) {
        this.createMainTab(tabFolder);
        this.createSolibTab(tabFolder);
    }

    public void createMainTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ExternalDebugUIMessages.getString("GDBDebuggerPage.2"));
        Composite comp = ControlFactory.createCompositeEx((Composite)this.fTabFolder, 1, 1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        tabItem.setControl((Control)comp);
        Composite subComp = ControlFactory.createCompositeEx(comp, 3, 768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel(subComp, ExternalDebugUIMessages.getString("GDBDebuggerPage.3"));
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBCommandText = ControlFactory.createTextField(subComp, 2052);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!SDMPage.this.isInitializing()) {
                    SDMPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button button = this.createPushButton(subComp, ExternalDebugUIMessages.getString("GDBDebuggerPage.4"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBButtonSelected();
                SDMPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(SDMPage.this.getShell(), 0);
                dialog.setText(ExternalDebugUIMessages.getString("GDBDebuggerPage.5"));
                String gdbCommand = SDMPage.this.fGDBCommandText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                SDMPage.this.fGDBCommandText.setText(res);
            }
        });
        label = ControlFactory.createLabel(subComp, ExternalDebugUIMessages.getString("GDBDebuggerPage.6"));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBInitText = ControlFactory.createTextField(subComp, 2052);
        gd = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gd);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!SDMPage.this.isInitializing()) {
                    SDMPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        button = this.createPushButton(subComp, ExternalDebugUIMessages.getString("GDBDebuggerPage.7"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBInitButtonSelected();
                SDMPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBInitButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(SDMPage.this.getShell(), 0);
                dialog.setText(ExternalDebugUIMessages.getString("GDBDebuggerPage.8"));
                String gdbCommand = SDMPage.this.fGDBInitText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                SDMPage.this.fGDBInitText.setText(res);
            }
        });
        label = ControlFactory.createLabel(comp, ExternalDebugUIMessages.getString("GDBDebuggerPage.9"), 200, -1, 64);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 200;
        label.setLayoutData((Object)gd);
    }

    public void createSolibTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ExternalDebugUIMessages.getString("GDBDebuggerPage.10"));
        Composite comp = ControlFactory.createCompositeEx((Composite)this.fTabFolder, 1, 1808);
        tabItem.setControl((Control)comp);
    }

    public void dispose() {
        if (this.fSolibBlock != null) {
            if (this.fSolibBlock instanceof Observable) {
                ((Observable)((Object)this.fSolibBlock)).deleteObserver(this);
            }
            this.fSolibBlock.dispose();
        }
        super.dispose();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }
}

