/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.internal.ui.preferences;

import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.external.internal.ui.preferences.PreferenceMessages;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.ui.preferences.AbstractPerferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SDMPreferencePage
extends AbstractPerferencePage {
    private Text sdmPathText = null;
    private Text sdmHostText = null;
    private Text sdmBackendPathText = null;
    private Combo sdmBackendCombo = null;
    private Button sdmPathButton = null;
    protected WidgetListener listener = new WidgetListener();

    public SDMPreferencePage() {
        this.setPreferenceStore(PTPDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferenceMessages.getString("SDMPreferencePage.sdm_desc"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createSDMSetting(composite);
        this.setValues();
        return composite;
    }

    protected void createSDMSetting(Composite parent) {
        Composite group = this.createGroupComposite(parent, 1, false, PreferenceMessages.getString("SDMPreferencePage.sdm_group"));
        Composite comp = this.createComposite(group, 3);
        new Label(comp, 0).setText(PreferenceMessages.getString("SDMPreferencePage.sdm_host"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.sdmHostText = new Text(comp, 2052);
        this.sdmHostText.setLayoutData((Object)gd);
        this.sdmHostText.addModifyListener((ModifyListener)this.listener);
        new Label(comp, 0).setText(PreferenceMessages.getString("SDMPreferencePage.sdm_backend"));
        this.sdmBackendCombo = new Combo(comp, 8);
        this.sdmBackendCombo.setLayoutData((Object)gd);
        this.sdmBackendCombo.setItems(IPDebugConstants.DEBUGGER_BACKENDS);
        this.sdmBackendCombo.addSelectionListener((SelectionListener)this.listener);
        new Label(comp, 0).setText(PreferenceMessages.getString("SDMPreferencePage.sdm_backend_path"));
        this.sdmBackendPathText = new Text(comp, 2052);
        this.sdmBackendPathText.setLayoutData((Object)gd);
        this.sdmBackendPathText.addModifyListener((ModifyListener)this.listener);
        new Label(comp, 0).setText(PreferenceMessages.getString("SDMPreferencePage.sdm_selection"));
        this.sdmPathText = new Text(comp, 2052);
        this.sdmPathText.setLayoutData((Object)new GridData(768));
        this.sdmPathText.addModifyListener((ModifyListener)this.listener);
        this.sdmPathButton = this.createButton(comp, PreferenceMessages.getString("SDMPreferencePage.browse_1"), 8);
        this.sdmPathButton.addSelectionListener((SelectionListener)this.listener);
    }

    public void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.sdmPathText.setText(store.getDefaultString(IPDebugConstants.PREF_PTP_DEBUGGER_FILE));
        this.sdmHostText.setText(store.getDefaultString(IPDebugConstants.PREF_PTP_DEBUGGER_HOST));
        this.sdmBackendCombo.select(this.sdmBackendCombo.indexOf(store.getDefaultString(IPDebugConstants.PREF_PTP_DEBUGGER_BACKEND)));
        this.sdmBackendPathText.setText(store.getDefaultString(IPDebugConstants.PREF_PTP_DEBUGGER_BACKEND_PATH));
        super.performDefaults();
    }

    protected void setValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.sdmPathText.setText(store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_FILE));
        this.sdmHostText.setText(store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_HOST));
        this.sdmBackendCombo.select(this.sdmBackendCombo.indexOf(store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_BACKEND)));
        this.sdmBackendPathText.setText(store.getString(IPDebugConstants.PREF_PTP_DEBUGGER_BACKEND_PATH));
    }

    protected void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(IPDebugConstants.PREF_PTP_DEBUGGER_FILE, this.sdmPathText.getText());
        store.setValue(IPDebugConstants.PREF_PTP_DEBUGGER_HOST, this.sdmHostText.getText());
        store.setValue(IPDebugConstants.PREF_PTP_DEBUGGER_BACKEND, this.sdmBackendCombo.getItem(this.sdmBackendCombo.getSelectionIndex()));
        store.setValue(IPDebugConstants.PREF_PTP_DEBUGGER_BACKEND_PATH, this.sdmBackendPathText.getText());
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setValid(this.isValid());
    }

    public boolean performOk() {
        this.storeValues();
        PTPDebugUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    public boolean isValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.sdmPathText.getText();
        if (name == null) {
            this.setErrorMessage(PreferenceMessages.getString("SDMPreferencePage.no_sdm"));
            return false;
        }
        File sdmFile = new File(name);
        if (!sdmFile.isFile()) {
            this.setErrorMessage(PreferenceMessages.getString("SDMPreferencePage.Selection_must_be_file"));
            return false;
        }
        return true;
    }

    private void handleSDMButtonSelected() {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        String filePath = dialog.open();
        if (filePath != null) {
            this.sdmPathText.setText(filePath);
        }
    }

    private void handleSDMComboSelected() {
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == SDMPreferencePage.this.sdmPathButton) {
                SDMPreferencePage.this.handleSDMButtonSelected();
            } else if (source == SDMPreferencePage.this.sdmBackendCombo) {
                SDMPreferencePage.this.handleSDMComboSelected();
            }
        }

        public void modifyText(ModifyEvent e) {
            SDMPreferencePage.this.setValid(SDMPreferencePage.this.isValid());
        }
    }
}

