/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITargetConfiguration;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.launch.IPLaunchEvent;
import org.eclipse.ptp.debug.core.launch.IPLaunchListener;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.internal.core.breakpoint.PLineBreakpoint;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PSession;

public class PCDIDebugModel {
    private Map jobSets = new HashMap();
    private List jobListeners = new ArrayList();
    private Map sessions = new HashMap();

    public void addLaunchListener(IPLaunchListener listener) {
        if (!this.jobListeners.contains(listener)) {
            this.jobListeners.add(listener);
        }
    }

    public void removeLaunchListener(IPLaunchListener listener) {
        if (this.jobListeners.contains(listener)) {
            this.jobListeners.remove(listener);
        }
    }

    public void fireEvent(IPLaunchEvent event) {
        Iterator i = this.jobListeners.iterator();
        while (i.hasNext()) {
            ((IPLaunchListener)i.next()).handleLaunchEvent(event);
        }
    }

    public void shutdown() {
        Iterator i = this.sessions.values().iterator();
        while (i.hasNext()) {
            IPJob job;
            IPSession pSession = (IPSession)i.next();
            if (pSession == null || (job = pSession.getJob()).isAllStop()) continue;
            job.removeAllProcesses();
            pSession.getPCDISession().shutdown();
            try {
                System.out.println("-----PCDIDebugModel - waiting debugger to stop");
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.sessions.clear();
        this.jobSets.clear();
        this.jobListeners.clear();
    }

    public void shutdownSession(IPJob job) {
        IPSession pSession;
        if (job != null && (pSession = (IPSession)this.sessions.remove(job)) != null) {
            pSession.getPCDISession().shutdown();
        }
    }

    public IPCDISession getPCDISession(IPJob job) {
        IPSession pSession = (IPSession)this.sessions.get(job);
        if (pSession != null) {
            return pSession.getPCDISession();
        }
        return null;
    }

    public IPSession createDebuggerSession(IAbstractDebugger debugger, IPLaunch launch, IBinaryParser.IBinaryObject exe, int timeout, IProgressMonitor monitor) throws CoreException {
        PSession pSession = new PSession(debugger.createDebuggerSession(launch, exe, timeout, monitor));
        this.sessions.put(pSession.getJob(), pSession);
        pSession.getPCDISession().start(monitor);
        return pSession;
    }

    public static String getPluginIdentifier() {
        return PTPDebugCorePlugin.getUniqueIdentifier();
    }

    public void removeDebugTarget(IPLaunch launch, BitList tasks, boolean sendEvent) {
        launch.removeDebugTargets(tasks, sendEvent);
    }

    public void addNewDebugTargets(IPLaunch launch, BitList tasks, IPCDITarget[] targets, IBinaryParser.IBinaryObject file, boolean resumeTarget, boolean sendEvent) {
        IPDebugTarget[] debugTargets = this.newDebugTargets(launch, targets, file, true, false, resumeTarget);
        launch.addDebugTargets(debugTargets, tasks, sendEvent);
    }

    public IPDebugTarget[] newDebugTargets(final IPLaunch launch, final IPCDITarget[] cdiTargets, final IBinaryParser.IBinaryObject file, final boolean allowTerminate, final boolean allowDisconnect, final boolean resumeTarget) {
        final IPDebugTarget[] targets = new IPDebugTarget[cdiTargets.length];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) throws CoreException {
                int i = 0;
                while (i < targets.length) {
                    targets[i] = new PDebugTarget(launch, cdiTargets[i], null, file, allowTerminate, allowDisconnect);
                    IPCDITargetConfiguration config = cdiTargets[i].getConfiguration();
                    if (config.supportsResume() && resumeTarget) {
                        targets[i].resume();
                    }
                    ++i;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e);
            return new IPDebugTarget[0];
        }
        return targets;
    }

    public IPLineBreakpoint[] lineBreakpointsExists(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        IBreakpoint[] breakpoints = this.getPBreakpoints();
        ArrayList<IPLineBreakpoint> foundBreakpoints = new ArrayList<IPLineBreakpoint>(0);
        int i = 0;
        while (i < breakpoints.length) {
            IPLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof IPLineBreakpoint && this.sameSourceHandle(sourceHandle, (breakpoint = (IPLineBreakpoint)breakpoints[i]).getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getLineNumber() == lineNumber) {
                foundBreakpoints.add(breakpoint);
            }
            ++i;
        }
        return foundBreakpoints.toArray(new IPLineBreakpoint[foundBreakpoints.size()]);
    }

    public IPLineBreakpoint lineBreakpointExists(IPLineBreakpoint[] breakpoints, String job_id) throws CoreException {
        int i = 0;
        while (i < breakpoints.length) {
            String bpt_job_id = breakpoints[i].getJobId();
            if (bpt_job_id.equals("Global") || bpt_job_id.equals(job_id)) {
                return breakpoints[i];
            }
            ++i;
        }
        return null;
    }

    public boolean sameSourceHandle(String handle1, String handle2) {
        if (handle1 == null || handle2 == null) {
            return false;
        }
        Path path1 = new Path(handle1);
        Path path2 = new Path(handle2);
        if (path1.isValidPath(handle1) && path2.isValidPath(handle2)) {
            return path1.equals((Object)path2);
        }
        return handle1.equals(handle2);
    }

    public IBreakpoint createLineBreakpoint(String sourceHandle, IResource resource, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register, String set_id, String job_id, String jobName) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", PTPDebugCorePlugin.getUniqueIdentifier());
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.ptp.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.ptp.debug.core.condition", condition);
        attributes.put("org.eclipse.ptp.debug.core.setid", set_id);
        attributes.put("org.eclipse.ptp.debug.core.cursetid", set_id);
        attributes.put("org.eclipse.ptp.debug.core.jobid", job_id);
        attributes.put("org.eclipse.ptp.debug.core.jobname", jobName);
        return new PLineBreakpoint(resource, attributes, register);
    }

    public IBreakpoint[] getPBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(PCDIDebugModel.getPluginIdentifier());
    }

    public IBreakpoint[] findPBreakpointsBySet(String job_id, String set_id) throws CoreException {
        ArrayList<IPLineBreakpoint> bptList = new ArrayList<IPLineBreakpoint>();
        IBreakpoint[] breakpoints = this.getPBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            IPLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof IPLineBreakpoint && (breakpoint = (IPLineBreakpoint)breakpoints[i]).getJobId().equals(job_id) && breakpoint.getSetId().equals(set_id)) {
                bptList.add(breakpoint);
            }
            ++i;
        }
        return bptList.toArray(new IBreakpoint[bptList.size()]);
    }

    public IPBreakpoint[] findPBreakpointsByJob(String job_id, boolean includeGlobal) throws CoreException {
        ArrayList<IPBreakpoint> bptList = new ArrayList<IPBreakpoint>();
        IBreakpoint[] breakpoints = this.getPBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            IPBreakpoint breakpoint;
            String bp_job_id;
            if (breakpoints[i] instanceof IPBreakpoint && ((bp_job_id = (breakpoint = (IPBreakpoint)breakpoints[i]).getJobId()).equals(job_id) || includeGlobal && bp_job_id.equals("Global"))) {
                bptList.add(breakpoint);
            }
            ++i;
        }
        return bptList.toArray(new IPBreakpoint[bptList.size()]);
    }

    public void deletePBreakpointBySet(final String job_id, final String set_id) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IBreakpoint[] breakpoints = PCDIDebugModel.this.findPBreakpointsBySet(job_id, set_id);
                if (breakpoints.length > 0) {
                    new Job(this, "Remove breakpoint", breakpoints){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ IBreakpoint[] val$breakpoints;
                        {
                            this.this$1 = var1_1;
                            this.val$breakpoints = iBreakpointArray;
                        }

                        protected IStatus run(IProgressMonitor pmonitor) {
                            try {
                                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(this.val$breakpoints, true);
                                return Status.OK_STATUS;
                            }
                            catch (CoreException e) {
                                PTPDebugCorePlugin.log(e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                    }.schedule();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    public void deletePBreakpointBySet(final String job_id) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IBreakpoint[] breakpoints = PCDIDebugModel.this.findPBreakpointsByJob(job_id, false);
                if (breakpoints.length > 0) {
                    new Job(this, "Remove breakpoint", breakpoints){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ IBreakpoint[] val$breakpoints;
                        {
                            this.this$1 = var1_1;
                            this.val$breakpoints = iBreakpointArray;
                        }

                        protected IStatus run(IProgressMonitor pmonitor) {
                            try {
                                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(this.val$breakpoints, true);
                                return Status.OK_STATUS;
                            }
                            catch (CoreException e) {
                                PTPDebugCorePlugin.log(e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                    }.schedule();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    public void updatePBreakpoints(final String set_id) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                new Job(this, "Update breakpoint", set_id){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ String val$set_id;
                    {
                        this.this$1 = var1_1;
                        this.val$set_id = string;
                    }

                    protected IStatus run(IProgressMonitor pmonitor) {
                        IBreakpoint[] breakpoints = 6.access$0(this.this$1).getPBreakpoints();
                        try {
                            int i = 0;
                            while (i < breakpoints.length) {
                                if (breakpoints[i] instanceof IPBreakpoint) {
                                    IPBreakpoint breakpoint = (IPBreakpoint)breakpoints[i];
                                    breakpoint.setCurSetId(this.val$set_id);
                                }
                                ++i;
                            }
                            return Status.OK_STATUS;
                        }
                        catch (CoreException e) {
                            PTPDebugCorePlugin.log(e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                }.schedule();
            }

            static /* synthetic */ PCDIDebugModel access$0(6 var0) {
                return var0.PCDIDebugModel.this;
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    public void newJob(String job_id, int totalTasks) throws CoreException {
        BitList rootTasks = new BitList(totalTasks);
        rootTasks.set(0, totalTasks);
        this.createSet(job_id, "Root", rootTasks);
    }

    public void createSet(String job_id, String set_id, BitList tasks) throws CoreException {
        JobSet jobSet = this.getJobSet(job_id);
        jobSet.createSet(set_id, tasks);
    }

    public void addTasks(String job_id, String set_id, BitList tasks) throws CoreException {
        JobSet jobSet = this.getJobSet(job_id);
        jobSet.addTasks(set_id, tasks);
    }

    public void removeTasks(String job_id, String set_id, BitList tasks) throws CoreException {
        JobSet jobSet = this.getJobSet(job_id);
        jobSet.removeTasks(set_id, tasks);
    }

    public void deleteSet(String job_id, String set_id) throws CoreException {
        JobSet jobSet = this.getJobSet(job_id);
        jobSet.deleteSet(set_id);
    }

    public BitList getTasks(String job_id, String set_id) throws CoreException {
        JobSet jobSet = this.getJobSet(job_id);
        return jobSet.getTasks(set_id).copy();
    }

    public void deleteJob(String job_id) {
        this.getJobSet(job_id).clearAllSets();
        this.jobSets.remove(job_id);
    }

    private JobSet getJobSet(String job_id) {
        if (!this.jobSets.containsKey(job_id)) {
            this.jobSets.put(job_id, new JobSet());
        }
        return (JobSet)this.jobSets.get(job_id);
    }

    private class JobSet {
        private Map sets = new HashMap();

        JobSet() {
        }

        public void clearAllSets() {
            this.sets.clear();
        }

        public void createSet(String set_id, BitList tasks) throws CoreException {
            if (this.sets.containsKey(set_id)) {
                throw new CoreException((IStatus)new Status(4, PCDIDebugModel.getPluginIdentifier(), 4, "The set [" + set_id + "] is already existed.", null));
            }
            this.sets.put(set_id, tasks);
        }

        public void addTasks(String set_id, BitList tasks) throws CoreException {
            this.getTasks(set_id).or(tasks);
        }

        public void removeTasks(String set_id, BitList tasks) throws CoreException {
            this.getTasks(set_id).andNot(tasks);
        }

        public void deleteSet(String set_id) throws CoreException {
            if (!this.sets.containsKey(set_id)) {
                throw new CoreException((IStatus)new Status(4, PCDIDebugModel.getPluginIdentifier(), 4, "The set [" + set_id + "] is not found.", null));
            }
            this.sets.remove(set_id);
        }

        public BitList getTasks(String set_id) throws CoreException {
            if (!this.sets.containsKey(set_id)) {
                throw new CoreException((IStatus)new Status(4, PCDIDebugModel.getPluginIdentifier(), 4, "The set [" + set_id + "] is not found.", null));
            }
            return (BitList)this.sets.get(set_id);
        }
    }
}

