/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.debug.core.DebugCoreMessages;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.PCDIDebugModel;
import org.eclipse.ptp.debug.core.model.IPVariableManager;
import org.eclipse.ptp.debug.core.sourcelookup.IPSourceLocation;
import org.eclipse.ptp.debug.internal.core.IPDebugInternalConstants;
import org.eclipse.ptp.debug.internal.core.PDebugConfiguration;
import org.eclipse.ptp.debug.internal.core.PVariableManager;
import org.eclipse.ptp.debug.internal.core.sourcelookup.CommonSourceLookupDirector;
import org.eclipse.ptp.debug.internal.core.sourcelookup.PSourceLookupDirector;
import org.eclipse.ptp.debug.internal.core.sourcelookup.SourceUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PTPDebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.debug.core";
    public static final int INTERNAL_ERROR = 1000;
    private static PTPDebugCorePlugin plugin;
    private HashMap fDebugConfigurations;
    private static Logger logger;
    private Level loggingLevel = Level.FINE;
    private CommonSourceLookupDirector fCommonSourceLookupDirector;
    private static PCDIDebugModel debugModel;
    private static IPVariableManager variableManager;

    static {
        debugModel = null;
        variableManager = null;
    }

    public PTPDebugCorePlugin() {
        plugin = this;
    }

    public static PTPDebugCorePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getUniqueIdentifier() {
        if (PTPDebugCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPDebugCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(Throwable t) {
        DebugException de;
        IStatus status;
        Throwable top = t;
        if (t instanceof DebugException && (status = (de = (DebugException)t).getStatus()).getException() != null) {
            top = status.getException();
        }
        PTPDebugCorePlugin.log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, "Internal error logged from CDI Debug: ", top));
    }

    public static void log(IStatus status) {
        PTPDebugCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        PTPDebugCorePlugin.getDefault().getLog().log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, message, null));
    }

    private void initializeDebugConfiguration() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PTPDebugCorePlugin.getUniqueIdentifier(), "PTPDebugger");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fDebugConfigurations = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            PDebugConfiguration configType = new PDebugConfiguration(configurationElement);
            this.fDebugConfigurations.put(configType.getID(), configType);
            ++i;
        }
    }

    public IPDebugConfiguration[] getDebugConfigurations() {
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        return this.fDebugConfigurations.values().toArray(new IPDebugConfiguration[0]);
    }

    public IPDebugConfiguration getDebugConfiguration(String id) throws CoreException {
        IPDebugConfiguration dbgCfg;
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        if ((dbgCfg = (IPDebugConfiguration)this.fDebugConfigurations.get(id)) == null) {
            Status status = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 100, DebugCoreMessages.getString("CDebugCorePlugin.0"), null);
            throw new CoreException((IStatus)status);
        }
        return dbgCfg;
    }

    public static PCDIDebugModel getDebugModel() {
        return debugModel;
    }

    public static IPVariableManager getPVariableManager() {
        return variableManager;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        debugModel = new PCDIDebugModel();
        variableManager = new PVariableManager(debugModel);
        this.initializeCommonSourceLookupDirector();
    }

    public void stop(BundleContext context) throws Exception {
        debugModel.shutdown();
        this.disposeCommonSourceLookupDirector();
        super.stop(context);
    }

    private void initializeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector == null) {
            this.fCommonSourceLookupDirector = new CommonSourceLookupDirector();
            String newMemento = PTPDebugCorePlugin.getDefault().getPluginPreferences().getString(IPDebugInternalConstants.PREF_COMMON_SOURCE_CONTAINERS);
            if (newMemento.length() == 0) {
                this.convertSourceLocations(this.fCommonSourceLookupDirector);
            } else {
                try {
                    this.fCommonSourceLookupDirector.initializeFromMemento(newMemento);
                }
                catch (CoreException e) {
                    PTPDebugCorePlugin.log(e.getStatus());
                }
            }
        }
    }

    private void disposeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector != null) {
            this.fCommonSourceLookupDirector.dispose();
        }
    }

    public PSourceLookupDirector getCommonSourceLookupDirector() {
        return this.fCommonSourceLookupDirector;
    }

    private void convertSourceLocations(CommonSourceLookupDirector director) {
        director.setSourceContainers(SourceUtils.convertSourceLocations(this.getCommonSourceLocations()));
    }

    public IPSourceLocation[] getCommonSourceLocations() {
        return SourceUtils.getCommonSourceLocationsFromMemento(PTPDebugCorePlugin.getDefault().getPluginPreferences().getString(IPDebugConstants.PREF_SOURCE_LOCATIONS));
    }

    public Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
            Handler[] handlers = logger.getHandlers();
            int index = 0;
            while (index < handlers.length) {
                logger.removeHandler(handlers[index]);
                ++index;
            }
            ConsoleHandler console = new ConsoleHandler();
            console.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    String out = record.getLevel() + " : " + record.getSourceClassName() + "." + record.getSourceMethodName();
                    if (!record.getMessage().equals("")) {
                        out = String.valueOf(out) + " : " + record.getMessage();
                    }
                    out = String.valueOf(out) + "\n";
                    return out;
                }
            });
            console.setLevel(this.loggingLevel);
            logger.addHandler(console);
            logger.setLevel(this.loggingLevel);
        }
        return logger;
    }

    public String locateFragmentFile(String dir, String file) {
        Bundle[] frags = Platform.getFragments((Bundle)Platform.getBundle((String)PLUGIN_ID));
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        String os_arch = String.valueOf(os) + "." + arch;
        System.out.println("OS = '" + os + "', Architecture = '" + arch + "', OS_ARCH combo = '" + os_arch + "'");
        String ptp_version = (String)PTPDebugCorePlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
        System.out.println("PTP Version = " + ptp_version);
        int i = 0;
        while (i < frags.length) {
            Bundle frag = frags[i];
            URL path = frag.getEntry("/");
            try {
                URL local_path = Platform.asLocalURL((URL)path);
                String str_path = local_path.getPath();
                System.out.println("Fragment " + i + " path: '" + str_path + "'");
                int idx = str_path.indexOf(os_arch);
                if (idx > 0) {
                    System.out.println("\tCorrect fragment for our OS & arch");
                    String file_path = String.valueOf(str_path) + dir + "/" + file;
                    System.out.println("\tSearching for file in '" + file_path + "'");
                    File f = new File(file_path);
                    if (f.exists()) {
                        System.out.println("\t\t**** FOUND IT!");
                        return file_path;
                    }
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return null;
    }
}

