/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.aif;

import java.util.Random;
import org.eclipse.ptp.debug.core.aif.AIF;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.aif.IAIFTypeBool;
import org.eclipse.ptp.debug.core.aif.IAIFTypeChar;
import org.eclipse.ptp.debug.core.aif.IAIFTypeClass;
import org.eclipse.ptp.debug.core.aif.IAIFTypeEnum;
import org.eclipse.ptp.debug.core.aif.IAIFTypeFloat;
import org.eclipse.ptp.debug.core.aif.IAIFTypeInt;
import org.eclipse.ptp.debug.core.aif.IAIFTypeNamed;
import org.eclipse.ptp.debug.core.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.aif.IAIFTypeReference;
import org.eclipse.ptp.debug.core.aif.IAIFTypeString;
import org.eclipse.ptp.debug.core.aif.IAIFTypeStruct;
import org.eclipse.ptp.debug.core.aif.IAIFTypeUnion;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueArray;
import org.eclipse.ptp.debug.core.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeArray;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeBool;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeChar;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeClass;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeEnum;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeFloat;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeFunction;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeIncomplete;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeInt;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeNamed;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypePointer;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeReference;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeString;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeStruct;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeUnion;
import org.eclipse.ptp.debug.internal.core.aif.AIFTypeVoid;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueArray;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueBool;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueChar;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueClass;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueEnum;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueFloat;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueInt;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueNamed;
import org.eclipse.ptp.debug.internal.core.aif.AIFValuePointer;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueReference;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueString;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueStruct;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueUnion;
import org.eclipse.ptp.debug.internal.core.aif.AIFValueUnknown;

public class AIFFactory {
    public static final char FDS_ARRAY = '[';
    public static final char FDS_BOOL = 'b';
    public static final char FDS_CHAR = 'c';
    public static final char FDS_ENUM = '<';
    public static final char FDS_FLOAT = 'f';
    public static final char FDS_FUNCTION = '&';
    public static final char FDS_INT = 'i';
    public static final char FDS_POINTER = '^';
    public static final char FDS_STRING = 's';
    public static final char FDS_STRUCT_CLASS = '{';
    public static final char FDS_UNION = '(';
    public static final char FDS_VOID = 'v';
    public static final char FDS_REFERENCE = '>';
    public static final char FDS_NAMED = '%';
    public static final int FDS_FLOAT_SIZE_POS = 1;
    public static final int FDS_VOID_SIZE_POS = 1;
    public static final int FDS_INTEGER_SIGN_POS = 1;
    public static final int FDS_INTEGER_SIZE_POS = 2;
    public static final int FDS_RANGE_DOT_LEN = 2;
    public static final String SIGN_OPEN = "[";
    public static final String SIGN_CLOSE = "]";
    public static final String SIGN_STROKE = "|";
    public static final String SIGN_COMMA = ",";
    public static final String SIGN_EQUAL = "=";
    public static final String SIGN_SEMI_COLON = ";";
    public static final String SIGN_COLON = ":";
    public static final String SIGN_DOT = ".";
    public static final String FDS_STRUCT_END = ";;;}";
    public static final String FDS_CLASS_END = "}";
    public static final String FDS_UNION_END = ")";
    public static final String FDS_ENUM_END = ">";
    public static final String FDS_FUNCTION_END = "/";
    public static final String FDS_REFERENCE_END = "/";
    public static final String FDS_NAMED_END = "/";
    public static final int NO_SIZE = 0;
    public static final int SIZE_BOOL = 1;
    public static final int SIZE_CHAR = 1;
    public static final int SIZE_FLOAT = 4;
    public static final int SIZE_DOUBLE = 8;
    public static final int SIZE_INVALID = 0;
    public static final IAIFType UNKNOWNTYPE = new AIFTypeIncomplete();
    public static final IAIFValue UNKNOWNVALUE = new AIFValueUnknown(UNKNOWNTYPE);

    public static IAIFValue getAIFValue(IValueParent parent, IAIFType type, byte[] data) {
        if (data == null || data.length < 0) {
            return new AIFValueUnknown(type);
        }
        if (type instanceof IAIFTypeChar) {
            return new AIFValueChar((IAIFTypeChar)type, data);
        }
        if (type instanceof IAIFTypeFloat) {
            return new AIFValueFloat((IAIFTypeFloat)type, data);
        }
        if (type instanceof IAIFTypeInt) {
            return new AIFValueInt((IAIFTypeInt)type, data);
        }
        if (type instanceof IAIFTypeString) {
            return new AIFValueString((IAIFTypeString)type, data);
        }
        if (type instanceof IAIFTypeBool) {
            return new AIFValueBool((IAIFTypeBool)type, data);
        }
        if (type instanceof IAIFTypeArray) {
            return new AIFValueArray((IAIFTypeArray)type, data);
        }
        if (type instanceof IAIFTypeEnum) {
            return new AIFValueEnum((IAIFTypeEnum)type, data);
        }
        if (type instanceof IAIFTypePointer) {
            return new AIFValuePointer(parent, (IAIFTypePointer)type, data);
        }
        if (type instanceof IAIFTypeNamed) {
            return new AIFValueNamed(parent, (IAIFTypeNamed)type, data);
        }
        if (type instanceof IAIFTypeReference) {
            return new AIFValueReference(parent, (IAIFTypeReference)type, data);
        }
        if (type instanceof IAIFTypeStruct) {
            return new AIFValueStruct(parent, (IAIFTypeStruct)type, data);
        }
        if (type instanceof IAIFTypeUnion) {
            return new AIFValueUnion(parent, (IAIFTypeUnion)type, data);
        }
        if (type instanceof IAIFTypeClass) {
            return new AIFValueClass(parent, (IAIFTypeClass)type, data);
        }
        return new AIFValueUnknown(type);
    }

    public static int random_num(int min, int max) {
        Random generator = new Random();
        long range = (long)max - (long)min + 1L;
        long fraction = (long)((double)range * generator.nextDouble());
        return (int)(fraction + (long)min);
    }

    public static int getDigitPos(String format, int pos) {
        int len = format.length();
        while (pos < len) {
            char aChar = format.charAt(pos);
            if (!Character.isDigit(aChar)) break;
            ++pos;
        }
        return pos;
    }

    public static String extractFormat(String fmt, int start_pos, int end_pos) {
        return fmt.substring(start_pos, end_pos);
    }

    public static int getEndPosFromLast(String fmt, String regex) {
        return fmt.lastIndexOf(regex);
    }

    public static int getEndPosFromStart(String fmt, String regex) {
        return fmt.indexOf(regex);
    }

    public static IAIFType getAIFType(String fmt) {
        if (fmt == null || fmt.length() == 0) {
            System.out.println("        ======= null: " + fmt);
            return UNKNOWNTYPE;
        }
        switch (fmt.charAt(0)) {
            case 'c': {
                System.out.println("        ======= character: " + fmt);
                return new AIFTypeChar();
            }
            case 'f': {
                int float_size = Character.digit(fmt.charAt(1), 10);
                System.out.println("        ======= floating: " + fmt + ", size: " + float_size);
                return new AIFTypeFloat(float_size);
            }
            case 'i': {
                boolean signed = fmt.charAt(1) == 's';
                int int_size = Character.digit(fmt.charAt(2), 10);
                System.out.println("        ======= int: " + fmt + ", size: " + int_size);
                return new AIFTypeInt(signed, int_size);
            }
            case 's': {
                System.out.println("        ======= string: " + fmt);
                return new AIFTypeString();
            }
            case 'b': {
                System.out.println("        ======= boolean: " + fmt);
                return new AIFTypeBool();
            }
            case '<': {
                System.out.println("        ======= enum: " + fmt);
                int enum_end_pos = AIFFactory.getEndPosFromLast(fmt, FDS_ENUM_END);
                String enum_type = fmt.substring(enum_end_pos + FDS_ENUM_END.length());
                return new AIFTypeEnum(AIFFactory.extractFormat(fmt, 1, enum_end_pos), AIFFactory.getAIFType(enum_type));
            }
            case '&': {
                System.out.println("        ======= function: " + fmt);
                int func_end_pos = AIFFactory.getEndPosFromLast(fmt, "/");
                String func_type = fmt.substring(func_end_pos + "/".length());
                return new AIFTypeFunction(AIFFactory.extractFormat(fmt, 1, func_end_pos), AIFFactory.getAIFType(func_type));
            }
            case '{': {
                int struct_end_pos = AIFFactory.getEndPosFromLast(fmt, FDS_STRUCT_END);
                if (fmt.length() == struct_end_pos + FDS_STRUCT_END.length()) {
                    System.out.println("        ======= struct " + fmt);
                    return new AIFTypeStruct(AIFFactory.extractFormat(fmt, 1, struct_end_pos));
                }
                struct_end_pos = AIFFactory.getEndPosFromLast(fmt, FDS_CLASS_END);
                System.out.println("        ======= class " + fmt);
                return new AIFTypeClass(AIFFactory.extractFormat(fmt, 1, struct_end_pos));
            }
            case '(': {
                System.out.println("        ======= union: " + fmt);
                int union_end_pos = AIFFactory.getEndPosFromLast(fmt, FDS_UNION_END);
                return new AIFTypeUnion(AIFFactory.extractFormat(fmt, 1, union_end_pos));
            }
            case '>': {
                System.out.println("        ======= reference: " + fmt);
                int ref_end_pos = AIFFactory.getEndPosFromStart(fmt, "/");
                return new AIFTypeReference(AIFFactory.extractFormat(fmt, 1, ref_end_pos));
            }
            case '^': {
                System.out.println("        ======= pointer: " + fmt);
                return new AIFTypePointer(AIFFactory.getAIFType(fmt.substring(1)));
            }
            case 'v': {
                System.out.println("        ======= void: " + fmt);
                int void_size = Character.digit(fmt.charAt(1), 10);
                return new AIFTypeVoid(void_size);
            }
            case '[': {
                System.out.println("        ======= array: " + fmt);
                int array_end_pos = AIFFactory.getEndPosFromLast(fmt, SIGN_CLOSE) + 1;
                return new AIFTypeArray(AIFFactory.extractFormat(fmt, 0, array_end_pos), AIFFactory.getAIFType(fmt.substring(array_end_pos)));
            }
            case '%': {
                System.out.println("        ======= named: " + fmt);
                int named_end_pos = AIFFactory.getEndPosFromStart(fmt, "/");
                return new AIFTypeNamed(AIFFactory.extractFormat(fmt, 1, named_end_pos), AIFFactory.getAIFType(fmt.substring(named_end_pos + 1)));
            }
        }
        System.out.println("        ======= unknown: " + fmt);
        return new AIFTypeIncomplete();
    }

    public static IAIF createAIFIndexedArray(IAIFValueArray parentType, int pos) {
        AIFValueArray value = new AIFValueArray(parentType, pos);
        return new AIF(parentType.getType(), value);
    }
}

