/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.launch;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.launch.IPLaunchEvent;
import org.eclipse.ptp.debug.core.launch.PDebugTargetRegisterEvent;
import org.eclipse.ptp.debug.core.launch.PDebugTargetUnRegisterEvent;
import org.eclipse.ptp.debug.core.launch.PLaunchStartedEvent;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPseudoProcess;

public class PLaunch
extends Launch
implements IPLaunch {
    private IPJob pJob;
    private Comparator targetComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            IPDebugTarget t0 = (IPDebugTarget)arg0;
            IPDebugTarget t1 = (IPDebugTarget)arg1;
            return t0.getTargetID() - t1.getTargetID();
        }
    };
    private Comparator processComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            IPseudoProcess t0 = (IPseudoProcess)arg0;
            IPseudoProcess t1 = (IPseudoProcess)arg1;
            return t0.getTargetID() - t1.getTargetID();
        }
    };

    public PLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
    }

    public IPJob getPJob() {
        return this.pJob;
    }

    public void setPJob(IPJob job) {
        this.pJob = job;
    }

    protected List getDebugTargets0() {
        List list = super.getDebugTargets0();
        Collections.sort(list, this.targetComparator);
        return list;
    }

    protected List getProcesses0() {
        List list = super.getProcesses0();
        Collections.sort(list, this.processComparator);
        return list;
    }

    public IPDebugTarget getDebugTarget(int target_id) {
        Iterator i = this.getDebugTargets0().iterator();
        while (i.hasNext()) {
            IPDebugTarget debugTarget = (IPDebugTarget)i.next();
            if (debugTarget.getTargetID() != target_id) continue;
            return debugTarget;
        }
        return null;
    }

    public IPseudoProcess getDebugProcess(int target_id) {
        Iterator i = this.getProcesses0().iterator();
        while (i.hasNext()) {
            IPseudoProcess proc = (IPseudoProcess)i.next();
            if (proc.getTargetID() != target_id) continue;
            return proc;
        }
        return null;
    }

    public void removeDebugProcess(int target_id) {
        this.removeProcess(this.getDebugProcess(target_id));
    }

    public void removeDebugTargets(BitList tasks, boolean sendEvent) {
        int[] taskArray = tasks.toArray();
        int i = 0;
        while (i < taskArray.length) {
            this.pJob.findProcessByTaskId(taskArray[i]).setAttribute("ATTRIB_ISREGISTERED", (Object)new Boolean(false));
            IPDebugTarget debugTarget = this.getDebugTarget(taskArray[i]);
            this.removeDebugTarget(debugTarget);
            debugTarget.cleanup();
            ++i;
        }
        if (sendEvent) {
            this.fireEvent(new PDebugTargetUnRegisterEvent(this.pJob, tasks));
        }
    }

    public void addDebugTargets(IPDebugTarget[] debugTargets, BitList tasks, boolean sendEvent) {
        int i = 0;
        while (i < debugTargets.length) {
            this.pJob.findProcessByTaskId(debugTargets[i].getTargetID()).setAttribute("ATTRIB_ISREGISTERED", (Object)new Boolean(true));
            this.addDebugTarget(debugTargets[i]);
            ++i;
        }
        if (sendEvent) {
            this.fireEvent(new PDebugTargetRegisterEvent(this.pJob, tasks));
        }
    }

    public boolean isTerminated() {
        if (this.pJob != null) {
            return this.pJob.isAllStop();
        }
        return super.isTerminated();
    }

    public void fireEvent(IPLaunchEvent event) {
        PTPDebugCorePlugin.getDebugModel().fireEvent(event);
    }

    public void launchedStarted() {
        this.fireEvent(new PLaunchStartedEvent(this.pJob));
    }
}

