/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.PCDIDebugModel;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.model.IPVariableManager;

public class PVariableManager
implements IPVariableManager {
    private Map jobList = new HashMap();
    private List variables = new ArrayList();
    private PCDIDebugModel debugModel = null;

    public PVariableManager(PCDIDebugModel debugModel) {
        this.debugModel = debugModel;
    }

    public void shutdown() {
        this.variables.clear();
        this.jobList.clear();
    }

    public void addVariable(String variable_name) {
        if (!this.variables.contains(variable_name)) {
            this.variables.add(variable_name);
        }
    }

    public void removeVariable(String variable_name) {
        if (this.variables.contains(variable_name)) {
            this.variables.remove(variable_name);
        }
    }

    public String[] getVariables() {
        return this.variables.toArray(new String[0]);
    }

    public void removeAllVariables() {
        this.variables.clear();
    }

    public boolean hasVariable() {
        return this.variables.size() > 0;
    }

    public String[] getVariables(IPJob job) {
        if (this.jobList.containsKey(job.getIDString())) {
            return (String[])this.jobList.get(job.getIDString());
        }
        return new String[job.totalProcesses()];
    }

    public void setVariable(String job_id, String[] variableTexts) {
        this.jobList.put(job_id, variableTexts);
    }

    public void updateVariables(IPJob job, String set_id, IProgressMonitor monitor) throws CoreException {
        if (this.variables.size() == 0) {
            monitor.done();
            return;
        }
        if (job == null) {
            throw new CoreException((IStatus)new Status(4, PCDIDebugModel.getPluginIdentifier(), 4, "No job", null));
        }
        IPCDISession session = this.debugModel.getPCDISession(job);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PCDIDebugModel.getPluginIdentifier(), 4, "No session found", null));
        }
        String[] variableTexts = this.getVariables(job);
        BitList taskList = this.debugModel.getTasks(job.getIDString(), set_id);
        int[] tasks = taskList.toArray();
        monitor.beginTask("Updating " + tasks.length + " variables info...", tasks.length);
        int i = 0;
        while (i < tasks.length) {
            if (!monitor.isCanceled()) {
                variableTexts[tasks[i]] = this.getValue(session, tasks[i], set_id);
                monitor.worked(1);
            }
            ++i;
        }
        this.setVariable(job.getIDString(), variableTexts);
        monitor.done();
    }

    public void cleanVariables(IPJob job) {
        if (this.jobList.containsKey(job.getIDString())) {
            this.jobList.remove(job.getIDString());
        }
    }

    public String getValueText(IPJob job, int taskID) {
        String[] variableTexts;
        if (this.hasVariable() && (variableTexts = this.getVariables(job)).length > 0 && taskID < variableTexts.length) {
            if (variableTexts[taskID] != null) {
                return variableTexts[taskID];
            }
            return "No value found.";
        }
        return "";
    }

    private String getValue(IPCDISession session, int taskID, String set_id) {
        String content = "<u>Set: " + set_id + "</u><br>";
        Iterator i = this.variables.iterator();
        while (i.hasNext()) {
            String variable = (String)i.next();
            content = String.valueOf(content) + "-<i>" + variable + ":</i> ";
            try {
                IAIF aif = session.getExpressionValue(taskID, variable);
                content = String.valueOf(content) + aif.getValue().getValueString();
            }
            catch (PCDIException pCDIException) {
                content = String.valueOf(content) + "Unknown";
            }
            catch (AIFException aIFException) {
                content = String.valueOf(content) + "Unknown";
            }
            content = String.valueOf(content) + "<br>";
        }
        return content;
    }
}

