/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.aif.IAIFTypeRange;
import org.eclipse.ptp.debug.internal.core.aif.TypeDerived;

public class AIFTypeArray
extends TypeDerived
implements IAIFTypeArray {
    private List ranges = new ArrayList();
    private int size = 1;

    public AIFTypeArray(String format, IAIFType basetype) {
        super(basetype);
        this.parse(format);
    }

    public int getDimension() {
        return this.ranges.size();
    }

    public int sizeof() {
        return this.size;
    }

    public IAIFTypeRange[] getRanges() {
        return this.ranges.toArray(new IAIFTypeRange[0]);
    }

    public IAIFTypeRange getRange(int index) {
        return (IAIFTypeRange)this.ranges.get(index);
    }

    public int getLower(int index) {
        return this.getRange(index).getLower();
    }

    public int getUpper(int index) {
        return this.getRange(index).getUpper();
    }

    public IAIFType getInternalType(int index) {
        return this.getRange(index).getInternalType();
    }

    private void parse(String fmt) {
        while (fmt.length() > 0) {
            fmt = this.parseRange(fmt);
        }
        this.size *= this.basetype.sizeof();
    }

    protected String parseRange(String fmt) {
        int pos = fmt.indexOf("]");
        this.ranges.add(this.getRange(fmt.substring(1, pos)));
        return fmt.substring(pos + 1);
    }

    protected IAIFTypeRange getRange(String fmt) {
        int low_pos = AIFFactory.getDigitPos(fmt, 1);
        int lower = Integer.parseInt(fmt.substring(1, low_pos));
        int up_pos = AIFFactory.getDigitPos(fmt, low_pos + 2);
        int upper = Integer.parseInt(fmt.substring(low_pos + 2, up_pos));
        this.size *= upper - lower + 1;
        return new AIFTypeRange(lower, upper, null);
    }

    public String toString(int dimension) {
        IAIFTypeRange range = (IAIFTypeRange)this.ranges.get(dimension);
        return "[r" + range.getLower() + ".." + range.getUpper() + "U" + "]";
    }

    public String toString() {
        String content = "";
        int i = 0;
        while (i < this.ranges.size()) {
            content = String.valueOf(content) + this.toString(i);
            ++i;
        }
        content = String.valueOf(content) + this.getBaseType().toString();
        return content;
    }

    class AIFTypeRange
    implements IAIFTypeRange {
        int lower;
        int upper;
        IAIFType interalType;

        AIFTypeRange(int lower, int upper, IAIFType interalType) {
            this.lower = lower;
            this.upper = upper;
            this.interalType = interalType;
        }

        public int getLower() {
            return this.lower;
        }

        public int getUpper() {
            return this.upper;
        }

        public IAIFType getInternalType() {
            return this.interalType;
        }
    }
}

