/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import java.nio.ByteBuffer;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFValue;

public abstract class AIFValue
implements IAIFValue {
    protected IAIFType type = null;
    protected String result = null;
    protected int size;

    public AIFValue(IAIFType type) {
        this.type = type;
    }

    public IAIFType getType() {
        return this.type;
    }

    public int getChildrenNumber() throws AIFException {
        return 0;
    }

    public boolean hasChildren() throws AIFException {
        return this.getChildrenNumber() > 0;
    }

    protected ByteBuffer byteBuffer(byte[] data) {
        return this.byteBuffer(data, 0);
    }

    protected ByteBuffer byteBuffer(byte[] data, int offset) {
        return ByteBuffer.wrap(data, offset, data.length);
    }

    protected byte[] createByteArray(byte[] data, int from, int size) {
        System.out.println("---data len: " + data.length + ", from: " + from + ", size: " + size);
        byte[] newByte = new byte[size];
        System.arraycopy(data, from, newByte, 0, size);
        return newByte;
    }

    public String toString() {
        try {
            return this.getValueString();
        }
        catch (AIFException e) {
            return "err: " + e.getMessage();
        }
    }

    protected abstract void parse(byte[] var1);

    public int sizeof() {
        return this.size;
    }
}

