/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import java.nio.ByteBuffer;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.aif.IAIFTypeRange;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueArray;
import org.eclipse.ptp.debug.core.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.aif.ValueDerived;

public class AIFValueArray
extends ValueDerived
implements IAIFValueArray {
    private Object[] values;
    private int current_dimension_position = 0;
    private int current_position = 0;

    public AIFValueArray(IAIFValueArray parentArray, int current_pos) {
        super((IAIFTypeArray)parentArray.getType());
        this.setParent(parentArray);
        this.current_dimension_position = parentArray.getCurrentDimensionPosition() + 1;
        this.current_position = current_pos;
    }

    public AIFValueArray(IAIFTypeArray type, byte[] data) {
        super(type);
        this.parse(data);
        this.setParent(this);
    }

    public int getChildrenNumber() throws AIFException {
        return this.getCurrentValues().length;
    }

    public int getCurrentDimensionPosition() {
        return this.current_dimension_position;
    }

    public int getCurrentPosition() {
        return this.current_position;
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = this.getString();
        }
        return this.result;
    }

    protected void parse(byte[] data) {
        IAIFTypeArray arrType = (IAIFTypeArray)this.type;
        ByteBuffer buffer = this.byteBuffer(data);
        this.values = this.parseRange(buffer, 1, arrType.getBaseType(), arrType.getDimension());
    }

    private Object[] parseRange(ByteBuffer dataBuf, int dim_pos, IAIFType baseType, int dimension) {
        IAIFTypeArray arrType = (IAIFTypeArray)this.type;
        IAIFTypeRange range = arrType.getRange(dim_pos - 1);
        int lower = range.getLower();
        int upper = range.getUpper();
        int inner_length = upper - lower + 1;
        Object[] innerValues = new Object[inner_length];
        int j = 0;
        while (j < inner_length) {
            if (dim_pos < dimension) {
                innerValues[j] = this.parseRange(dataBuf, dim_pos + 1, baseType, dimension);
            } else {
                byte[] dst = new byte[baseType.sizeof()];
                int h = 0;
                while (h < dst.length) {
                    if (!dataBuf.hasRemaining()) break;
                    dst[h] = dataBuf.get();
                    ++h;
                }
                innerValues[j] = AIFFactory.getAIFValue(null, baseType, dst);
                this.size += ((IAIFValue)innerValues[j]).sizeof();
            }
            ++j;
        }
        return innerValues;
    }

    public Object[] getValues() {
        if (this.values == null) {
            IValueParent tmpValue = this.getParent();
            if (tmpValue instanceof IAIFValueArray) {
                return ((IAIFValueArray)tmpValue).getValues();
            }
            return new Object[0];
        }
        return this.values;
    }

    private String getString() {
        return String.valueOf(this.getString("[", this.getValues())) + "]";
    }

    public String getString(String content, Object[] objs) {
        int i = 0;
        while (i < objs.length) {
            Object obj = objs[i];
            if (obj instanceof IAIFValue) {
                String tmp = obj.toString();
                content = tmp.length() == 0 ? content.substring(0, content.length() - 1) : String.valueOf(content) + obj.toString();
            } else if (obj instanceof Object[]) {
                content = String.valueOf(content) + this.getString("[", (Object[])obj) + "]";
            }
            if (i < objs.length - 1) {
                content = String.valueOf(content) + ",";
            }
            ++i;
        }
        return content;
    }

    public Object[] getCurrentValues() throws AIFException {
        int dimension = ((IAIFTypeArray)this.type).getDimension();
        if (this.current_dimension_position > dimension) {
            throw new AIFException("Dimension is out of bound");
        }
        if (this.current_dimension_position == 0) {
            return this.getValues();
        }
        IValueParent tmpValue = this.getParent();
        if (tmpValue instanceof IAIFValueArray) {
            Object[] objs = ((IAIFValueArray)tmpValue).getCurrentValues();
            return (Object[])objs[this.current_position];
        }
        return new Object[0];
    }

    public boolean hasMoreDimension(Object[] objs) {
        if (objs.length == 0) {
            return false;
        }
        return objs[0] instanceof Object[];
    }
}

