/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIFTypeChar;
import org.eclipse.ptp.debug.core.aif.IAIFValueChar;
import org.eclipse.ptp.debug.internal.core.aif.ValueIntegral;

public class AIFValueChar
extends ValueIntegral
implements IAIFValueChar {
    byte byteValue;

    public AIFValueChar(IAIFTypeChar type, byte[] data) {
        super(type);
        this.parse(data);
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = String.valueOf(this.charValue());
        }
        return this.result;
    }

    protected void parse(byte[] data) {
        this.byteValue = data[0];
        this.size = data.length;
    }

    public char charValue() throws AIFException {
        return (char)this.byteValue();
    }

    public byte byteValue() throws AIFException {
        return this.byteValue;
    }

    public String toString() {
        try {
            char charValue = this.charValue();
            return Character.isISOControl(charValue) && charValue != '\b' && charValue != '\t' && charValue != '\n' && charValue != '\f' && charValue != '\r' || charValue < '\u0000' ? "" : String.valueOf(charValue);
        }
        catch (AIFException e) {
            return "err: " + e.getMessage();
        }
    }
}

