/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIFTypeFloat;
import org.eclipse.ptp.debug.core.aif.IAIFValueFloat;
import org.eclipse.ptp.debug.internal.core.aif.ValueParent;

public class AIFValueFloat
extends ValueParent
implements IAIFValueFloat {
    ByteBuffer byteBuffer;

    public AIFValueFloat(IAIFTypeFloat type, byte[] data) {
        super(type);
        this.parse(data);
    }

    protected void parse(byte[] data) {
        this.byteBuffer = this.byteBuffer(data);
        this.size = data.length;
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = this.getString();
        }
        return this.result;
    }

    private String getString() throws AIFException {
        if (this.isFloat()) {
            return String.valueOf(this.floatValue());
        }
        if (this.isDouble()) {
            return String.valueOf(this.doubleValue());
        }
        return new String(this.byteBuffer.array());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float floatValue() throws AIFException {
        try {
            float f;
            try {
                f = this.byteBuffer.getFloat();
                Object var1_2 = null;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                Object var1_3 = null;
                this.byteBuffer.rewind();
                return 0.0f;
            }
            this.byteBuffer.rewind();
            return f;
        }
        catch (Throwable throwable) {
            Object var1_4 = null;
            this.byteBuffer.rewind();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double doubleValue() throws AIFException {
        try {
            double d = this.byteBuffer.getDouble();
            Object var1_2 = null;
            this.byteBuffer.rewind();
            return d;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            try {
                Object var1_3 = null;
                this.byteBuffer.rewind();
            }
            catch (Throwable throwable) {
                Object var1_4 = null;
                this.byteBuffer.rewind();
                throw throwable;
            }
            return 0.0;
        }
    }

    public boolean isDouble() {
        return this.type.sizeof() == 8;
    }

    public boolean isFloat() {
        return this.type.sizeof() == 4;
    }
}

