/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIFTypeInt;
import org.eclipse.ptp.debug.core.aif.IAIFValueInt;
import org.eclipse.ptp.debug.internal.core.aif.ValueIntegral;

public class AIFValueInt
extends ValueIntegral
implements IAIFValueInt {
    ByteBuffer byteBuffer;

    public AIFValueInt(IAIFTypeInt type, byte[] data) {
        super(type);
        this.parse(data);
    }

    protected void parse(byte[] data) {
        this.byteBuffer = this.byteBuffer(data);
        this.size = data.length;
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = this.getString();
        }
        return this.result;
    }

    private String getString() throws AIFException {
        if (this.isShort()) {
            return String.valueOf(this.shortValue());
        }
        if (this.isInt()) {
            return String.valueOf(this.intValue());
        }
        if (this.isLong()) {
            return String.valueOf(this.longValue());
        }
        return new String(this.byteValue());
    }

    public boolean isLong() {
        return this.size == 8;
    }

    public boolean isShort() {
        return this.size == 2;
    }

    public boolean isInt() {
        return this.size == 4;
    }

    public byte[] byteValue() throws AIFException {
        return this.byteBuffer.array();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long longValue() throws AIFException {
        try {
            long l;
            try {
                l = this.byteBuffer.getLong();
                Object var1_2 = null;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                Object var1_3 = null;
                this.byteBuffer.rewind();
                return 0L;
            }
            this.byteBuffer.rewind();
            return l;
        }
        catch (Throwable throwable) {
            Object var1_4 = null;
            this.byteBuffer.rewind();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short shortValue() throws AIFException {
        try {
            short s;
            try {
                s = this.byteBuffer.getShort();
                Object var1_2 = null;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                Object var1_3 = null;
                this.byteBuffer.rewind();
                return 0;
            }
            this.byteBuffer.rewind();
            return s;
        }
        catch (Throwable throwable) {
            Object var1_4 = null;
            this.byteBuffer.rewind();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int intValue() throws AIFException {
        try {
            int n;
            try {
                n = this.byteBuffer.getInt();
                Object var1_2 = null;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                Object var1_3 = null;
                this.byteBuffer.rewind();
                return 0;
            }
            this.byteBuffer.rewind();
            return n;
        }
        catch (Throwable throwable) {
            Object var1_4 = null;
            this.byteBuffer.rewind();
            throw throwable;
        }
    }
}

