/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueNamed;
import org.eclipse.ptp.debug.core.aif.IAIFValuePointer;
import org.eclipse.ptp.debug.core.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.aif.ValueDerived;
import org.eclipse.ptp.debug.internal.core.aif.ValueIntegral;

public class AIFValuePointer
extends ValueDerived
implements IAIFValuePointer {
    IAIFValue value;

    public AIFValuePointer(IValueParent parent, IAIFTypePointer type, byte[] data) {
        super(parent, type);
        this.parse(data);
    }

    public int getChildrenNumber() throws AIFException {
        return this.value.getChildrenNumber();
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = this.value.getValueString();
        }
        return this.result;
    }

    protected void parse(byte[] data) {
        System.err.println("------- total: " + data.length);
        byte marker = data[0];
        IAIFTypePointer pType = (IAIFTypePointer)this.type;
        System.err.println("--------------- marker: " + marker);
        switch (marker) {
            case 0: {
                this.value = AIFFactory.UNKNOWNVALUE;
                break;
            }
            case 1: {
                byte[] newByte = this.createByteArray(data, 1, data.length - 1);
                this.value = AIFFactory.getAIFValue(this.getParent(), pType.getBaseType(), newByte);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.value = AIFFactory.UNKNOWNVALUE;
            }
        }
        this.size = this.value.sizeof();
        System.err.println("--------------- pointer value: " + this.value.toString());
    }

    public BigInteger pointerValue() throws AIFException {
        return ValueIntegral.bigIntegerValue(this.getValueString());
    }

    public IAIFValue getValue() {
        if (this.value instanceof IAIFValueNamed) {
            return ((IAIFValueNamed)this.value).getValue();
        }
        return this.value;
    }
}

