/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIFTypeReference;
import org.eclipse.ptp.debug.core.aif.IAIFValueNamed;
import org.eclipse.ptp.debug.core.aif.IAIFValueReference;
import org.eclipse.ptp.debug.core.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.aif.ValueParent;

public class AIFValueReference
extends ValueParent
implements IAIFValueReference {
    private String name = null;

    public AIFValueReference(IValueParent parent, IAIFTypeReference type, byte[] data) {
        super(parent, type);
        this.parse(data);
        this.name = type.getName();
    }

    public String getName() {
        return this.name;
    }

    protected void parse(byte[] data) {
        this.size = data.length;
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = this.getParent() == null ? "unknown value" : "ref: " + this.getName();
        }
        return this.result;
    }

    public IValueParent getParent() {
        if (this.parent instanceof IAIFValueNamed && ((IAIFValueNamed)this.parent).getName().equals(this.getName())) {
            return this.parent.getParent();
        }
        if (this.parent == null) {
            return null;
        }
        this.parent = this.parent.getParent();
        return this.getParent();
    }
}

